/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1.tables;

import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.grib.grib1.tables.NcepTables;

public class NcepRfcTables
extends NcepTables {
    private static final Logger logger = LoggerFactory.getLogger(NcepRfcTables.class);
    private static Map<Integer, String> nwsoSubCenter;

    NcepRfcTables(Grib1ParamTables tables) {
        super(8, tables);
    }

    @Override
    @Nullable
    public String getGeneratingProcessName(int genProcess) {
        switch (genProcess) {
            case 150: {
                return "NWS River Forecast System (NWSRFS)";
            }
            case 151: {
                return "NWS Flash Flood Guidance System (NWSFFGS)";
            }
            case 152: {
                return "Quantitative Precipitation Estimation (QPE) - 1 hr dur";
            }
            case 154: {
                return "Quantitative Precipitation Estimation (QPE) - 6 hr dur";
            }
            case 155: {
                return "Quantitative Precipitation Estimation (QPE) - 24hr dur";
            }
            case 156: {
                return "Process 1 (P1) Precipitation Estimation - automatic";
            }
            case 157: {
                return "Process 1 (P1) Precipitation Estimation - manual";
            }
            case 158: {
                return "Process 2 (P2) Precipitation Estimation - automatic";
            }
            case 159: {
                return "Process 2 (P2) Precipitation Estimation - manual";
            }
            case 160: {
                return "Multisensor Precipitation Estimation (MPE) - automatic";
            }
            case 161: {
                return "Multisensor Precipitation Estimation (MPE) - manual";
            }
            case 165: {
                return "Enhanced MPE - automatic";
            }
            case 166: {
                return "Bias Enhanced MPE - automatic";
            }
            case 170: {
                return "Post Analysis of Precipitation Estimation (aggregate)";
            }
            case 171: {
                return "XNAV Aggregate Precipitation Estimation";
            }
            case 172: {
                return "Mountain Mapper Precipitation Estimation";
            }
            case 180: {
                return "Quantitative Precipitation Forecast (QPF)";
            }
            case 185: {
                return "NOHRSC_OPPS";
            }
            case 190: {
                return "Satellite Autoestimator Precipitation";
            }
            case 191: {
                return "Satellite Interactive Flash Flood Analyzer (IFFA)";
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getSubCenterName(int subcenter) {
        if (nwsoSubCenter == null) {
            nwsoSubCenter = NcepRfcTables.readNwsoSubCenter("resources/grib1/noaa_rfc/tableC.txt");
        }
        if (nwsoSubCenter == null) {
            return null;
        }
        return nwsoSubCenter.get(subcenter);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static Map<Integer, String> readNwsoSubCenter(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

