/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet.www;

import java.io.PrintWriter;
import java.util.Enumeration;
import opendap.dap.Attribute;
import opendap.dap.AttributeTable;
import opendap.dap.BaseType;
import opendap.dap.DAS;
import opendap.dap.DDS;
import opendap.dap.NoSuchAttributeException;
import opendap.servlet.www.BrowserForm;
import opendap.util.dasTools;

public class wwwOutPut {
    private static boolean _Debug = false;
    private int _attrRows;
    private int _attrCols;
    private PrintWriter pWrt;
    static final String legal_javascript_id_chars = "_0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public wwwOutPut(PrintWriter sink, int rows, int cols) {
        this._attrRows = rows;
        this._attrCols = cols;
        this.pWrt = sink;
    }

    public wwwOutPut(PrintWriter sink) {
        this(sink, 5, 70);
    }

    public static String nameForJsCode(String dodsName) {
        StringBuilder buf = new StringBuilder(dodsName);
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c == '-') {
                buf.replace(i, i + 1, "_");
                continue;
            }
            if (legal_javascript_id_chars.indexOf(c) >= 0) continue;
            String s = "_" + String.valueOf((int)c) + "_";
            buf.replace(i, i + 1, s);
        }
        return "dods_" + buf.toString();
    }

    public void writeDisposition(String requestURL) {
        this.pWrt.print("<tr><td align=\"right\">\n<h3><a href=\"https://opendap.github.io/documentation/QuickStart.html#_what_to_do_with_an_opendap_url\" valign=\"bottom\">Action:</a></h3>\n<td><input type=\"button\" value=\"Get ASCII\" onclick=\"ascii_button()\">\n<input type=\"button\" value=\"Get Binary\" onclick=\"binary_button()\">\n<input type=\"button\" value=\"Show Help\" onclick=\"help_button()\">\n<tr>\n<td align=\"right\">\n<h3><a href=\"https://opendap.github.io/documentation/QuickStart.html#_what_to_do_with_an_opendap_url\" valign=\"bottom\">Data URL:</a></h3><td><input name=\"url\" type=\"text\" size=" + this._attrCols + " value=\"" + requestURL + "\">\n");
    }

    public void writeGlobalAttributes(DAS das, DDS dds) {
        this.pWrt.print("<tr>\n<td align=\"right\" valign=\"top\">\n<h3><a href=\"https://opendap.github.io/documentation/QuickStart.html#_what_to_do_with_an_opendap_url\">Global Attributes:</a></h3>\n<td><textarea name=\"global_attr\" rows=" + this._attrRows + " cols=" + this._attrCols + ">\n");
        Enumeration edas = das.getNames();
        while (edas.hasMoreElements()) {
            String name = (String)edas.nextElement();
            if (dasTools.nameInKillFile((String)name) || !dasTools.nameIsGlobal((String)name) && dasTools.nameInDDS((String)name, (DDS)dds)) continue;
            try {
                AttributeTable attr = das.getAttributeTable(name);
                this.writeAttributes(attr);
            }
            catch (NoSuchAttributeException noSuchAttributeException) {}
        }
        this.pWrt.print("</textarea><p>\n\n");
    }

    public void writeAttributes(AttributeTable aTbl) {
        this.writeAttributes(aTbl, "");
    }

    public void writeAttributes(AttributeTable aTbl, String indent) {
        if (aTbl != null) {
            Enumeration e = aTbl.getNames();
            while (e.hasMoreElements()) {
                String aName = (String)e.nextElement();
                Attribute a = aTbl.getAttribute(aName);
                if (a == null) continue;
                if (a.isContainer()) {
                    this.pWrt.print(indent + aName + ":\n");
                    try {
                        this.writeAttributes(a.getContainer(), indent + "  ");
                    }
                    catch (NoSuchAttributeException noSuchAttributeException) {}
                    continue;
                }
                this.pWrt.print(indent + aName + ": ");
                if (_Debug) {
                    System.out.println("Getting attribute value enumeration for \"" + aName + "\"...");
                }
                try {
                    Enumeration es = a.getValues();
                    if (_Debug) {
                        System.out.println("Attribute Values enumeration: " + es);
                    }
                    int i = 0;
                    while (es.hasMoreElements()) {
                        String val = (String)es.nextElement();
                        if (_Debug) {
                            System.out.println("Value " + i + ": " + val);
                        }
                        this.pWrt.print(val);
                        if (es.hasMoreElements()) {
                            this.pWrt.print(", ");
                        }
                        ++i;
                    }
                }
                catch (NoSuchAttributeException noSuchAttributeException) {
                    // empty catch block
                }
                this.pWrt.println("");
            }
        }
    }

    public void writeVariableEntries(DAS das, DDS dds) {
        this.pWrt.print("<tr>\n<td align=\"right\" valign=\"top\">\n<h3><a href=\"https://opendap.github.io/documentation/QuickStart.html#_what_to_do_with_an_opendap_url\">Variables:</a></h3>\n<br><td>\n");
        Enumeration e = dds.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            ((BrowserForm)bt).printBrowserForm(this.pWrt, das);
            this.writeVariableAttributes(bt, das);
            this.pWrt.print("\n<p><p>\n\n");
            this.pWrt.print("<tr><td><td>\n\n");
        }
    }

    public void writeVariableAttributes(BaseType bt, DAS das) {
        try {
            AttributeTable attr = das.getAttributeTable(bt.getEncodedName());
            if (attr != null) {
                this.pWrt.print("<textarea name=\"" + bt.getLongName().replace('.', '_') + "_attr\" rows=" + this._attrRows + " cols=" + this._attrCols + ">\n");
                this.writeAttributes(attr);
                this.pWrt.print("</textarea>\n\n");
            }
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            // empty catch block
        }
    }

    public void writeSimpleVar(PrintWriter pw, BaseType bt) {
        String name = bt.getLongName().replace('.', '_');
        String type = dasTools.fancyTypeName((BaseType)bt);
        this.pWrt.print("<script type=\"text/javascript\">\n<!--\n" + wwwOutPut.nameForJsCode(name) + " = new dods_var(\"" + bt.getLongName() + "\", \"" + wwwOutPut.nameForJsCode(name) + "\", 0);\nDODS_URL.add_dods_var(" + wwwOutPut.nameForJsCode(name) + ");\n// -->\n</script>\n");
        this.pWrt.print("<b><input type=\"checkbox\" name=\"get_" + wwwOutPut.nameForJsCode(name) + "\"\nonclick=\"" + wwwOutPut.nameForJsCode(name) + ".handle_projection_change(get_" + wwwOutPut.nameForJsCode(name) + ")\">\n<font size=\"+1\">" + bt.getEncodedName() + "</font>: " + type + "</b><br>\n\n");
        this.pWrt.print(bt.getEncodedName() + " <select name=\"" + wwwOutPut.nameForJsCode(name) + "_operator\" onfocus=\"describe_operator()\" onchange=\"DODS_URL.update_url()\">\n<option value=\"=\" selected>=\n<option value=\"!=\">!=\n<option value=\"<\"><\n<option value=\"<=\"><=\n<option value=\">\">>\n<option value=\">=\">>=\n<option value=\"-\">--\n</select>\n");
        this.pWrt.print("<input type=\"text\" name=\"" + wwwOutPut.nameForJsCode(name) + "_selection\" size=12 onFocus=\"describe_selection()\" onChange=\"DODS_URL.update_url()\">\n");
        this.pWrt.print("<br>\n\n");
    }
}

