/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.util.ArrayList;
import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.DArray;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DodsV;
import ucar.nc2.util.rc.RC;

public class DODSVariable
extends Variable {
    protected String CE;
    protected DODSNetcdfFile dodsfile;
    protected String dodsShortName;

    Group common(DODSNetcdfFile dodsfile, Group parentGroup, String dodsShortName) {
        int sindex;
        this.dodsfile = dodsfile;
        this.dodsShortName = dodsShortName;
        if (dodsShortName.equals("time")) {
            boolean x = false;
        }
        if (RC.useGroups && (sindex = dodsShortName.indexOf(47)) >= 0) {
            Group g;
            assert (parentGroup != null);
            parentGroup = g = parentGroup.makeRelativeGroup((NetcdfFile)dodsfile, dodsShortName, true);
            dodsShortName = dodsShortName.substring(dodsShortName.lastIndexOf(47) + 1);
            this.setName(dodsShortName);
            this.setParentGroup(parentGroup);
        }
        parentGroup.addVariable((Variable)this);
        return parentGroup;
    }

    DODSVariable(DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String dodsShortName, DodsV dodsV) {
        super((NetcdfFile)dodsfile, parentGroup, parentStructure, DODSNetcdfFile.makeNetcdfName(dodsShortName));
        parentGroup = this.common(dodsfile, parentGroup, dodsShortName);
        this.setSPobject(dodsV);
    }

    DODSVariable(DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String dodsShortName, BaseType dodsScalar, DodsV dodsV) {
        super((NetcdfFile)dodsfile, parentGroup, parentStructure, DODSNetcdfFile.makeNetcdfName(dodsShortName));
        Dimension strlenDim;
        parentGroup = this.common(dodsfile, parentGroup, dodsShortName);
        this.setDataType(DODSNetcdfFile.convertToNCType(dodsScalar));
        if (DODSNetcdfFile.isUnsigned(dodsScalar)) {
            this.addAttribute(new Attribute("_Unsigned", "true"));
        }
        if (this.dataType == DataType.STRING && null != (strlenDim = dodsfile.getNetcdfStrlenDim(this))) {
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            if (strlenDim.getLength() != 0) {
                dims.add(dodsfile.getSharedDimension(parentGroup, strlenDim));
            }
            this.setDimensions(dims);
            this.setDataType(DataType.CHAR);
        } else {
            this.shape = new int[0];
        }
        this.setSPobject(dodsV);
    }

    DODSVariable(DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String dodsShortName, DArray dodsArray, BaseType elemType, DodsV dodsV) {
        super((NetcdfFile)dodsfile, parentGroup, parentStructure, dodsShortName);
        Dimension strlenDim;
        parentGroup = this.common(dodsfile, parentGroup, dodsShortName);
        this.setDataType(DODSNetcdfFile.convertToNCType(elemType));
        if (DODSNetcdfFile.isUnsigned(elemType)) {
            this.addAttribute(new Attribute("_Unsigned", "true"));
        }
        List<Dimension> dims = dodsfile.constructDimensions(parentGroup, dodsArray);
        if (this.dataType == DataType.STRING && null != (strlenDim = dodsfile.getNetcdfStrlenDim(this))) {
            if (strlenDim.getLength() != 0) {
                dims.add(dodsfile.getSharedDimension(parentGroup, strlenDim));
            }
            this.setDataType(DataType.CHAR);
        }
        this.setDimensions(dims);
        this.setSPobject(dodsV);
    }

    protected Variable copy() {
        return new DODSVariable(this);
    }

    protected DODSVariable(DODSVariable from) {
        super((Variable)from);
        this.dodsfile = from.dodsfile;
        this.dodsShortName = from.dodsShortName;
        this.CE = from.CE;
    }

    protected void setCE(String CE) {
        this.CE = CE;
    }

    protected boolean hasCE() {
        return this.CE != null;
    }

    protected String nameWithCE() {
        return this.hasCE() ? this.getShortName() + this.CE : this.getShortName();
    }

    protected String getDODSshortName() {
        return this.dodsShortName;
    }
}

