/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import java.util.List;
import opendap.dap.DArray;
import opendap.dap.DConstructor;
import opendap.dap.DSequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DodsV;

public class DODSStructure
extends Structure {
    private DConstructor ds;
    protected DODSNetcdfFile dodsfile;
    protected String dodsShortName;

    DODSStructure(DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String dodsShortName, DodsV dodsV) throws IOException {
        super((NetcdfFile)dodsfile, parentGroup, parentStructure, DODSNetcdfFile.makeNetcdfName(dodsShortName));
        this.dodsfile = dodsfile;
        this.ds = (DConstructor)dodsV.bt;
        this.dodsShortName = dodsShortName;
        if (this.ds instanceof DSequence) {
            this.dimensions.add(Dimension.VLEN);
            this.shape = new int[1];
        } else {
            this.shape = new int[0];
        }
        for (DodsV nested : dodsV.children) {
            dodsfile.addVariable(parentGroup, this, nested);
        }
        if (this.ds instanceof DSequence) {
            this.isVariableLength = true;
        }
        this.setSPobject(dodsV);
    }

    DODSStructure(DODSNetcdfFile dodsfile, Group parentGroup, Structure parentStructure, String shortName, DArray dodsArray, DodsV dodsV) throws IOException {
        this(dodsfile, parentGroup, parentStructure, shortName, dodsV);
        List<Dimension> dims = dodsfile.constructDimensions(parentGroup, dodsArray);
        this.setDimensions(dims);
        this.setSPobject(dodsV);
    }

    private DODSStructure(DODSStructure from) {
        super((Structure)from);
        this.dodsfile = from.dodsfile;
        this.dodsShortName = from.dodsShortName;
        this.ds = from.ds;
    }

    protected Variable copy() {
        return new DODSStructure(this);
    }

    DConstructor getDConstructor() {
        return this.ds;
    }

    protected String getDODSshortName() {
        return this.dodsShortName;
    }

    public StructureDataIterator getStructureIterator(String CE) throws IOException {
        return new SequenceIterator(CE);
    }

    private class SequenceIterator
    implements StructureDataIterator {
        private int nrows;
        private int row = 0;
        private ArrayStructure structArray;

        SequenceIterator(String CE) throws IOException {
            this.structArray = (ArrayStructure)DODSStructure.this.read();
            this.nrows = (int)this.structArray.getSize();
        }

        public boolean hasNext() {
            return this.row < this.nrows;
        }

        public StructureData next() {
            return this.structArray.getStructureData(this.row++);
        }

        public void setBufferSize(int bytes) {
        }

        public StructureDataIterator reset() {
            this.row = 0;
            return this;
        }

        public int getCurrentRecno() {
            return this.row - 1;
        }

        public void finish() {
        }
    }
}

