/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.StructureData;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DatatypeIterator;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.SequenceHelper;
import ucar.nc2.dt.point.StationObsDatasetImpl;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Station;

public class SequenceObsDataset
extends StationObsDatasetImpl
implements TypedDatasetFactoryIF {
    private Variable latVar;
    private Variable lonVar;
    private Variable altVar;
    private Variable timeVar;
    private Variable timeNominalVar;
    private Variable stationIdVar;
    private Variable stationDescVar;
    private Variable numStationsVar;
    private Structure sequenceVar;
    private SequenceHelper sequenceHelper;
    private boolean debugRead = false;
    private boolean fatal = false;

    public static boolean isValidFile(NetcdfFile ds) {
        if (!ds.findAttValueIgnoreCase(null, "cdm_data_type", "").equalsIgnoreCase(FeatureType.STATION.toString()) && !ds.findAttValueIgnoreCase(null, "cdm_datatype", "").equalsIgnoreCase(FeatureType.STATION.toString())) {
            return false;
        }
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equalsIgnoreCase("Unidata Sequence Observation Dataset v1.0")) continue;
            return true;
        }
        return false;
    }

    public boolean isMine(NetcdfDataset ds) {
        return SequenceObsDataset.isValidFile((NetcdfFile)ds);
    }

    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new SequenceObsDataset(ncd, task);
    }

    public SequenceObsDataset() {
    }

    public SequenceObsDataset(NetcdfDataset ds, CancelTask task) throws IOException {
        super(ds);
        this.sequenceVar = (Structure)this.findVariable(ds, "obs_sequence");
        this.latVar = this.findVariable(ds, "latitude_coordinate");
        this.lonVar = this.findVariable(ds, "longitude_coordinate");
        this.altVar = this.findVariable(ds, "zaxis_coordinate");
        this.timeVar = this.findVariable(ds, "time_coordinate");
        if (this.latVar == null) {
            this.parseInfo.append("Missing latitude variable");
            this.fatal = true;
        }
        if (this.lonVar == null) {
            this.parseInfo.append("Missing longitude variable");
            this.fatal = true;
        }
        if (this.altVar == null) {
            this.parseInfo.append("Missing altitude variable");
        }
        if (this.timeVar == null) {
            this.parseInfo.append("Missing time variable");
            this.fatal = true;
        }
        this.timeNominalVar = this.findVariable(ds, "time_nominal");
        this.stationIdVar = this.findVariable(ds, "station_id");
        this.stationDescVar = this.findVariable(ds, "station_description");
        this.numStationsVar = this.findVariable(ds, "number_stations");
        if (this.stationIdVar == null) {
            this.parseInfo.append("Missing station id variable");
            this.fatal = true;
        }
        this.title = ds.findAttValueIgnoreCase(null, "title", "");
        this.desc = ds.findAttValueIgnoreCase(null, "description", "");
    }

    private Variable getCoordinate(NetcdfDataset ds, Structure sequenceVar, AxisType a) {
        String axisType;
        Variable v;
        int i;
        List varList = ds.getVariables();
        for (i = 0; i < varList.size(); ++i) {
            v = (Variable)varList.get(i);
            axisType = ds.findAttValueIgnoreCase(v, "_CoordinateAxisType", null);
            if (axisType == null || !axisType.equals(a.toString())) continue;
            return v;
        }
        varList = sequenceVar.getVariables();
        for (i = 0; i < varList.size(); ++i) {
            v = (Variable)varList.get(i);
            axisType = ds.findAttValueIgnoreCase(v, "_CoordinateAxisType", null);
            if (axisType == null || !axisType.equals(a.toString())) continue;
            return v;
        }
        return null;
    }

    private Variable findVariable(NetcdfDataset ds, String name) {
        Variable result = ds.findVariable(name);
        if (result == null) {
            String aname = ds.findAttValueIgnoreCase(null, name + "_variable", null);
            if (aname == null) {
                aname = ds.findAttValueIgnoreCase(null, name, null);
            }
            if (aname != null) {
                result = ds.findVariable(aname);
            }
        }
        return result;
    }

    private Dimension findDimension(NetcdfDataset ds, String name) {
        String aname;
        Dimension result = ds.findDimension(name);
        if (result == null && (aname = ds.findAttValueIgnoreCase(null, name + "Dimension", null)) != null) {
            result = ds.findDimension(aname);
        }
        return result;
    }

    protected void setTimeUnits() {
    }

    protected void setStartDate() {
    }

    protected void setEndDate() {
    }

    protected void setBoundingBox() {
        this.boundingBox = this.stationHelper.getBoundingBox();
    }

    public List getData(CancelTask cancel) throws IOException {
        ArrayList allData = new ArrayList();
        for (int i = 0; i < this.getDataCount(); ++i) {
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return allData;
    }

    public int getDataCount() {
        Dimension unlimitedDim = this.ncfile.getUnlimitedDimension();
        return unlimitedDim.getLength();
    }

    public List getData(Station s, CancelTask cancel) throws IOException {
        return null;
    }

    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return null;
    }

    public static void main(String[] args) throws IOException {
        NetcdfDataset ds = NetcdfDataset.openDataset((String)"C:/data/ncml/oceanwatch.ncml");
        new SequenceObsDataset(ds, null);
    }

    private class SeqDatatypeIterator
    extends DatatypeIterator {
        protected Object makeDatatypeWithData(int recnum, StructureData sdata) {
            return null;
        }

        SeqDatatypeIterator(Structure struct, int bufferSize) {
            super(struct, bufferSize);
        }
    }
}

