/////////////////////////////////////////////////////////////////////////////
// This file is part of the "Java-DAP" project, a Java implementation
// of the OPeNDAP Data Access Protocol.
//
// Copyright (c) 2010, OPeNDAP, Inc.
// Copyright (c) 2002,2003 OPeNDAP, Inc.
// 
// Author: James Gallagher <jgallagher@opendap.org>
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms,
// with or without modification, are permitted provided
// that the following conditions are met:
// 
// - Redistributions of source code must retain the above copyright
//   notice, this list of conditions and the following disclaimer.
// 
// - Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the
//   documentation and/or other materials provided with the distribution.
// 
// - Neither the name of the OPeNDAP nor the names of its contributors may
//   be used to endorse or promote products derived from this software
//   without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
// IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
// PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
/////////////////////////////////////////////////////////////////////////////

package opendap.servers;

import java.util.List;
import java.io.PrintWriter;

/**
 * Represents the common interface of the two types of clause used by the
 * constraint expression (CE) parser: TopLevelClause and SubClause.
 * See these interfaces for more about CE parsing and evaluation.
 *
 * @author joew
 */
public interface Clause {

    /**
     * Returns an ordered list of this clause's sub-clauses.  If the
     * clause has no sub-clauses, an empty list will be returned.
     */
    public List getChildren();

    /**
     * A clause is considered "constant" iff it and its subclauses do not
     * refer to data values from the dataset being constrained.  A
     * constant clause is defined as soon as it is created, and is
     * guaranteed not to change its value during its lifetime.
     */
    public boolean isConstant();

    /**
     * Returns whether or not the clause has a defined value. Non-constant
     * clauses do not have a defined value until they are evaluated for the
     * first time. Methods for evaluating are found in the TopLevelClause
     * and SubClause interfaces.
     */
    public boolean isDefined();

    /**
     * Dump clause as in constraint form
     */
    public void printConstraint(PrintWriter os);
}


