/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.util.Iterator;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.unidata.util.StringUtil2;

public class DODSAttribute
extends Attribute {
    private static String[] escapeAttributeStrings = new String[]{"\\", "\""};
    private static String[] substAttributeStrings = new String[]{"\\\\", "\\\""};
    String dodsName = null;

    public DODSAttribute(String dodsName, opendap.dap.Attribute att) {
        super(DODSNetcdfFile.makeShortName(dodsName));
        Array data;
        this.setDODSName(DODSNetcdfFile.makeDODSName(dodsName));
        DataType ncType = DODSNetcdfFile.convertToNCType(att.getType(), false);
        int nvals = 0;
        Iterator iter = att.getValuesIterator();
        while (iter.hasNext()) {
            iter.next();
            ++nvals;
        }
        String[] vals = new String[nvals];
        iter = att.getValuesIterator();
        int count = 0;
        while (iter.hasNext()) {
            vals[count++] = (String)iter.next();
        }
        if (ncType == DataType.STRING) {
            data = Array.factory((DataType)ncType, (int[])new int[]{nvals}, (Object)vals);
        } else {
            try {
                data = Array.factory((DataType)ncType, (int[])new int[]{nvals});
                Index ima = data.getIndex();
                for (int i = 0; i < nvals; ++i) {
                    double dval = Double.parseDouble(vals[i]);
                    data.setDouble(ima.set(i), dval);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal Numeric Value for Attribute Value for " + dodsName);
            }
        }
        this.setValues(data);
        this.setImmutable();
    }

    protected DODSAttribute(String dodsName, String val) {
        super(DODSNetcdfFile.makeShortName(dodsName), val);
        this.setDODSName(DODSNetcdfFile.makeDODSName(dodsName));
    }

    private String unescapeAttributeStringValues(String value) {
        return StringUtil2.substitute((String)value, (String[])substAttributeStrings, (String[])escapeAttributeStrings);
    }

    public String getDODSName() {
        return this.dodsName;
    }

    public void setDODSName(String name) {
        this.dodsName = name;
    }

    public void resetShortName(String name) {
        this.setShortName(name);
    }
}

