/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.ClientIO;
import opendap.dap.DAPNode;
import opendap.dap.DConstructor;
import opendap.dap.DataReadException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.Util;

public class DSequence
extends DConstructor
implements ClientIO {
    protected static byte START_OF_INSTANCE = (byte)90;
    protected static byte END_OF_SEQUENCE = (byte)-91;
    protected Vector varTemplate = new Vector();
    protected Vector allValues = new Vector();
    private int level = 0;

    public DSequence() {
        this(null);
    }

    public DSequence(String n) {
        super(n);
    }

    @Override
    public String getTypeName() {
        return "Sequence";
    }

    protected final void setLevel(int level) {
        this.level = level;
    }

    protected final int getLevel() {
        return this.level;
    }

    @Override
    public int elementCount(boolean leaves) {
        if (!leaves) {
            return this.varTemplate.size();
        }
        int count = 0;
        Enumeration e = this.varTemplate.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            count += bt.elementCount(leaves);
        }
        return count;
    }

    @Override
    public void addVariable(BaseType v, int part) {
        v.setParent(this);
        this.varTemplate.addElement(v);
        if (v instanceof DSequence) {
            ((DSequence)v).setLevel(this.getLevel() + 1);
        }
    }

    public final void addRow(Vector row) {
        this.allValues.addElement(row);
    }

    public final Vector getRow(int row) {
        return (Vector)this.allValues.elementAt(row);
    }

    public final void delRow(int row) {
        this.allValues.removeElementAt(row);
    }

    public int getRowCount() {
        return this.allValues.size();
    }

    @Override
    public BaseType getVariable(String name) throws NoSuchVariableException {
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            String aggregate = name.substring(0, dotIndex);
            String field = name.substring(dotIndex + 1);
            BaseType aggRef = this.getVariable(aggregate);
            if (aggRef instanceof DConstructor) {
                return ((DConstructor)aggRef).getVariable(field);
            }
        } else {
            Enumeration e = this.varTemplate.elements();
            while (e.hasMoreElements()) {
                BaseType v = (BaseType)e.nextElement();
                if (!v.getEncodedName().equals(name)) continue;
                return v;
            }
        }
        throw new NoSuchVariableException("DSequence: getVariable()");
    }

    @Override
    public BaseType getVar(int index) throws NoSuchVariableException {
        if (index < this.varTemplate.size()) {
            return (BaseType)this.varTemplate.elementAt(index);
        }
        throw new NoSuchVariableException("DSequence.getVariable(" + index + " - 1)");
    }

    @Override
    public int getVarCount() {
        return this.varTemplate.size();
    }

    public BaseType getVariable(int row, String name) throws NoSuchVariableException {
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            String aggregate = name.substring(0, dotIndex);
            String field = name.substring(dotIndex + 1);
            BaseType aggRef = this.getVariable(aggregate);
            if (aggRef instanceof DConstructor) {
                return ((DConstructor)aggRef).getVariable(field);
            }
        } else {
            Vector selectedRow = (Vector)this.allValues.elementAt(row);
            Enumeration e = selectedRow.elements();
            while (e.hasMoreElements()) {
                BaseType v = (BaseType)e.nextElement();
                if (!v.getEncodedName().equals(name)) continue;
                return v;
            }
        }
        throw new NoSuchVariableException("DSequence: getVariable()");
    }

    @Override
    public Enumeration getVariables() {
        return this.varTemplate.elements();
    }

    @Override
    public void checkSemantics(boolean all) throws BadSemanticsException {
        super.checkSemantics(all);
        Util.uniqueNames(this.varTemplate, this.getEncodedName(), this.getTypeName());
        if (all) {
            Enumeration e = this.varTemplate.elements();
            while (e.hasMoreElements()) {
                BaseType bt = (BaseType)e.nextElement();
                bt.checkSemantics(true);
            }
        }
    }

    @Override
    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.println(space + this.getTypeName() + " {");
        Enumeration e = this.varTemplate.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            bt.printDecl(os, space + "    ", true, constrained);
        }
        os.print(space + "} " + this.getEncodedName());
        if (print_semi) {
            os.println(";");
        }
    }

    @Override
    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.print(" = ");
        }
        os.print("{ ");
        Enumeration e1 = this.allValues.elements();
        while (e1.hasMoreElements()) {
            os.print("{ ");
            Vector v = (Vector)e1.nextElement();
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                BaseType bt = (BaseType)e2.nextElement();
                bt.printVal(os, "", false);
                if (!e2.hasMoreElements()) continue;
                os.print(", ");
            }
            os.print(" }");
            if (!e1.hasMoreElements()) continue;
            os.print(", ");
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    @Override
    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, DataReadException {
        if (sv != null && (sv.getMajor() < 2 || sv.getMajor() == 2 && sv.getMinor() < 15)) {
            this.oldDeserialize(source, sv, statusUI);
        } else {
            byte marker;
            while (true) {
                marker = this.readMarker(source);
                if (statusUI != null) {
                    statusUI.incrementByteCount(4);
                }
                if (marker != START_OF_INSTANCE) break;
                this.deserializeSingle(source, sv, statusUI);
            }
            if (marker != END_OF_SEQUENCE) {
                throw new DataReadException("Sequence start marker not found");
            }
        }
    }

    private void oldDeserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws DataReadException {
        try {
            while (true) {
                this.deserializeSingle(source, sv, statusUI);
            }
        }
        catch (IOException ioe) {
            return;
        }
    }

    private void deserializeSingle(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        Object bt;
        Vector<Object> newInstance = new Vector<Object>();
        for (int i = 0; i < this.varTemplate.size(); ++i) {
            bt = (BaseType)this.varTemplate.elementAt(i);
            newInstance.addElement(((DAPNode)bt).clone());
        }
        Enumeration e = newInstance.elements();
        while (e.hasMoreElements()) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("User cancelled");
            }
            bt = (ClientIO)e.nextElement();
            bt.deserialize(source, sv, statusUI);
        }
        this.allValues.addElement(newInstance);
    }

    private byte readMarker(DataInputStream source) throws IOException {
        byte marker = source.readByte();
        for (int i = 0; i < 3; ++i) {
            byte unused = source.readByte();
        }
        return marker;
    }

    protected void writeMarker(DataOutputStream sink, byte marker) throws IOException {
        sink.writeByte(marker);
        sink.writeByte(0);
        sink.writeByte(0);
        sink.writeByte(0);
    }

    @Override
    public void externalize(DataOutputStream sink) throws IOException {
        for (int i = 0; i < this.allValues.size(); ++i) {
            this.writeMarker(sink, START_OF_INSTANCE);
            Vector rowVec = (Vector)this.allValues.elementAt(i);
            for (int j = 0; j < rowVec.size(); ++j) {
                ClientIO bt = (ClientIO)rowVec.elementAt(j);
                bt.externalize(sink);
            }
        }
        this.writeMarker(sink, END_OF_SEQUENCE);
    }

    @Override
    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        int i;
        DSequence s = (DSequence)super.cloneDAG(map);
        s.varTemplate = new Vector();
        for (i = 0; i < this.varTemplate.size(); ++i) {
            BaseType bt = (BaseType)this.varTemplate.elementAt(i);
            BaseType btclone = (BaseType)DSequence.cloneDAG(map, bt);
            s.varTemplate.addElement(btclone);
        }
        s.allValues = new Vector();
        for (i = 0; i < this.allValues.size(); ++i) {
            Vector rowVec = (Vector)this.allValues.elementAt(i);
            Vector<BaseType> newVec = new Vector<BaseType>();
            for (int j = 0; j < rowVec.size(); ++j) {
                BaseType bt = (BaseType)rowVec.elementAt(j);
                newVec.addElement((BaseType)DSequence.cloneDAG(map, bt));
            }
            s.allValues.addElement(newVec);
        }
        return s;
    }
}

