/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import opendap.dap.Alias;
import opendap.dap.Attribute;
import opendap.dap.AttributeExistsException;
import opendap.dap.DAPNode;
import opendap.dap.DASException;
import opendap.dap.parsers.DDSXMLParser;

public class AttributeTable
extends DAPNode
implements Iterable<String> {
    private LinkedHashMap<String, Attribute> attributes = new LinkedHashMap();

    public AttributeTable(String clearname) {
        super(clearname);
    }

    public int size() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    @Nullable
    public final Attribute getAttribute(String clearname) {
        return this.attributes.get(clearname);
    }

    public final void appendAttribute(String clearname, int type, String value, boolean check) throws DASException {
        Attribute a = this.attributes.get(clearname);
        if (a != null && type != a.getType()) {
            throw new AttributeExistsException("The Attribute `" + clearname + "' was previously defined with a different type.");
        }
        if (a != null) {
            a.appendValue(value, check);
        } else {
            a = new Attribute(type, clearname, value, check);
            this.attributes.put(clearname, a);
        }
    }

    public final void appendAttribute(String clearname, int type, String value) throws DASException {
        this.appendAttribute(clearname, type, value, true);
    }

    @Nullable
    public final AttributeTable appendContainer(String clearname) {
        if (this.attributes.get(clearname) != null) {
            return null;
        }
        AttributeTable at = new AttributeTable(clearname);
        Attribute a = new Attribute(clearname, at);
        this.attributes.put(clearname, a);
        return at;
    }

    public final void addContainer(String clearname, AttributeTable at) throws AttributeExistsException {
        if (this.attributes.get(clearname) != null) {
            throw new AttributeExistsException("The Attribute '" + clearname + "' already exists in the container '" + this.getEncodedName() + "'");
        }
        Attribute a = new Attribute(clearname, at);
        this.attributes.put(clearname, a);
    }

    public final void addAlias(String alias, String attributeName) throws AttributeExistsException {
        if (this.attributes.get(alias) != null) {
            throw new AttributeExistsException("Could not alias `" + alias + "' to `" + attributeName + "'. It is a duplicat name in this AttributeTable");
        }
        Alias newAlias = new Alias(alias, attributeName);
        this.attributes.put(alias, newAlias);
    }

    public final void delAttribute(String clearname) {
        this.attributes.remove(clearname);
    }

    public final void delAttribute(String clearname, int i) throws DASException {
        if (i == -1) {
            this.attributes.remove(clearname);
        } else {
            Attribute a = this.attributes.get(clearname);
            if (a != null) {
                if (a.isContainer()) {
                    this.attributes.remove(clearname);
                } else {
                    a.deleteValueAt(i);
                }
            }
        }
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8)));
        this.print(pw);
        pw.flush();
        try {
            return bos.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void print(PrintWriter os, String pad) {
        os.println(pad + this.getEncodedName() + " {");
        for (String name : this.attributes.keySet()) {
            Attribute a = this.getAttribute(name);
            if (a == null) continue;
            a.print(os, pad + "    ");
        }
        os.println(pad + "}");
        os.flush();
    }

    public final void print(OutputStream os, String pad) {
        this.print(new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8))), pad);
    }

    public final void print(PrintStream os) {
        this.print(os, "");
    }

    public final void print(PrintWriter os) {
        this.print(os, "");
    }

    public final void print(OutputStream os) {
        this.print(os, "");
    }

    public void printXML(OutputStream os, String pad) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
        this.printXML(pw, pad);
        pw.flush();
    }

    public void printXML(PrintWriter pw) {
        this.printXML(pw, "");
    }

    public void printXML(PrintWriter pw, String pad) {
        this.printXML(pw, pad, false);
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        pw.println(pad + "<Attribute name=\"" + DDSXMLParser.normalizeToXML(this.getEncodedName()) + "\" type=\"Container\">");
        for (String name : this.attributes.keySet()) {
            Attribute a = this.getAttribute(name);
            if (a == null) continue;
            a.printXML(pw, pad + "\t", constrained);
        }
        pw.println(pad + "</Attribute>");
        pw.flush();
    }

    @Override
    public AttributeTable cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        AttributeTable at = (AttributeTable)super.cloneDAG(map);
        at.attributes = new LinkedHashMap<String, Attribute>(this.attributes);
        return at;
    }

    @Override
    public Iterator<String> iterator() {
        return this.attributes.keySet().iterator();
    }
}

