/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import opendap.dap.Attribute;
import opendap.dap.AttributeExistsException;
import opendap.dap.AttributeTable;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DAPNode;
import opendap.dap.DASException;
import opendap.dap.DArray;
import opendap.dap.DDS;
import opendap.dap.PrimitiveVector;
import opendap.dap.parsers.DDSXMLParser;

public abstract class BaseType
extends DAPNode {
    private Attribute attribute;
    private AttributeTable attTable = new AttributeTable(this.getClearName());

    public BaseType() {
        this(null);
    }

    public BaseType(String clearname) {
        this.attribute = new Attribute(this.getClearName(), this.attTable);
        this.setClearName(clearname);
    }

    @Override
    public void setClearName(String clearname) {
        super.setClearName(clearname);
        if (this.attribute != null) {
            this.attribute.setClearName(clearname);
        }
        if (this.attTable != null) {
            this.attTable.setClearName(clearname);
        }
    }

    public abstract String getTypeName();

    public int elementCount(boolean leaves) {
        return 1;
    }

    public final int elementCount() {
        return this.elementCount(false);
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.print(space + this.getTypeName() + " " + this.getEncodedName());
        if (print_semi) {
            os.println(";");
        }
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi) {
        this.printDecl(os, space, print_semi, false);
    }

    public final void printDecl(PrintWriter os, String space) {
        this.printDecl(os, space, true, false);
    }

    public final void printDecl(PrintWriter os) {
        this.printDecl(os, "    ", true, false);
    }

    public final void printDecl(OutputStream os, String space, boolean print_semi, boolean constrained) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
        this.printDecl(pw, space, print_semi, constrained);
        pw.flush();
    }

    public final void printDecl(OutputStream os, String space, boolean print_semi) {
        this.printDecl(os, space, print_semi, false);
    }

    public final void printDecl(OutputStream os, String space) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
        this.printDecl(pw, space);
        pw.flush();
    }

    public void printDecl(OutputStream os) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
        this.printDecl(pw);
        pw.flush();
    }

    public abstract void printVal(PrintWriter var1, String var2, boolean var3);

    public void printVal(PrintWriter os, String space) {
        this.printVal(os, space, true);
    }

    public void printVal(OutputStream os, String space, boolean print_decl_p) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
        this.printVal(pw, space, print_decl_p);
        pw.flush();
    }

    public void printVal(OutputStream os, String space) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
        this.printVal(pw, space);
        pw.flush();
    }

    public void checkSemantics(boolean all) throws BadSemanticsException {
        if (this._nameClear == null) {
            throw new BadSemanticsException("BaseType.checkSemantics(): Every variable must have a name");
        }
    }

    public final void checkSemantics() throws BadSemanticsException {
        this.checkSemantics(false);
    }

    public PrimitiveVector newPrimitiveVector() {
        return new BaseTypePrimitiveVector(this);
    }

    public String getLongName() {
        boolean done = false;
        Object longName = this._nameEncoded;
        for (BaseType parent = (BaseType)this.getParent(); parent != null && !(parent instanceof DDS); parent = (BaseType)parent.getParent()) {
            longName = parent.getEncodedName() + "." + (String)longName;
        }
        return longName;
    }

    public boolean hasAttributes() {
        return this.attTable.size() > 0;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public AttributeTable getAttributeTable() {
        return this.attTable;
    }

    public void addAttributeAlias(String alias, String attributeName) throws DASException {
        this.attTable.addAlias(alias, attributeName);
    }

    public void appendAttribute(String clearname, int type, String value, boolean check) throws DASException {
        this.attTable.appendAttribute(clearname, type, value, check);
    }

    public void appendAttribute(String clearname, int type, String value) throws DASException {
        this.attTable.appendAttribute(clearname, type, value);
    }

    public void addAttributeContainer(AttributeTable at) throws AttributeExistsException {
        this.attTable.addContainer(at.getClearName(), at);
    }

    public AttributeTable appendAttributeContainer(String clearname) {
        return this.attTable.appendContainer(clearname);
    }

    public void delAttribute(String clearname) {
        this.attTable.delAttribute(clearname);
    }

    public void delAttribute(String clearname, int i) throws DASException {
        this.attTable.delAttribute(clearname, i);
    }

    public Attribute getAttribute(String clearname) {
        return this.attTable.getAttribute(clearname);
    }

    public Iterable<String> getAttributeNames() {
        return this.attTable;
    }

    public void printAttributes(OutputStream os) {
        this.attTable.print(os);
    }

    public void printAttributes(OutputStream os, String pad) {
        this.attTable.print(os, pad);
    }

    public void printAttributes(PrintWriter pw) {
        this.attTable.print(pw);
    }

    public void printAttributes(PrintWriter pw, String pad) {
        this.attTable.print(pw, pad);
    }

    public void printXML(OutputStream os) {
        this.printXML(os, "");
    }

    public void printXML(OutputStream os, String pad) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
        this.printXML(pw, pad, false);
        pw.flush();
    }

    public void printXML(PrintWriter pw) {
        this.printXML(pw, "");
    }

    public void printXML(PrintWriter pw, String pad) {
        this.printXML(pw, pad, false);
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        pw.print(pad + "<" + this.getTypeName());
        if (this._nameClear != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this._nameClear) + "\"");
        }
        if (this.attTable.size() > 0) {
            pw.println(">");
            for (String aName : this.attTable) {
                Attribute a = this.getAttribute(aName);
                if (a == null) continue;
                a.printXML(pw, pad + "\t", constrained);
            }
            pw.println(pad + "</" + this.getTypeName() + ">");
        } else {
            pw.println("/>");
        }
    }

    public void printConstraint(PrintWriter os) {
        BaseType parent = (BaseType)this.getParent();
        BaseType array = null;
        if (parent != null && parent instanceof DArray) {
            array = parent;
            parent = (BaseType)parent.getParent();
        }
        if (array != null) {
            array.printConstraint(os);
        } else {
            if (parent != null && !(parent instanceof DDS)) {
                parent.printConstraint(os);
                os.print(".");
            }
            os.print(this.getEncodedName());
        }
    }

    @Override
    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        BaseType bt = (BaseType)super.cloneDAG(map);
        if (this.attTable != null) {
            bt.attTable = (AttributeTable)BaseType.cloneDAG(map, this.attTable);
        }
        if (this.attribute != null) {
            bt.attribute = new Attribute(this.getClearName(), bt.attTable);
        }
        return bt;
    }
}

