/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import opendap.dap.Attribute;
import opendap.dap.BaseType;
import opendap.dap.NoSuchVariableException;
import opendap.dap.parsers.DDSXMLParser;

public abstract class DConstructor
extends BaseType {
    public DConstructor() {
    }

    public DConstructor(String n) {
        super(n);
    }

    public abstract void addVariable(BaseType var1, int var2);

    public final void addVariable(BaseType v) {
        this.addVariable(v, 0);
    }

    public abstract BaseType getVariable(String var1) throws NoSuchVariableException;

    public abstract BaseType getVar(int var1) throws NoSuchVariableException;

    public abstract int getVarCount();

    public abstract ImmutableList<BaseType> getVariables();

    protected boolean someChildHasAttributes(BaseType bt) {
        boolean foundit = false;
        if (bt.hasAttributes()) {
            return true;
        }
        if (bt instanceof DConstructor) {
            for (BaseType member : ((DConstructor)bt).getVariables()) {
                foundit = foundit || this.someChildHasAttributes(member);
            }
        }
        return foundit;
    }

    @Override
    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        boolean hasAttributes = this.hasAttributes();
        boolean hasVariables = !this.getVariables().isEmpty();
        pw.print(pad + "<" + this.getTypeName());
        if (this.getEncodedName() != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this.getClearName()) + "\"");
        }
        if (hasAttributes || hasVariables) {
            pw.println(">");
            for (String attName : this.getAttributeNames()) {
                Attribute a = this.getAttribute(attName);
                if (a == null) continue;
                a.printXML(pw, pad + "\t", constrained);
            }
            for (BaseType bt : this.getVariables()) {
                bt.printXML(pw, pad + "\t", constrained);
            }
            pw.println(pad + "</" + this.getTypeName() + ">");
        } else {
            pw.println("/>");
        }
    }
}

