/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import com.google.common.collect.ImmutableList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.ClientIO;
import opendap.dap.DAPNode;
import opendap.dap.DConstructor;
import opendap.dap.DataReadException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.Util;

public class DSequence
extends DConstructor
implements ClientIO {
    protected static byte START_OF_INSTANCE = (byte)90;
    protected static byte END_OF_SEQUENCE = (byte)-91;
    protected ArrayList<BaseType> varTemplate = new ArrayList();
    protected ArrayList<List<BaseType>> allValues = new ArrayList();
    private int level = 0;

    public DSequence() {
        this(null);
    }

    public DSequence(String n) {
        super(n);
    }

    @Override
    public String getTypeName() {
        return "Sequence";
    }

    protected final void setLevel(int level) {
        this.level = level;
    }

    protected final int getLevel() {
        return this.level;
    }

    @Override
    public int elementCount(boolean leaves) {
        if (!leaves) {
            return this.varTemplate.size();
        }
        int count = 0;
        for (BaseType bt : this.varTemplate) {
            count += bt.elementCount(leaves);
        }
        return count;
    }

    @Override
    public void addVariable(BaseType v, int part) {
        v.setParent(this);
        this.varTemplate.add(v);
        if (v instanceof DSequence) {
            ((DSequence)v).setLevel(this.getLevel() + 1);
        }
    }

    public final void addRow(List<BaseType> row) {
        this.allValues.add(row);
    }

    public final List<BaseType> getRow(int row) {
        return this.allValues.get(row);
    }

    public int getRowCount() {
        return this.allValues.size();
    }

    @Override
    public BaseType getVariable(String name) throws NoSuchVariableException {
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            String aggregate = name.substring(0, dotIndex);
            String field = name.substring(dotIndex + 1);
            BaseType aggRef = this.getVariable(aggregate);
            if (aggRef instanceof DConstructor) {
                return ((DConstructor)aggRef).getVariable(field);
            }
        } else {
            for (BaseType v : this.varTemplate) {
                if (!v.getEncodedName().equals(name)) continue;
                return v;
            }
        }
        throw new NoSuchVariableException("DSequence: getVariable()");
    }

    @Override
    public BaseType getVar(int index) throws NoSuchVariableException {
        if (index < this.varTemplate.size()) {
            return this.varTemplate.get(index);
        }
        throw new NoSuchVariableException("DSequence.getVariable(" + index + " - 1)");
    }

    @Override
    public int getVarCount() {
        return this.varTemplate.size();
    }

    public BaseType getVariable(int row, String name) throws NoSuchVariableException {
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            String aggregate = name.substring(0, dotIndex);
            String field = name.substring(dotIndex + 1);
            BaseType aggRef = this.getVariable(aggregate);
            if (aggRef instanceof DConstructor) {
                return ((DConstructor)aggRef).getVariable(field);
            }
        } else {
            List<BaseType> selectedRow = this.allValues.get(row);
            for (BaseType v : selectedRow) {
                if (!v.getEncodedName().equals(name)) continue;
                return v;
            }
        }
        throw new NoSuchVariableException("DSequence: getVariable()");
    }

    @Override
    public ImmutableList<BaseType> getVariables() {
        return ImmutableList.copyOf(this.varTemplate);
    }

    @Override
    public void checkSemantics(boolean all) throws BadSemanticsException {
        super.checkSemantics(all);
        Util.uniqueNames(this.varTemplate, this.getEncodedName(), this.getTypeName());
        if (all) {
            for (BaseType bt : this.varTemplate) {
                bt.checkSemantics(true);
            }
        }
    }

    @Override
    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.println(space + this.getTypeName() + " {");
        for (BaseType bt : this.varTemplate) {
            bt.printDecl(os, space + "    ", true, constrained);
        }
        os.print(space + "} " + this.getEncodedName());
        if (print_semi) {
            os.println(";");
        }
    }

    @Override
    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.print(" = ");
        }
        os.print("{ ");
        int countRow = 0;
        for (List<BaseType> row : this.allValues) {
            os.print("{ ");
            if (countRow > 0) {
                os.print(", ");
            }
            int count = 0;
            for (BaseType bt : row) {
                if (count > 0) {
                    os.print(", ");
                }
                bt.printVal(os, "", false);
                ++count;
            }
            os.print(" }");
            ++countRow;
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    @Override
    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, DataReadException {
        if (sv != null && (sv.getMajor() < 2 || sv.getMajor() == 2 && sv.getMinor() < 15)) {
            this.oldDeserialize(source, sv, statusUI);
        } else {
            byte marker;
            while (true) {
                marker = this.readMarker(source);
                if (statusUI != null) {
                    statusUI.incrementByteCount(4);
                }
                if (marker != START_OF_INSTANCE) break;
                this.deserializeSingle(source, sv, statusUI);
            }
            if (marker != END_OF_SEQUENCE) {
                throw new DataReadException("Sequence start marker not found");
            }
        }
    }

    private void oldDeserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws DataReadException {
        try {
            while (true) {
                this.deserializeSingle(source, sv, statusUI);
            }
        }
        catch (IOException ioe) {
            return;
        }
    }

    private void deserializeSingle(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        ArrayList<BaseType> newInstance = new ArrayList<BaseType>();
        for (BaseType bt : this.varTemplate) {
            newInstance.add((BaseType)bt.clone());
        }
        for (BaseType bt : newInstance) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("User cancelled");
            }
            ClientIO client = (ClientIO)((Object)bt);
            client.deserialize(source, sv, statusUI);
        }
        this.allValues.add(newInstance);
    }

    private byte readMarker(DataInputStream source) throws IOException {
        byte marker = source.readByte();
        for (int i = 0; i < 3; ++i) {
            byte unused = source.readByte();
        }
        return marker;
    }

    protected void writeMarker(DataOutputStream sink, byte marker) throws IOException {
        sink.writeByte(marker);
        sink.writeByte(0);
        sink.writeByte(0);
        sink.writeByte(0);
    }

    @Override
    public void externalize(DataOutputStream sink) throws IOException {
        for (int i = 0; i < this.allValues.size(); ++i) {
            this.writeMarker(sink, START_OF_INSTANCE);
            List<BaseType> rowVec = this.allValues.get(i);
            for (BaseType bt : rowVec) {
                ClientIO client = (ClientIO)((Object)bt);
                client.externalize(sink);
            }
        }
        this.writeMarker(sink, END_OF_SEQUENCE);
    }

    @Override
    public DSequence cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        DSequence s = (DSequence)super.cloneDAG(map);
        s.varTemplate = new ArrayList();
        for (BaseType baseType : this.varTemplate) {
            BaseType btclone = (BaseType)DSequence.cloneDAG(map, baseType);
            s.varTemplate.add(btclone);
        }
        s.allValues = new ArrayList();
        for (List list : this.allValues) {
            ArrayList<BaseType> newRow = new ArrayList<BaseType>();
            for (BaseType bt : list) {
                BaseType btclone = (BaseType)DSequence.cloneDAG(map, bt);
                newRow.add(btclone);
            }
            s.allValues.add(newRow);
        }
        return s;
    }
}

