/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import opendap.dap.ClientIO;
import opendap.dap.DPrimitive;
import opendap.dap.DataReadException;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.Util;

public class DString
extends DPrimitive
implements ClientIO {
    private boolean hasValue = false;
    private String val;

    public DString() {
    }

    public DString(String n) {
        super(n);
    }

    public final String getValue() {
        return this.hasValue ? this.val : null;
    }

    public final void setValue(String newVal) {
        this.val = newVal;
        this.hasValue = true;
    }

    @Override
    public String getTypeName() {
        return "String";
    }

    @Override
    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.println(" = \"" + Util.escattr(this.val) + "\";");
        } else {
            os.print("\"" + Util.escattr(this.val) + "\"");
        }
    }

    @Override
    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int dap_len = source.readInt();
        if (dap_len < 0) {
            throw new DataReadException("Negative string length (dap_length: " + dap_len + ") read.");
        }
        if (dap_len > Short.MAX_VALUE) {
            throw new DataReadException("DString deserialize string length (dap_length: " + dap_len + ") too large.");
        }
        int modFour = dap_len % 4;
        int pad = modFour != 0 ? 4 - modFour : 0;
        byte[] byteArray = new byte[dap_len];
        source.readFully(byteArray, 0, dap_len);
        for (int i = 0; i < pad; ++i) {
            byte unused = source.readByte();
        }
        if (statusUI != null) {
            statusUI.incrementByteCount(4 + dap_len + pad);
        }
        try {
            this.val = new String(byteArray, 0, dap_len, "ISO8859_1");
            this.hasValue = true;
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingException("ISO8859_1 encoding not supported by this VM!");
        }
    }

    @Override
    public void externalize(DataOutputStream sink) throws IOException {
        try {
            byte[] byteArray = this.val.getBytes("ISO8859_1");
            sink.writeInt(byteArray.length);
            int modFour = byteArray.length % 4;
            int pad = modFour != 0 ? 4 - modFour : 0;
            sink.write(byteArray, 0, byteArray.length);
            for (int i = 0; i < pad; ++i) {
                sink.writeByte(0);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingException("ISO8859_1 encoding not supported by this VM!");
        }
    }

    @Override
    public void printConstraint(PrintWriter os) {
        if (this.hasValue) {
            Object s = String.format("%s", this.val);
            s = "\"" + Util.escattr((String)s) + "\"";
            os.print((String)s);
        } else {
            super.printConstraint(os);
        }
    }
}

