/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import opendap.dap.Attribute;
import opendap.dap.AttributeBadValueException;
import opendap.dap.AttributeTable;
import opendap.dap.BadSemanticsException;
import opendap.dap.BaseType;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dap.DASException;
import opendap.dap.DArray;
import opendap.dap.DConstructor;
import opendap.dap.DDS;
import opendap.dap.DGrid;
import opendap.dap.NoSuchTypeException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

public class DDSXMLParser {
    private boolean _Debug = false;
    private int parseLevel;
    private DDS dds = null;
    private BaseTypeFactory factory = null;
    private Namespace opendapNameSpace;
    private DConstructor parentDC;
    private BaseType currentBT = null;
    private AttributeTable currentAT = null;
    private Document lastDoc;

    public DDSXMLParser(String nameSpace) {
        this.opendapNameSpace = Namespace.getNamespace((String)nameSpace);
        this.lastDoc = null;
    }

    public Document getLastDomDoc() {
        return this.lastDoc;
    }

    public void parse(Document ddx, DDS targetDDS, BaseTypeFactory fac, boolean validation) throws DAP2Exception {
        this.dds = targetDDS;
        this.factory = fac;
        Element root = ddx.getRootElement();
        this.lastDoc = ddx;
        this.parseLevel = 0;
        String type = root.getName();
        if (!type.equals("Dataset")) {
            throw new NoSuchTypeException("Root Element MUST be <Dataset>. Found: " + type);
        }
        String name = root.getAttribute("name").getValue();
        this.dds.setClearName(name);
        this.parentDC = this.dds;
        this.currentBT = this.dds;
        this.parseAttributes(root, "-- ");
        this.parseAliases(root, "++ ");
        for (Element child : root.getChildren()) {
            this.parseBase(child, "    ");
        }
    }

    public void parse(InputStream is, DDS targetDDS, BaseTypeFactory fac, boolean validation) throws DAP2Exception {
        try {
            SAXBuilder parser = new SAXBuilder();
            parser.setExpandEntities(false);
            parser.setFeature("http://apache.org/xml/features/validation/schema", validation);
            Document doc = parser.build(is);
            if (this._Debug) {
                System.out.println("Document is " + (validation ? "valid and " : "") + "well-formed.\nContent: " + doc);
            }
            this.parse(doc, targetDDS, fac, validation);
        }
        catch (JDOMException jde) {
            throw new DAP2Exception((Exception)((Object)jde));
        }
        catch (IOException ioe) {
            throw new DAP2Exception(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBase(Element e, String indent) throws DASException, NoSuchTypeException, BadSemanticsException {
        ++this.parseLevel;
        String type = e.getName();
        if (!type.equals("Attribute") && !type.equals("Alias")) {
            if (type.equals("dataBLOB")) {
                org.jdom2.Attribute hrefAttr = e.getAttribute("href");
                String contentID = hrefAttr.getValue();
                if (this._Debug) {
                    System.out.println("Found dataBLOB element. contentID=\"" + contentID + "\"");
                }
                this.dds.setBlobContentID(contentID);
            } else {
                if (this._Debug) {
                    System.out.println("Parsing new BaseType element. Parse level: " + this.parseLevel);
                }
                if (this._Debug) {
                    this.showXMLElement(e, indent);
                }
                BaseType bt = this.newBaseType(e);
                this.parentDC.addVariable(bt);
                if (bt instanceof DConstructor) {
                    DConstructor myParentDC = this.parentDC;
                    this.parentDC = (DConstructor)bt;
                    try {
                        if (bt instanceof DGrid) {
                            this.parseGrid(e, indent);
                        }
                        for (Element child : e.getChildren()) {
                            this.parseBase(child, indent + "    ");
                        }
                    }
                    finally {
                        this.parentDC = myParentDC;
                    }
                } else if (bt instanceof DArray) {
                    if (this._Debug) {
                        System.out.println("Parsing Array instance.  Array name: '" + bt.getClearName() + "'");
                    }
                    this.parseArray(e, (DArray)bt, indent);
                }
            }
        }
        --this.parseLevel;
    }

    private void parseArray(Element ArrayElement, DArray da, String indent) throws DASException, NoSuchTypeException, BadSemanticsException {
        int countTemplateVars = 0;
        int numDims = 0;
        for (Element e : ArrayElement.getChildren()) {
            if (this._Debug) {
                System.out.println(indent + "Working on Array element: " + e.getName());
            }
            if (e.getName().equals("Attribute") || e.getName().equals("Alias")) continue;
            if (e.getName().equals("dimension")) {
                ++numDims;
                String name = null;
                org.jdom2.Attribute nameAttr = e.getAttribute("name");
                if (nameAttr != null) {
                    name = nameAttr.getValue();
                }
                int size = Integer.parseInt(e.getAttribute("size").getValue());
                da.appendDim(size, name);
                continue;
            }
            ++countTemplateVars;
            BaseType template = this.buildArrayTemplate(e, indent);
            template.setClearName(da.getClearName());
            da.addVariable(template);
        }
        if (this._Debug) {
            System.out.println(indent + "Built Array: ");
            da.printDecl(System.out, indent);
            System.out.println(indent + "dimensions: " + numDims + "  templates: " + countTemplateVars);
        }
        if (countTemplateVars != 1) {
            throw new NoSuchTypeException("ONLY ONE (1) TEMPLATE VARIABLE ALLOWED PER ARRAY!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseType buildArrayTemplate(Element template, String indent) throws DASException, NoSuchTypeException, BadSemanticsException {
        Iterator attrElements;
        BaseType bt = null;
        if (this._Debug) {
            this.showXMLElement(template, indent + "...:");
        }
        if ((attrElements = template.getChildren("Attribute", this.opendapNameSpace).iterator()).hasNext()) {
            throw new BadSemanticsException("Array Template Variables MAY NOT have Attributes");
        }
        bt = this.newBaseType(template);
        if (this._Debug) {
            System.out.println("Got template: " + bt.getTypeName() + "   " + bt.getClearName());
        }
        if (bt instanceof DConstructor) {
            DConstructor myParentDC = this.parentDC;
            this.parentDC = (DConstructor)bt;
            try {
                if (bt instanceof DGrid) {
                    this.parseGrid(template, indent);
                } else {
                    for (Element child : template.getChildren()) {
                        this.parseBase(child, indent + "    ");
                    }
                }
            }
            finally {
                this.parentDC = myParentDC;
            }
        }
        return bt;
    }

    private void parseGrid(Element gridElement, String indent) throws DASException, NoSuchTypeException, BadSemanticsException {
        List mapElements;
        ++this.parseLevel;
        DGrid myGrid = (DGrid)this.parentDC;
        if (this._Debug) {
            System.out.println("Parsing Grid Element: " + gridElement);
            System.out.println("Grid Elements: ");
            for (Element element : gridElement.getChildren()) {
                System.out.println(element);
            }
        }
        String eName = "Array";
        if (this._Debug) {
            System.out.println("Parsing Array element.");
            System.out.println("Asking for element: '" + eName + "' in namespace: '" + this.opendapNameSpace + "'");
        }
        Element arrayElement = gridElement.getChild(eName, this.opendapNameSpace);
        if (this._Debug) {
            System.out.println("Got Array element: " + arrayElement);
        }
        DArray gridArray = (DArray)this.newBaseType(arrayElement);
        this.parseArray(arrayElement, gridArray, indent + "    ");
        myGrid.addVariable(gridArray, 1);
        eName = "Map";
        if (this._Debug) {
            System.out.println("Parsing Map elements.");
            System.out.println("Asking for element: '" + eName + "' in namespace: '" + this.opendapNameSpace + "'");
        }
        if ((mapElements = gridElement.getChildren("Map", this.opendapNameSpace)).size() != gridArray.numDimensions()) {
            throw new BadSemanticsException("Error in Grid syntax: The number of Map arrays must equal the number of dimensions of the data array.");
        }
        for (Element mapElement : mapElements) {
            DArray thisMap = (DArray)this.newBaseType(mapElement);
            this.parseArray(mapElement, thisMap, indent + "    ");
            if (thisMap.numDimensions() != 1) {
                throw new BadSemanticsException("Error in Grid syntax: Maps may have only one dimension.");
            }
            myGrid.addVariable(thisMap, 2);
        }
        --this.parseLevel;
    }

    private void showXMLElement(Element e, String indent) {
        System.out.print(this.parseLevel + indent + "Element: " + e.getName() + "  ");
        String text = e.getTextNormalize();
        if (!text.equals("")) {
            System.out.print(" = " + text + "   ");
        }
        for (org.jdom2.Attribute att : e.getAttributes()) {
            System.out.print(att.getName() + ": " + att.getValue() + "  ");
        }
        System.out.println("");
        for (Element kid : e.getChildren()) {
            this.showXMLElement(kid, indent + "    ");
        }
    }

    private BaseType newBaseType(Element e) throws DASException, NoSuchTypeException {
        if (this._Debug) {
            System.out.println("Getting new BaseType() from: " + e);
        }
        String type = e.getName();
        String name = null;
        org.jdom2.Attribute nameAttr = e.getAttribute("name");
        if (nameAttr != null) {
            name = nameAttr.getValue();
        }
        if (this._Debug) {
            System.out.println("    type: " + type + "   name: '" + name + "'");
        }
        this.currentBT = this.newBaseTypeFactory(type, name);
        this.parseAttributes(e, "--- ");
        this.parseAliases(e, "+++ ");
        return this.currentBT;
    }

    private BaseType newBaseTypeFactory(String typeString, String name) throws NoSuchTypeException {
        BaseType bt;
        if (typeString.equals("Array") || typeString.equals("Map")) {
            bt = this.factory.newDArray();
            bt.setClearName(name);
        } else if (typeString.equals("Grid")) {
            bt = this.factory.newDGrid();
            bt.setClearName(name);
        } else if (typeString.equals("Structure")) {
            bt = this.factory.newDStructure();
            bt.setClearName(name);
        } else if (typeString.equals("Sequence")) {
            bt = this.factory.newDSequence();
            bt.setClearName(name);
        } else if (typeString.equals("Int16")) {
            bt = this.factory.newDInt16();
            bt.setClearName(name);
        } else if (typeString.equals("UInt16")) {
            bt = this.factory.newDUInt16();
            bt.setClearName(name);
        } else if (typeString.equals("Int32")) {
            bt = this.factory.newDInt32();
            bt.setClearName(name);
        } else if (typeString.equals("UInt32")) {
            bt = this.factory.newDUInt32();
            bt.setClearName(name);
        } else if (typeString.equals("Float32")) {
            bt = this.factory.newDFloat32();
            bt.setClearName(name);
        } else if (typeString.equals("Float64")) {
            bt = this.factory.newDFloat64();
            bt.setClearName(name);
        } else if (typeString.equals("Byte")) {
            bt = this.factory.newDByte();
            bt.setClearName(name);
        } else if (typeString.equals("String")) {
            bt = this.factory.newDString();
            bt.setClearName(name);
        } else if (typeString.equals("Url")) {
            bt = this.factory.newDURL();
            bt.setClearName(name);
        } else {
            throw new NoSuchTypeException("Unknown Type: " + typeString);
        }
        return bt;
    }

    private void parseAttributes(Element e, String indent) throws DASException, NoSuchTypeException {
        ++this.parseLevel;
        String subIndent = indent + "    ";
        if (this._Debug) {
            System.out.println(indent + "Parsing Attributes: ");
        }
        if (this._Debug) {
            System.out.println(subIndent + "currentBT: " + this.currentBT.getTypeName() + " " + this.currentBT.getClearName());
        }
        for (Element attrElement : e.getChildren("Attribute", this.opendapNameSpace)) {
            String name = null;
            org.jdom2.Attribute nameAttr = attrElement.getAttribute("name");
            name = nameAttr.getValue();
            String typeName = null;
            org.jdom2.Attribute typeAttr = attrElement.getAttribute("type");
            typeName = typeAttr.getValue();
            if (typeName.equals("Container")) {
                Iterator valueChildren = attrElement.getChildren("value", this.opendapNameSpace).iterator();
                if (valueChildren.hasNext()) {
                    throw new AttributeBadValueException("Container Attributes may contain only other Attributes.\nContainer Attributes may NOT contain values.");
                }
                AttributeTable cacheAttributeTable = this.currentAT;
                if (this._Debug) {
                    System.out.println(indent + "currentBT: " + this.currentBT.getTypeName() + " " + this.currentBT.getClearName());
                }
                if (this._Debug) {
                    System.out.println(indent + "Attribute '" + name + "' is type " + typeName);
                }
                this.currentAT = this.currentAT == null ? this.currentBT.appendAttributeContainer(name) : this.currentAT.appendContainer(name);
                this.parseAttributes(attrElement, indent + "    ");
                this.parseAliases(attrElement, "+++ ");
                this.currentAT = cacheAttributeTable;
                continue;
            }
            Iterator attrChildren = attrElement.getChildren("Attribute", this.opendapNameSpace).iterator();
            if (attrChildren.hasNext()) {
                throw new AttributeBadValueException("Attributes must be of type Container in order to contain other Attributes.\nAttributes of types other than Container must contain values.");
            }
            for (Element valueChild : attrElement.getChildren("value", this.opendapNameSpace)) {
                String value = valueChild.getText();
                if (this._Debug) {
                    System.out.println(subIndent + "Attribute '" + name + "' of " + this.currentBT.getClearName() + " is type " + typeName + " and has value: " + value);
                }
                int typeVal = Attribute.getTypeVal(typeName);
                if (this.currentAT == null) {
                    this.currentBT.appendAttribute(name, typeVal, value, true);
                    continue;
                }
                this.currentAT.appendAttribute(name, typeVal, value, true);
            }
        }
        --this.parseLevel;
    }

    private void parseAliases(Element e, String indent) throws DASException {
        ++this.parseLevel;
        String subIndent = indent + "    ";
        if (this._Debug) {
            System.out.println(indent + "Parsing Aliases: ");
        }
        if (this._Debug) {
            System.out.println(subIndent + "currentBT: " + this.currentBT.getTypeName() + " " + this.currentBT.getClearName());
        }
        for (Element aliasElement : e.getChildren("Alias", this.opendapNameSpace)) {
            String name = null;
            org.jdom2.Attribute nameAttr = aliasElement.getAttribute("name");
            name = nameAttr.getValue();
            String attributeName = null;
            org.jdom2.Attribute attributeAttr = aliasElement.getAttribute("Attribute");
            attributeName = attributeAttr.getValue();
            if (this._Debug) {
                System.out.println(subIndent + "The name '" + name + "' is aliased to dds attribute: '" + attributeName + "'");
            }
            if (this.currentAT == null) {
                this.currentBT.addAttributeAlias(name, attributeName);
                continue;
            }
            this.currentAT.addAlias(name, attributeName);
        }
        --this.parseLevel;
    }

    public static String normalizeToXML(String s) {
        String xmlGT = "&gt;";
        String xmlLT = "&lt;";
        String xmlAmp = "&amp;";
        String xmlApos = "&apos;";
        String xmlQuote = "&quot;";
        boolean Debug = false;
        StringBuilder sb = new StringBuilder(s);
        block7: for (int offset = 0; offset < sb.length(); ++offset) {
            char c = sb.charAt(offset);
            switch (c) {
                case '>': {
                    sb.replace(offset, offset + 1, xmlGT);
                    continue block7;
                }
                case '<': {
                    sb.replace(offset, offset + 1, xmlLT);
                    continue block7;
                }
                case '&': {
                    sb.replace(offset, offset + 1, xmlAmp);
                    continue block7;
                }
                case '\'': {
                    sb.replace(offset, offset + 1, xmlApos);
                    continue block7;
                }
                case '\"': {
                    sb.replace(offset, offset + 1, xmlQuote);
                    continue block7;
                }
            }
        }
        if (Debug) {
            System.out.println("String: `" + s + "` normalized to: `" + sb + "`");
        }
        return sb.toString();
    }
}

