/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.parsers;

import java.io.IOException;
import opendap.dap.parsers.Dap2Parse;
import opendap.dap.parsers.Dap2Parser;
import opendap.dap.parsers.ParseException;

class Dap2Lex
implements Dap2Parser.Lexer {
    static final boolean DAP2STRING = true;
    static final int CONTEXTLEN = 20;
    static final String alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static final String numeric = "0123456789";
    static final String dapSpecLegal = "_!~*'-\"";
    static final String wordchars1 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_!~*'-\"-+._\\%/";
    static final String ddswordchars1 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_!~*'-\"-+._\\%/#";
    static final String ddswordcharsn = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_!~*'-\"-+._\\%/#";
    static final String daswordcharsn = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_!~*'-\"-+._\\%/#:()";
    static final String worddelims = "{}[]:;=,";
    static final String hexdigits = "0123456789abcdefABCDEF";
    static final String[] keywords = new String[]{"alias", "array", "attributes", "byte", "code", "dataset", "error", "float32", "float64", "grid", "int16", "int32", "maps", "message", "program", "program_type", "sequence", "string", "structure", "uint16", "uint32", "url", null};
    static final int[] keytokens = new int[]{258, 259, 260, 261, 262, 263, 265, 266, 267, 268, 269, 270, 271, 272, 280, 279, 273, 274, 275, 276, 277, 278};
    Dap2Parse parsestate = null;
    Object lval = null;
    TextStream text = null;
    int lineno = 0;
    int charno = 0;
    StringBuilder yytext = null;
    String wordcharsn = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_!~*'-\"-+._\\%/#";

    public Dap2Lex(Dap2Parse state) {
        this.reset(state);
    }

    public void reset(Dap2Parse state) {
        this.parsestate = state;
        this.text = new TextStream();
        this.yytext = new StringBuilder();
        this.lval = null;
    }

    void setText(String text) {
        this.text.setText(text);
    }

    public String getInput() {
        return this.text.text;
    }

    void dassetup() throws ParseException {
        this.wordcharsn = daswordcharsn;
    }

    @Override
    public int yylex() throws ParseException {
        int token = 0;
        this.yytext.setLength(0);
        this.text.mark();
        try {
            int c;
            token = -1;
            block6: while (token < 0 && (c = this.text.read()) > 0) {
                if (c == 10) {
                    ++this.lineno;
                    continue;
                }
                if (c <= 32 || c == 127) continue;
                if (c == 35) {
                    while ((c = this.text.read()) != 10 && c != 0) {
                    }
                    continue;
                }
                if (worddelims.indexOf(c) >= 0) {
                    token = c;
                    continue;
                }
                if (c == 34) {
                    boolean more = true;
                    while (more && (c = this.text.read()) > 0) {
                        switch (c) {
                            case 34: {
                                more = false;
                                break;
                            }
                            case 92: {
                                c = this.text.read();
                                if (c >= 0) break;
                                more = false;
                                break;
                            }
                        }
                        if (!more) continue;
                        this.yytext.append((char)c);
                    }
                    token = 282;
                    continue;
                }
                if (wordchars1.indexOf(c) >= 0) {
                    this.yytext.append((char)c);
                    while ((c = this.text.read()) > 0) {
                        if (this.wordcharsn.indexOf(c) < 0) {
                            this.text.backup();
                            break;
                        }
                        this.yytext.append((char)c);
                    }
                    token = 281;
                    String tmp = this.yytext.toString();
                    int i = 0;
                    while (keywords[i] != null) {
                        if (keywords[i].equalsIgnoreCase(tmp)) {
                            token = keytokens[i];
                            continue block6;
                        }
                        ++i;
                    }
                    continue;
                }
                String msg = String.format("Illegal Character: '%c'", c);
                this.yytext.append((char)c);
                this.lexerror(msg);
                throw new ParseException(msg);
            }
            if (token <= 0) {
                token = 0;
                this.lval = null;
            } else {
                Object object = this.lval = this.yytext.length() == 0 ? (String)null : this.yytext.toString();
            }
            if (this.parsestate.getDebugLevel() > 0) {
                this.dumptoken(token, (String)this.lval);
            }
            return token;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
    }

    void dumptoken(int token, String lval) throws ParseException {
        Object stoken;
        if (token == 281) {
            stoken = lval;
        } else if (token < 127) {
            stoken = "" + (char)token;
        } else {
            switch (token) {
                case 258: {
                    stoken = "alias";
                    break;
                }
                case 259: {
                    stoken = "array";
                    break;
                }
                case 260: {
                    stoken = "attributes";
                    break;
                }
                case 261: {
                    stoken = "byte";
                    break;
                }
                case 263: {
                    stoken = "dataset";
                    break;
                }
                case 266: {
                    stoken = "float32";
                    break;
                }
                case 267: {
                    stoken = "float64";
                    break;
                }
                case 268: {
                    stoken = "grid";
                    break;
                }
                case 269: {
                    stoken = "int16";
                    break;
                }
                case 270: {
                    stoken = "int32";
                    break;
                }
                case 271: {
                    stoken = "maps";
                    break;
                }
                case 273: {
                    stoken = "sequence";
                    break;
                }
                case 274: {
                    stoken = "string";
                    break;
                }
                case 275: {
                    stoken = "structure";
                    break;
                }
                case 276: {
                    stoken = "uint16";
                    break;
                }
                case 277: {
                    stoken = "uint32";
                    break;
                }
                case 278: {
                    stoken = "url";
                    break;
                }
                default: {
                    stoken = "X" + Integer.toString(token);
                }
            }
        }
        System.err.println("TOKEN = |" + (String)stoken + "|");
        if (stoken != null && ((String)stoken).length() == 1) {
            System.err.println("TOKEN = " + ((String)stoken).charAt(0));
        }
    }

    static int tohex(int c) throws ParseException {
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        return -1;
    }

    @Override
    public Object getLVal() {
        return this.lval;
    }

    @Override
    public void yyerror(String s) {
        String kind = "?";
        switch (this.parsestate.parseClass) {
            case 1: {
                kind = "DAS";
                break;
            }
            case 2: {
                kind = "DDS";
                break;
            }
            case 3: {
                kind = "Error";
                break;
            }
            default: {
                kind = "?";
            }
        }
        System.err.println("yyerror: " + s + "; " + kind + " parse failed at line: " + this.lineno + " char: " + this.charno + "; near: ");
        String context = this.parsestate.flatten(this.getInput());
        int show = context.length() < 20 ? context.length() : 20;
        System.err.println(context.substring(context.length() - show) + "^");
        if (this.parsestate.getURL() != null) {
            System.err.println("\turl=" + this.parsestate.getURL());
        }
        new Exception().printStackTrace(System.err);
    }

    public void lexerror(String msg) {
        StringBuilder nextline = new StringBuilder();
        int c = 0;
        for (int i = 0; i < 1024 && (c = this.text.read()) != 0 && c != 10; ++i) {
            nextline.append((char)c);
        }
        if (c != 0) {
            nextline.append("...");
        }
        System.out.printf("Lex error: %s; line: %d: %s^%s%n", msg, this.lineno, this.yytext, nextline);
    }

    static class TextStream {
        String text = null;
        int mark = 0;
        int next = 0;
        int len = 0;

        public String around() {
            String prefix = this.text.substring(this.mark - 10, this.mark);
            String suffix = this.text.substring(this.mark, this.mark + 10);
            return prefix + "|" + suffix;
        }

        public void setText(String text) {
            this.text = text;
            this.len = text.length();
        }

        public String toString() {
            return this.text;
        }

        boolean isEof() {
            return this.next >= this.len;
        }

        int peek() {
            if (this.next >= this.len) {
                return 0;
            }
            char c = this.text.charAt(this.next);
            return c;
        }

        void backup() {
            this.next = this.next <= 0 ? 0 : --this.next;
        }

        int read() {
            if (this.next >= this.len) {
                return 0;
            }
            char c = this.text.charAt(this.next);
            ++this.next;
            return c;
        }

        void mark() {
            this.mark = this.next;
        }
    }
}

