/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.util.ArrayList;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.dods.DodsNetcdfFiles;
import ucar.nc2.dods.DodsV;
import ucar.nc2.dods.DodsVariable;

class DodsGrid
extends DodsVariable {
    private static Logger logger = LoggerFactory.getLogger(DodsGrid.class);

    static Builder builder(Group.Builder parentGroup, String dodsShortName, DodsV dodsV) {
        Builder builder = (Builder)((Builder)((Builder)DodsGrid.builder().setName(DodsNetcdfFiles.makeShortName(dodsShortName))).setDataType(dodsV.getDataType())).setSPobject(dodsV);
        DodsV array = dodsV.children.get(0);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Formatter sbuff = new Formatter();
        for (int i = 1; i < dodsV.children.size(); ++i) {
            DodsV map = dodsV.children.get(i);
            String name = DodsNetcdfFiles.makeShortName(map.bt.getEncodedName());
            Dimension dim = parentGroup.findDimension(name).orElse(null);
            if (dim == null) {
                logger.warn("DODSGrid cant find dimension = <" + name + ">");
                continue;
            }
            dims.add(dim);
            sbuff.format("%s ", name);
        }
        builder.setDimensions(dims);
        builder.setDataType(array.getDataType());
        Attribute att = new Attribute("_CoordinateAxes", sbuff.toString());
        builder.addAttribute(att);
        return builder;
    }

    protected DodsGrid(Builder<?> builder, Group parentGroup) {
        super(builder, parentGroup);
    }

    @Override
    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(DodsGrid.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        return (Builder)super.addLocalFieldsToBuilder(b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends DodsVariable.Builder<T> {
        private boolean built;

        @Override
        public DodsGrid build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new DodsGrid(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        protected Builder2 self() {
            return this;
        }
    }
}

