/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DConnect2;
import opendap.dap.DDS;
import opendap.dap.DataDDS;
import opendap.dap.parsers.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.array.Array;
import ucar.array.ArrayType;
import ucar.array.ArraysConvert;
import ucar.array.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.ConvertD2N;
import ucar.nc2.dods.DodsBuilder;
import ucar.nc2.dods.DodsNetcdfFiles;
import ucar.nc2.dods.DodsV;
import ucar.nc2.internal.cache.FileCacheable;
import ucar.nc2.util.CancelTask;

@NotThreadSafe
public class DodsNetcdfFile
extends NetcdfFile {
    private static final Logger logger = LoggerFactory.getLogger(DodsNetcdfFile.class);
    static boolean accept_compress = false;
    private static boolean preload = true;
    private static int preloadCoordVarSize = 50000;
    private final ConvertD2N convertD2N = new ConvertD2N();
    private final DConnect2 dodsConnection;
    private final DDS dds;
    private final DAS das;

    public static void setAllowSessions(boolean b) {
        DConnect2.setAllowSessions(b);
    }

    public static void setAllowCompression(boolean b) {
        accept_compress = b;
    }

    public static void setPreload(boolean b) {
        preload = b;
    }

    public static void setCoordinateVariablePreloadSize(int size) {
        preloadCoordVarSize = size;
    }

    DodsNetcdfFile(DodsBuilder builder) throws IOException {
        super((NetcdfFile.Builder)builder);
        Preconditions.checkNotNull((Object)builder.dodsConnection);
        Preconditions.checkNotNull((Object)builder.dds);
        Preconditions.checkNotNull((Object)builder.das);
        this.dodsConnection = builder.dodsConnection;
        this.dds = builder.dds;
        this.das = builder.das;
        if (preload) {
            ArrayList<Variable> preloadList = new ArrayList<Variable>();
            for (Variable dodsVar : this.getVariables()) {
                long size = dodsVar.getSize() * (long)dodsVar.getElementSize();
                if ((!dodsVar.isCoordinateVariable() || size >= (long)preloadCoordVarSize) && !dodsVar.isCaching() && dodsVar.getArrayType() != ArrayType.STRING) continue;
                dodsVar.setCaching(true);
                preloadList.add(dodsVar);
                if (!DodsNetcdfFiles.debugPreload) continue;
                System.out.printf("  preload (%6d) %s%n", size, dodsVar.getFullName());
            }
            this.preloadData(preloadList);
        }
    }

    public synchronized void close() throws IOException {
        if (this.cache != null && this.cache.release((FileCacheable)this)) {
            return;
        }
        this.dodsConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataDDS readDataDDSfromServer(String CE) throws IOException, DAP2Exception {
        DataDDS data;
        if (DodsNetcdfFiles.debugServerCall) {
            System.out.println("DODSNetcdfFile.readDataDDSfromServer = <" + (String)CE + ">");
        }
        long start = 0L;
        if (DodsNetcdfFiles.debugTime) {
            start = System.currentTimeMillis();
        }
        if (!((String)CE).startsWith("?")) {
            CE = "?" + (String)CE;
        }
        DodsNetcdfFile dodsNetcdfFile = this;
        synchronized (dodsNetcdfFile) {
            data = this.dodsConnection.getData((String)CE, null);
        }
        if (DodsNetcdfFiles.debugTime) {
            System.out.println("DODSNetcdfFile.readDataDDSfromServer took = " + (double)(System.currentTimeMillis() - start) / 1000.0);
        }
        if (DodsNetcdfFiles.debugDataResult) {
            System.out.println(" dataDDS return:");
            data.print(System.out);
        }
        return data;
    }

    private void preloadData(List<Variable> preloadVariables) throws IOException {
        if (preloadVariables.size() == 0) {
            return;
        }
        ArrayList<DodsV> reqDodsVlist = new ArrayList<DodsV>();
        for (Variable var : preloadVariables) {
            if (var.hasCachedData()) continue;
            reqDodsVlist.add((DodsV)var.getSPobject());
        }
        Collections.sort(reqDodsVlist);
        HashMap<DodsV, DodsV> map = new HashMap<DodsV, DodsV>(2 * reqDodsVlist.size() + 1);
        int maxQueryLength = 4096 - this.getLocation().length();
        int lastRequestedVariableIndex = 0;
        if (reqDodsVlist.size() > 0) {
            while (lastRequestedVariableIndex < reqDodsVlist.size()) {
                DodsV root;
                DodsV dodsV;
                int newQueryLength;
                int queryLength = 0;
                int numberOfVarsInRequest = 0;
                StringBuilder requestString = new StringBuilder();
                while (queryLength <= maxQueryLength && lastRequestedVariableIndex < reqDodsVlist.size() && (newQueryLength = queryLength + (dodsV = (DodsV)reqDodsVlist.get(lastRequestedVariableIndex)).getEncodedName().length() + 1) < maxQueryLength) {
                    requestString.append(numberOfVarsInRequest == 0 ? "?" : ",");
                    requestString.append(dodsV.getEncodedName());
                    queryLength = newQueryLength;
                    ++lastRequestedVariableIndex;
                    numberOfVarsInRequest = (short)(numberOfVarsInRequest + 1);
                }
                try {
                    DataDDS dataDDS = this.readDataDDSfromServer(requestString.toString());
                    root = DodsV.parseDataDDS(dataDDS);
                }
                catch (Exception exc) {
                    logger.error("ERROR readDataDDSfromServer on " + requestString, (Throwable)exc);
                    throw new IOException(exc.getMessage());
                }
                for (int i = lastRequestedVariableIndex - numberOfVarsInRequest; i < lastRequestedVariableIndex; ++i) {
                    DodsV ddsV = (DodsV)reqDodsVlist.get(i);
                    DodsV dataV = root.findDataV(ddsV);
                    if (dataV != null) {
                        if (DodsNetcdfFiles.debugConvertData) {
                            System.out.println("readArray found dataV= " + DodsNetcdfFiles.makeDODSname(ddsV));
                        }
                        dataV.isDone = true;
                        map.put(ddsV, dataV);
                        continue;
                    }
                    logger.error("ERROR findDataV cant find " + DodsNetcdfFiles.makeDODSname(ddsV) + " on " + this.getLocation());
                }
            }
        }
        for (Variable var : preloadVariables) {
            ucar.ma2.Array data;
            if (var.hasCachedData()) continue;
            DodsV ddsV = (DodsV)var.getSPobject();
            DodsV dataV = (DodsV)map.get(ddsV);
            if (dataV == null) {
                logger.error("DODSNetcdfFile.readArrays cant find " + DodsNetcdfFiles.makeDODSname(ddsV) + " in dataDDS; " + this.getLocation());
                continue;
            }
            if (DodsNetcdfFiles.debugConvertData) {
                System.out.println("readArray converting " + DodsNetcdfFiles.makeDODSname(ddsV));
            }
            dataV.isDone = true;
            try {
                if (var.isMemberOfStructure()) {
                    while (dataV.parent != null && dataV.parent.bt != null) {
                        dataV = dataV.parent;
                    }
                    data = this.convertD2N.convertNestedVariable(var, null, dataV, true);
                } else {
                    data = this.convertD2N.convertTopVariable(var, null, dataV);
                }
            }
            catch (DAP2Exception de) {
                logger.error("ERROR convertVariable on " + var.getFullName(), (Throwable)de);
                throw new IOException(de.getMessage());
            }
            if (!var.isCaching()) continue;
            this.setCachedData(var, ArraysConvert.convertToArray((ucar.ma2.Array)data));
            if (!DodsNetcdfFiles.debugCached) continue;
            System.out.println(" cache for <" + var.getFullName() + "> length =" + data.getSize());
        }
    }

    public ucar.ma2.Array readSection(String variableSection) throws IOException, ucar.ma2.InvalidRangeException {
        ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)this, (String)variableSection);
        return this.readData(cer.getVariable(), cer.getSection());
    }

    protected Array<?> readArrayData(Variable v, ucar.array.Section section) throws IOException, InvalidRangeException {
        Section sectionOld = ArraysConvert.convertSection((ucar.array.Section)section);
        try {
            ucar.ma2.Array result = this.readData(v, sectionOld);
            return ArraysConvert.convertToArray((ucar.ma2.Array)result);
        }
        catch (ucar.ma2.InvalidRangeException e) {
            throw new InvalidRangeException(e);
        }
    }

    protected ucar.ma2.Array readData(Variable v, Section section) throws IOException, ucar.ma2.InvalidRangeException {
        ucar.ma2.Array dataArray;
        StringBuilder buff = new StringBuilder(100);
        buff.setLength(0);
        buff.append(DodsNetcdfFiles.getDODSConstraintName(v));
        if (!v.isVariableLength()) {
            int n;
            List dodsSection = section.getRanges();
            if (v.getArrayType() == ArrayType.CHAR && (n = section.getRank()) == v.getRank()) {
                dodsSection = dodsSection.subList(0, n - 1);
            }
            this.makeSelector(buff, dodsSection);
        }
        try {
            DataDDS dataDDS = this.readDataDDSfromServer(buff.toString());
            DodsV root = DodsV.parseDataDDS(dataDDS);
            DodsV want = null;
            for (int i = 0; i < root.children.size(); ++i) {
                DodsV element = root.children.get(i);
                if (!element.getFullName().equals(v.getFullName())) continue;
                want = element;
                break;
            }
            if (want == null) {
                throw new ParseException("Variable " + v.getFullName() + " not found in DDS.");
            }
            dataArray = this.convertD2N.convertTopVariable(v, section.getRanges(), want);
            if (this.getLocation().startsWith("file:")) {
                dataArray = dataArray.section(section.getRanges());
            }
        }
        catch (DAP2Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage() + "; " + v.getShortName() + " -- " + section);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        return dataArray;
    }

    public ucar.ma2.Array readWithCE(Variable v, String CE) throws IOException {
        ucar.ma2.Array dataArray;
        try {
            DataDDS dataDDS = this.readDataDDSfromServer(CE);
            DodsV root = DodsV.parseDataDDS(dataDDS);
            DodsV want = root.children.get(0);
            dataArray = v.isMemberOfStructure() ? this.convertD2N.convertNestedVariable(v, null, want, true) : this.convertD2N.convertTopVariable(v, null, want);
        }
        catch (DAP2Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
        return dataArray;
    }

    private int addParents(StringBuilder buff, Variable s, List<Range> section, int start) {
        Structure parent = s.getParentStructure();
        if (parent != null) {
            start = this.addParents(buff, (Variable)parent, section, start);
            buff.append(".");
        }
        List<Range> subSection = section.subList(start, start + s.getRank());
        buff.append(DodsNetcdfFiles.getDODSConstraintName(s));
        if (!s.isVariableLength()) {
            this.makeSelector(buff, subSection);
        }
        return start + s.getRank();
    }

    private void makeSelector(StringBuilder buff, List<Range> section) {
        for (Range r : section) {
            buff.append("[");
            buff.append(r.first());
            buff.append(':');
            buff.append(r.stride());
            buff.append(':');
            buff.append(r.last());
            buff.append("]");
        }
    }

    public void getDetailInfo(Formatter f) {
        super.getDetailInfo(f);
        f.format("DDS = %n", new Object[0]);
        ByteArrayOutputStream buffOS = new ByteArrayOutputStream(8000);
        this.dds.print(buffOS);
        f.format("%s%n", new String(buffOS.toByteArray(), StandardCharsets.UTF_8));
        f.format("%nDAS = %n", new Object[0]);
        buffOS = new ByteArrayOutputStream(8000);
        this.das.print(buffOS);
        f.format("%s%n", new String(buffOS.toByteArray(), StandardCharsets.UTF_8));
    }

    public String getFileTypeId() {
        return "OPeNDAP";
    }

    public String getFileTypeDescription() {
        return "Open-source Project for a Network Data Access Protocol";
    }

    public static Builder2 builder() {
        return new Builder2();
    }

    public static class Builder2
    extends DodsBuilder<Builder2> {
        @Override
        protected Builder2 self() {
            return this;
        }

        @Override
        public DodsNetcdfFile build(String datasetUrl, CancelTask cancelTask) throws IOException {
            return super.build(datasetUrl, cancelTask);
        }
    }
}

