/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import opendap.dap.BaseType;
import opendap.dap.DByte;
import opendap.dap.DFloat32;
import opendap.dap.DFloat64;
import opendap.dap.DGrid;
import opendap.dap.DInt16;
import opendap.dap.DInt32;
import opendap.dap.DSequence;
import opendap.dap.DString;
import opendap.dap.DStructure;
import opendap.dap.DUInt16;
import opendap.dap.DUInt32;
import ucar.ma2.DataType;
import ucar.nc2.Variable;
import ucar.nc2.dods.DodsNode;
import ucar.nc2.dods.DodsV;
import ucar.nc2.dods.EscapeStringsDap;
import ucar.nc2.util.DebugFlags;

public class DodsNetcdfFiles {
    static boolean debugCE = false;
    static boolean debugServerCall = false;
    static boolean debugOpenResult = false;
    static boolean debugDataResult = false;
    static boolean debugCharArray = false;
    static boolean debugConvertData = false;
    static boolean debugConstruct = false;
    static boolean debugPreload = false;
    static boolean debugTime = false;
    static boolean showNCfile = false;
    static boolean debugAttributes = false;
    static boolean debugCached = false;
    static boolean debugOpenTime = false;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugCE = debugFlag.isSet("DODS/constraintExpression");
        debugServerCall = debugFlag.isSet("DODS/serverCall");
        debugOpenResult = debugFlag.isSet("DODS/debugOpenResult");
        debugDataResult = debugFlag.isSet("DODS/debugDataResult");
        debugCharArray = debugFlag.isSet("DODS/charArray");
        debugConstruct = debugFlag.isSet("DODS/constructNetcdf");
        debugPreload = debugFlag.isSet("DODS/preload");
        debugTime = debugFlag.isSet("DODS/timeCalls");
        showNCfile = debugFlag.isSet("DODS/showNCfile");
        debugAttributes = debugFlag.isSet("DODS/attributes");
        debugCached = debugFlag.isSet("DODS/cache");
    }

    public static String canonicalURL(String urlName) {
        if (urlName.startsWith("http:")) {
            return "dods:" + urlName.substring(5);
        }
        if (urlName.startsWith("https:")) {
            return "dods:" + urlName.substring(6);
        }
        return urlName;
    }

    static String getDODSConstraintName(Variable var) {
        String vname = ((DodsNode)var).getDodsName();
        return EscapeStringsDap.backslashToDAP(vname);
    }

    public static String makeDODSname(DodsV dodsV) {
        DodsV parent = dodsV.parent;
        if (parent.bt != null) {
            return DodsNetcdfFiles.makeDODSname(parent) + "." + dodsV.bt.getEncodedName();
        }
        return dodsV.bt.getEncodedName();
    }

    public static String makeShortName(String name) {
        String unescaped = EscapeStringsDap.unescapeDAPIdentifier(name);
        int index = unescaped.lastIndexOf(47);
        if (index < 0) {
            index = -1;
        }
        return unescaped.substring(index + 1, unescaped.length());
    }

    public static String makeDODSName(String name) {
        return EscapeStringsDap.unescapeDAPIdentifier(name);
    }

    public static int convertToDODSType(DataType dataType) {
        if (dataType == DataType.STRING) {
            return 10;
        }
        if (dataType == DataType.BYTE) {
            return 3;
        }
        if (dataType == DataType.FLOAT) {
            return 8;
        }
        if (dataType == DataType.DOUBLE) {
            return 9;
        }
        if (dataType == DataType.SHORT) {
            return 4;
        }
        if (dataType == DataType.USHORT) {
            return 5;
        }
        if (dataType == DataType.INT) {
            return 6;
        }
        if (dataType == DataType.UINT) {
            return 7;
        }
        if (dataType == DataType.BOOLEAN) {
            return 3;
        }
        if (dataType == DataType.LONG) {
            return 6;
        }
        return 10;
    }

    public static DataType convertToNCType(int dodsDataType, boolean isUnsigned) {
        switch (dodsDataType) {
            case 3: {
                return isUnsigned ? DataType.UBYTE : DataType.BYTE;
            }
            case 8: {
                return DataType.FLOAT;
            }
            case 9: {
                return DataType.DOUBLE;
            }
            case 4: {
                return DataType.SHORT;
            }
            case 5: {
                return DataType.USHORT;
            }
            case 6: {
                return DataType.INT;
            }
            case 7: {
                return DataType.UINT;
            }
        }
        return DataType.STRING;
    }

    public static DataType convertToNCType(BaseType dtype, boolean isUnsigned) {
        if (dtype instanceof DString) {
            return DataType.STRING;
        }
        if (dtype instanceof DStructure || dtype instanceof DSequence || dtype instanceof DGrid) {
            return DataType.STRUCTURE;
        }
        if (dtype instanceof DFloat32) {
            return DataType.FLOAT;
        }
        if (dtype instanceof DFloat64) {
            return DataType.DOUBLE;
        }
        if (dtype instanceof DUInt32) {
            return DataType.UINT;
        }
        if (dtype instanceof DUInt16) {
            return DataType.USHORT;
        }
        if (dtype instanceof DInt32) {
            return DataType.INT;
        }
        if (dtype instanceof DInt16) {
            return DataType.SHORT;
        }
        if (dtype instanceof DByte) {
            return isUnsigned ? DataType.UBYTE : DataType.BYTE;
        }
        throw new IllegalArgumentException("DODSVariable illegal type = " + dtype.getTypeName());
    }

    public static boolean isUnsigned(BaseType dtype) {
        return dtype instanceof DByte || dtype instanceof DUInt16 || dtype instanceof DUInt32;
    }
}

