/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import ucar.nc2.internal.util.EscapeStrings;

public class EscapeStringsDap {
    private static final String _allowableInDAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_!~*'-\"./";
    private static final char _URIEscape = '%';

    public static String backslashEscapeDapString(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < ' ') {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        buf.append(c);
                        break;
                    }
                    default: {
                        buf.append(String.format("\\x%02x", c & 0xFF));
                        break;
                    }
                }
                continue;
            }
            if (c == '\"') {
                buf.append("\\\"");
                continue;
            }
            if (c == '\\') {
                buf.append("\\\\");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String backslashToDAP(String bs) {
        StringBuilder buf = new StringBuilder();
        int len = bs.length();
        for (int i = 0; i < len; ++i) {
            char c = bs.charAt(i);
            if (i < len - 1 && c == '\\') {
                c = bs.charAt(++i);
            }
            if (_allowableInDAP.indexOf(c) < 0) {
                buf.append('%');
                String ashex = Integer.toHexString(c);
                if (ashex.length() < 2) {
                    buf.append('0');
                }
                buf.append(ashex);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String unescapeDAPIdentifier(String id) {
        String s;
        try {
            s = EscapeStrings.unescapeString((String)id);
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public static String escapeDAPIdentifier(String s) {
        return EscapeStrings.escapeString((String)s, (String)_allowableInDAP);
    }
}

