/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.util.DeepCopyUtils;
import thredds.server.catalogservice.CatalogServiceUtils;
import thredds.server.catalogservice.Command;
import thredds.server.catalogservice.LocalCatalogRequest;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.HtmlWriter;
import thredds.util.RequestForwardUtils;

@Component
@RequestMapping(value={"**"})
public class LocalCatalogServiceController {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private HtmlWriter htmlWriter;
    private boolean catalogSupportOnly = false;

    public boolean isCatalogSupportOnly() {
        return this.catalogSupportOnly;
    }

    public void setCatalogSupportOnly(boolean catalogSupportOnly) {
        this.catalogSupportOnly = catalogSupportOnly;
    }

    @RequestMapping(value={"**/*.xml"}, method={RequestMethod.GET})
    protected ModelAndView handleXmlRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            BindingResult bindingResult = CatalogServiceUtils.bindAndValidateLocalCatalogRequest(request, false);
            if (bindingResult.hasErrors()) {
                StringBuilder msg = new StringBuilder("Bad request");
                List oeList = bindingResult.getAllErrors();
                for (ObjectError e : oeList) {
                    msg.append(": ").append(e.getDefaultMessage() != null ? e.getDefaultMessage() : e.toString());
                }
                this.log.info("handleRequestInternal(): " + msg);
                response.sendError(400, msg.toString());
                return null;
            }
            LocalCatalogRequest catalogServiceRequest = (LocalCatalogRequest)bindingResult.getTarget();
            String catalogPath = catalogServiceRequest.getPath();
            DataRootHandler drh = DataRootHandler.getInstance();
            InvCatalog catalog = null;
            String baseUriString = request.getRequestURL().toString();
            try {
                catalog = drh.getCatalog(catalogPath, new URI(baseUriString));
            }
            catch (URISyntaxException e) {
                String msg = "Bad URI syntax [" + baseUriString + "]: " + e.getMessage();
                this.log.error("handleRequestInternal(): " + msg);
                response.sendError(400, msg);
                return null;
            }
            if (catalog == null) {
                return this.handlePublicDocumentRequest(request, response, catalogPath);
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.SHOW)) {
                return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)catalog);
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.SUBSET)) {
                String datasetId = catalogServiceRequest.getDataset();
                InvDataset dataset = catalog.findDatasetByID(datasetId);
                if (dataset == null) {
                    String msg = "Did not find dataset [" + datasetId + "] in catalog [" + baseUriString + "].";
                    response.sendError(404, msg);
                    return null;
                }
                InvCatalog subsetCat = DeepCopyUtils.subsetCatalogOnDataset((InvCatalog)catalog, (InvDataset)dataset);
                return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)subsetCat);
            }
            String msg = "Unsupported request command [" + (Object)((Object)catalogServiceRequest.getCommand()) + "].";
            this.log.error("handleRequestInternal(): " + msg + " -- NOTE: Should have been caught on input validation.");
            response.sendError(400, msg);
            return null;
        }
        catch (IOException e) {
            this.log.error("handleRequestInternal(): Trouble writing to response.", (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            this.log.error("handleRequestInternal(): Problem handling request.", e);
            if (!response.isCommitted()) {
                response.sendError(500);
            }
            return null;
        }
    }

    @RequestMapping(value={"**/*.html"}, method={RequestMethod.GET})
    protected ModelAndView handleHtmlRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            BindingResult bindingResult = CatalogServiceUtils.bindAndValidateLocalCatalogRequest(request, true);
            if (bindingResult.hasErrors()) {
                StringBuilder msg = new StringBuilder("Bad request");
                List oeList = bindingResult.getAllErrors();
                for (ObjectError e : oeList) {
                    msg.append(": ").append(e.getDefaultMessage() != null ? e.getDefaultMessage() : e.toString());
                }
                this.log.info("handleRequestInternal(): " + msg);
                response.sendError(400, msg.toString());
                return null;
            }
            LocalCatalogRequest catalogServiceRequest = (LocalCatalogRequest)bindingResult.getTarget();
            String path = catalogServiceRequest.getPath();
            String catalogPath = path.replaceAll(".html$", ".xml");
            DataRootHandler drh = DataRootHandler.getInstance();
            InvCatalog catalog = null;
            String baseUriString = request.getRequestURL().toString();
            try {
                catalog = drh.getCatalog(catalogPath, new URI(baseUriString));
            }
            catch (URISyntaxException e) {
                String msg = "Bad URI syntax [" + baseUriString + "]: " + e.getMessage();
                this.log.error("handleRequestInternal(): " + msg);
                response.sendError(400, msg);
                return null;
            }
            if (catalog == null) {
                return this.handlePublicDocumentRequest(request, response, path);
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.SHOW)) {
                int i = this.htmlWriter.writeCatalog(request, response, (InvCatalogImpl)catalog, true);
                return null;
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.SUBSET)) {
                String datasetId = catalogServiceRequest.getDataset();
                InvDataset dataset = catalog.findDatasetByID(datasetId);
                if (dataset == null) {
                    String msg = "Did not find dataset [" + datasetId + "] in catalog [" + baseUriString + "].";
                    response.sendError(404, msg);
                    return null;
                }
                int i = this.htmlWriter.showDataset(baseUriString, (InvDatasetImpl)dataset, request, response, true);
                return null;
            }
            String msg = "Unsupported request command [" + (Object)((Object)catalogServiceRequest.getCommand()) + "].";
            this.log.error("handleRequestInternal(): " + msg + " -- NOTE: Should have been caught on input validation.");
            response.sendError(400, msg);
            return null;
        }
        catch (IOException e) {
            this.log.error("handleRequestInternal(): Trouble writing to response.", (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            this.log.error("handleRequestInternal(): Problem handling request.", e);
            if (!response.isCommitted()) {
                response.sendError(500);
            }
            return null;
        }
    }

    private ModelAndView handlePublicDocumentRequest(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, ServletException {
        if (this.catalogSupportOnly) {
            response.sendError(404);
            return null;
        }
        File publicFile = this.tdsContext.getPublicDocFileSource().getFile(path);
        if (publicFile != null) {
            return new ModelAndView("threddsFileView", "file", (Object)publicFile);
        }
        RequestForwardUtils.forwardRequest(path, this.tdsContext.getDefaultRequestDispatcher(), request, response);
        return null;
    }

    @ExceptionHandler(value={FileNotFoundException.class})
    public ResponseEntity<String> handle(FileNotFoundException ncsse) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)("NetCDF Subset Service exception handled : " + ncsse.getMessage()), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
    }
}

