/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.net.URI;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import thredds.server.catalogservice.Command;
import thredds.server.catalogservice.RemoteCatalogRequest;

public class RemoteCatalogRequestValidator
implements Validator {
    public boolean supports(Class clazz) {
        return RemoteCatalogRequest.class.equals((Object)clazz);
    }

    public void validate(Object obj, Errors e) {
        RemoteCatalogRequest rcr = (RemoteCatalogRequest)obj;
        URI catUri = rcr.getCatalogUri();
        ValidationUtils.rejectIfEmpty((Errors)e, (String)"catalogUri", (String)"catalogUri.empty", (String)"No catalog URI given.");
        if (catUri != null) {
            if (!catUri.isAbsolute()) {
                e.rejectValue("catalogUri", "catalogUri.notAbsolute", "The \"catalogUri\" field must be an absolute URI.");
            }
            if (catUri.getScheme() != null && !catUri.getScheme().equalsIgnoreCase("HTTP")) {
                e.rejectValue("catalogUri", "catalogUri.notHttpUri", "The \"catalogUri\" field must be an HTTP URI.");
            }
        }
        ValidationUtils.rejectIfEmpty((Errors)e, (String)"command", (String)"command.empty");
        if (rcr.getCommand().equals((Object)Command.SHOW)) {
            ValidationUtils.rejectIfEmpty((Errors)e, (String)"htmlView", (String)"htmlView.empty");
            if (!rcr.isHtmlView()) {
                e.rejectValue("htmlView", "htmlView.falseForRemoteCatalogShow", "A remote catalog is already available as XML.");
            }
        }
        if (rcr.getCommand().equals((Object)Command.SUBSET)) {
            ValidationUtils.rejectIfEmpty((Errors)e, (String)"dataset", (String)"dataset.empty", (String)"No dataset specified in SUBSET request.");
            ValidationUtils.rejectIfEmpty((Errors)e, (String)"htmlView", (String)"htmlView.empty");
        }
        if (rcr.getCommand().equals((Object)Command.VALIDATE)) {
            ValidationUtils.rejectIfEmpty((Errors)e, (String)"verbose", (String)"verbose.empty");
        }
    }
}

