/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import java.text.ParseException;
import java.util.Formatter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class CdmRemoteQueryBean {
    private String req = "";
    private String accept = "";
    private String variables;
    private String var;
    private String spatial;
    private TemporalSelection temporalSelection;
    private String stn;
    private String bbox;
    private String west;
    private String east;
    private String south;
    private String north;
    private String latitude;
    private String longitude;
    private String temporal;
    private SpatialSelection spatialSelection;
    private String time_start;
    private String time_end;
    private String time_duration;
    private String time;
    private DateRange dateRange;
    private DateType timePoint;
    private LatLonRect llbb;
    private LatLonPoint latlonPoint;
    private RequestType reqType = null;
    private ResponseType resType = null;
    private boolean fatal = false;
    private Formatter errs = new Formatter();

    boolean hasFatalError() {
        return this.fatal;
    }

    String getErrorMessage() {
        return this.errs.toString();
    }

    public LatLonRect getLatLonRect() {
        return this.spatialSelection == SpatialSelection.bb ? this.llbb : null;
    }

    DateRange getDateRange() {
        return this.dateRange;
    }

    public LatLonPoint getLatlonPoint() {
        return this.latlonPoint;
    }

    public DateType getTimePoint() {
        return this.timePoint;
    }

    public RequestType getRequestType() {
        if (this.reqType == null) {
            this.reqType = this.req.equalsIgnoreCase("capabilities") ? RequestType.capabilities : (this.req.equalsIgnoreCase("cdl") ? RequestType.cdl : (this.req.equalsIgnoreCase("data") ? RequestType.data : (this.req.equalsIgnoreCase("dataForm") ? RequestType.dataForm : (this.req.equalsIgnoreCase("form") ? RequestType.form : (this.req.equalsIgnoreCase("header") ? RequestType.header : (this.req.equalsIgnoreCase("ncml") ? RequestType.ncml : (this.req.equalsIgnoreCase("stations") ? RequestType.stations : RequestType.data)))))));
        }
        return this.reqType;
    }

    ResponseType getResponseType() {
        if (this.resType == null) {
            RequestType req = this.getRequestType();
            if (req == RequestType.capabilities) {
                this.resType = ResponseType.xml;
            } else if (req == RequestType.form) {
                this.resType = ResponseType.html;
            }
        }
        if (this.resType == null) {
            this.resType = this.accept.equalsIgnoreCase("csv") ? ResponseType.csv : (this.accept.equalsIgnoreCase("ncstream") ? ResponseType.ncstream : (this.accept.equalsIgnoreCase("netcdf") ? ResponseType.netcdf : (this.accept.equalsIgnoreCase("xml") ? ResponseType.xml : ResponseType.ncstream)));
        }
        return this.resType;
    }

    SpatialSelection getSpatialSelection() {
        return this.spatialSelection;
    }

    TemporalSelection getTemporalSelection() {
        return this.temporalSelection;
    }

    boolean validate() {
        RequestType reqType = this.getRequestType();
        if (reqType == RequestType.dataForm) {
            this.parseVariablesForm();
            this.parseSpatialExtentForm();
            this.parseTemporalExtentForm();
        } else {
            this.parseSpatialExtent();
            this.parseTimeExtent();
            if (this.spatialSelection == null && this.stn != null) {
                this.spatialSelection = SpatialSelection.stns;
            }
        }
        return !this.fatal;
    }

    private void parseVariablesForm() {
        if (this.variables == null) {
            this.errs.format("form must have variables=(all|some)%n", new Object[0]);
            this.fatal = true;
            return;
        }
        if (this.variables.equalsIgnoreCase("all")) {
            this.setVar(null);
        }
    }

    private void parseSpatialExtentForm() {
        if (this.spatial == null) {
            this.errs.format("form must have spatial=(all|bb|point|stns)%n", new Object[0]);
            this.fatal = true;
            return;
        }
        if (this.spatial.equalsIgnoreCase("all")) {
            this.spatialSelection = SpatialSelection.all;
        } else if (this.spatial.equalsIgnoreCase("bb")) {
            this.spatialSelection = SpatialSelection.bb;
        } else if (this.spatial.equalsIgnoreCase("point")) {
            this.spatialSelection = SpatialSelection.point;
        } else if (this.spatial.equalsIgnoreCase("stns")) {
            this.spatialSelection = SpatialSelection.stns;
        }
        if (this.spatialSelection == SpatialSelection.bb) {
            this.parseSpatialExtent();
        } else if (this.spatialSelection == SpatialSelection.point) {
            double lat = this.parseLat("latitude", this.latitude);
            double lon = this.parseLon("longitude", this.longitude);
            this.latlonPoint = new LatLonPointImpl(lat, lon);
        }
    }

    private void parseSpatialExtent() {
        if (this.bbox != null) {
            String[] s = this.bbox.split(",");
            if (s.length != 4) {
                this.errs.format("bbox must have form 'bbox=west,east,south,north'; found 'bbox=%s'%n", this.bbox);
                this.fatal = true;
                return;
            }
            this.west = s[0];
            this.east = s[1];
            this.south = s[2];
            this.north = s[3];
        }
        if (this.west != null || this.east != null || this.south != null || this.north != null) {
            if (this.west == null || this.east == null || this.south == null || this.north == null) {
                this.errs.format("All edges (west,east,south,north) must be specified; found west=%s east=%s south=%s north=%s %n", this.west, this.east, this.south, this.north);
                this.fatal = true;
                return;
            }
            double westd = this.parseLon("west", this.west);
            double eastd = this.parseLon("east", this.east);
            double southd = this.parseLat("south", this.south);
            double northd = this.parseLat("north", this.north);
            if (!this.fatal) {
                this.llbb = new LatLonRect((LatLonPoint)new LatLonPointImpl(southd, westd), (LatLonPoint)new LatLonPointImpl(northd, eastd));
                this.spatialSelection = SpatialSelection.bb;
            }
        }
    }

    private double parseLat(String key, String value) {
        double lat = this.parseDouble(key, value);
        if (!Double.isNaN(lat) && (lat > 90.0 || lat < -90.0)) {
            this.errs.format("Illegal param= param='%s=%s' must be between +/- 90.0 %n", key, value);
            lat = Double.NaN;
            this.fatal = true;
        }
        return lat;
    }

    private double parseLon(String key, String value) {
        return this.parseDouble(key, value);
    }

    private double parseDouble(String key, String value) {
        value = value.trim();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            this.errs.format("Illegal param='%s=%s' must be valid floating point number%n", key, value);
            this.fatal = true;
            return Double.NaN;
        }
    }

    private void parseTemporalExtentForm() {
        if (this.temporal == null) {
            this.errs.format("form must have temporal=(all|range|point)%n", new Object[0]);
            this.fatal = true;
            return;
        }
        if (this.temporal.equalsIgnoreCase("all")) {
            this.temporalSelection = TemporalSelection.all;
        } else if (this.temporal.equalsIgnoreCase("range")) {
            this.temporalSelection = TemporalSelection.range;
        } else if (this.temporal.equalsIgnoreCase("point")) {
            this.temporalSelection = TemporalSelection.point;
        }
        if (this.temporal.equalsIgnoreCase("range")) {
            try {
                this.parseTimeExtent();
            }
            catch (Throwable t) {
                this.errs.format("badly specified time range", new Object[0]);
                this.fatal = true;
                return;
            }
        } else if (this.temporal.equalsIgnoreCase("point")) {
            this.timePoint = this.parseDate("time", this.time);
        }
    }

    private void parseTimeExtent() {
        DateType startDate = this.parseDate("time_start", this.time_start);
        DateType endDate = this.parseDate("time_end", this.time_end);
        TimeDuration duration = this.parseW3CDuration("time_duration", this.time_duration);
        if (startDate != null && endDate != null) {
            this.dateRange = new DateRange(startDate, endDate, null, null);
        } else if (startDate != null && duration != null) {
            this.dateRange = new DateRange(startDate, null, duration, null);
        } else if (endDate != null && duration != null) {
            this.dateRange = new DateRange(null, endDate, duration, null);
        }
        if (this.dateRange != null) {
            this.temporalSelection = TemporalSelection.range;
        }
    }

    public DateType parseDate(String key, String value) {
        if (value != null) {
            try {
                return new DateType(value, null, null);
            }
            catch (ParseException e) {
                this.errs.format("Illegal param='%s=%s'  must be valid ISO Date%n", key, value);
                this.fatal = true;
            }
        }
        return null;
    }

    public TimeDuration parseW3CDuration(String key, String value) {
        if (value != null) {
            try {
                return new TimeDuration(value);
            }
            catch (ParseException e) {
                this.errs.format("Illegal param='%s=%s'  must be valid ISO Duration%n", key, value);
                this.fatal = true;
            }
        }
        return null;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public void setReq(String req) {
        this.req = req;
    }

    public void setVariables(String variables) {
        this.variables = variables;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getVar() {
        return this.var;
    }

    public String[] getVarNames() {
        return this.var == null ? null : this.var.split(",");
    }

    public void setSpatial(String spatial) {
        this.spatial = spatial;
    }

    public void setStn(String stn) {
        this.stn = stn;
    }

    public String getStn() {
        return this.stn;
    }

    public String[] getStnNames() {
        if (this.spatialSelection != SpatialSelection.stns) {
            return null;
        }
        return this.stn == null ? null : this.stn.split(",");
    }

    public void setBbox(String bbox) {
        this.bbox = bbox;
    }

    public void setWest(String west) {
        this.west = west;
    }

    public void setEast(String east) {
        this.east = east;
    }

    public void setSouth(String south) {
        this.south = south;
    }

    public void setNorth(String north) {
        this.north = north;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setTemporal(String temporal) {
        this.temporal = temporal;
    }

    public void setTime_start(String timeStart) {
        this.time_start = timeStart;
    }

    public void setTime_end(String timeEnd) {
        this.time_end = timeEnd;
    }

    public void setTime_duration(String timeDuration) {
        this.time_duration = timeDuration;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("QueryBean: reqType=%s resType=%s", new Object[]{this.getRequestType(), this.getResponseType()});
        if (this.spatialSelection == SpatialSelection.all) {
            f.format(" spatialSelection=all;", new Object[0]);
        } else if (this.spatialSelection == SpatialSelection.bb) {
            f.format(" bb=%s;", this.getLatLonRect());
        } else if (this.spatialSelection == SpatialSelection.stns) {
            f.format(" stns=%s;", this.getStn());
        }
        if (this.temporalSelection == TemporalSelection.all) {
            f.format(" temporalSelection=all;", new Object[0]);
        } else if (this.temporalSelection == TemporalSelection.range) {
            f.format(" range=%s;", this.getDateRange());
        }
        if (this.var != null) {
            f.format(" vars=%s", this.var);
        }
        return f.toString();
    }

    public static enum TemporalSelection {
        all,
        range,
        point;

    }

    public static enum SpatialSelection {
        all,
        bb,
        point,
        stns;

    }

    public static enum ResponseType {
        csv,
        netcdf,
        ncstream,
        html,
        xml;

    }

    public static enum RequestType {
        capabilities,
        cdl,
        data,
        dataForm,
        form,
        header,
        ncml,
        stations;

    }
}

