/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.controller;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import thredds.server.ncss.controller.NcssController;
import thredds.server.ncss.exception.OutOfBoundariesException;
import thredds.server.ncss.exception.TimeOutOfWindowException;
import thredds.server.ncss.exception.VariableNotContainedInDatasetException;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.util.NcssRequestUtils;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public abstract class GridDatasetResponder {
    public static CalendarDateRange getRequestedDateRange(NcssParamsBean params) throws ParseException {
        if (params.getTime() != null) {
            CalendarDate date = null;
            date = params.getTime().equalsIgnoreCase("present") ? CalendarDate.of((Date)new Date()) : CalendarDateFormatter.isoStringToCalendarDate(null, (String)params.getTime());
            return CalendarDateRange.of((CalendarDate)date, (CalendarDate)date);
        }
        CalendarDateRange dates = null;
        DateRange dr = new DateRange(new DateType(params.getTime_start(), null, null), new DateType(params.getTime_end(), null, null), new TimeDuration(params.getTime_duration()), null);
        dates = CalendarDateRange.of((CalendarDate)dr.getStart().getCalendarDate(), (CalendarDate)dr.getEnd().getCalendarDate());
        return dates;
    }

    public static String buildCacheUrl(String fileName) {
        return NcssRequestUtils.getTdsContext().getContextPath() + NcssController.getNCSSServletPath() + "/" + fileName;
    }

    protected boolean checkRequestedVars(GridDataset gds, NcssParamsBean params) throws VariableNotContainedInDatasetException {
        Iterator<String> it;
        String varName;
        GridDatatype grid;
        if (params.getVar() == null || params.getVar().isEmpty()) {
            return false;
        }
        if (params.getVar().get(0).equals("all")) {
            params.setVar(NcssRequestUtils.getAllVarsAsList((ucar.nc2.dt.GridDataset)gds));
        }
        if ((grid = gds.findGridDatatype(varName = (it = params.getVar().iterator()).next())) == null) {
            throw new VariableNotContainedInDatasetException("Variable: " + varName + " is not contained in the requested dataset");
        }
        CoordinateAxis1D vertAxis = grid.getCoordinateSystem().getVerticalAxis();
        CoordinateAxis1D newVertAxis = null;
        boolean sameVertCoord = true;
        while (sameVertCoord && it.hasNext()) {
            varName = it.next();
            grid = gds.findGridDatatype(varName);
            if (grid == null) {
                throw new VariableNotContainedInDatasetException("Variable: " + varName + " is not contained in the requested dataset");
            }
            newVertAxis = grid.getCoordinateSystem().getVerticalAxis();
            if (vertAxis != null) {
                if (vertAxis.equals((Object)newVertAxis)) {
                    vertAxis = newVertAxis;
                    continue;
                }
                sameVertCoord = false;
                continue;
            }
            if (newVertAxis == null) continue;
            sameVertCoord = false;
        }
        return sameVertCoord;
    }

    protected Map<String, List<String>> groupVarsByVertLevels(GridDataset gds, NcssParamsBean params) throws VariableNotContainedInDatasetException {
        String no_vert_levels = "no_vert_level";
        List<String> vars = params.getVar();
        HashMap<String, List<String>> varsGroupsByLevels = new HashMap<String, List<String>>();
        for (String var : vars) {
            GridDatatype grid = gds.findGridDatatype(var);
            if (grid == null) {
                throw new VariableNotContainedInDatasetException("Variable: " + var + " is not contained in the requested dataset");
            }
            CoordinateAxis1D axis = grid.getCoordinateSystem().getVerticalAxis();
            String axisKey = null;
            axisKey = axis == null ? no_vert_levels : axis.getShortName();
            if (varsGroupsByLevels.containsKey(axisKey)) {
                ((List)varsGroupsByLevels.get(axisKey)).add(var);
                continue;
            }
            ArrayList<String> varListForVerlLevel = new ArrayList<String>();
            varListForVerlLevel.add(var);
            varsGroupsByLevels.put(axisKey, varListForVerlLevel);
        }
        return varsGroupsByLevels;
    }

    protected List<CalendarDate> getRequestedDates(GridDataset gds, NcssParamsBean params) throws OutOfBoundariesException, ParseException, TimeOutOfWindowException {
        GridAsPointDataset gap = NcssRequestUtils.buildGridAsPointDataset((ucar.nc2.dt.GridDataset)gds, params.getVar());
        List dates = gap.getDates();
        if (dates.isEmpty()) {
            return dates;
        }
        long time_window = 0L;
        if (params.getTime_window() != null) {
            TimeDuration dTW = new TimeDuration(params.getTime_window());
            time_window = (long)dTW.getValueInSeconds() * 1000L;
        }
        if (params.isAllTimes()) {
            return dates;
        }
        if (params.getTime() == null && params.getTime_start() == null && params.getTime_end() == null && params.getTime_duration() == null) {
            ArrayList<CalendarDate> closestToPresent = new ArrayList<CalendarDate>();
            CalendarDate now = CalendarDate.of((Date)new Date());
            CalendarDate start = (CalendarDate)dates.get(0);
            CalendarDate end = (CalendarDate)dates.get(dates.size() - 1);
            if (now.isBefore(start)) {
                if (time_window <= 0L || Math.abs(now.getDifferenceInMsecs(start)) < time_window) {
                    closestToPresent.add(start);
                    return closestToPresent;
                }
                throw new TimeOutOfWindowException("There is no time within the provided time window");
            }
            if (now.isAfter(end)) {
                if (time_window <= 0L || Math.abs(now.getDifferenceInMsecs(end)) < time_window) {
                    closestToPresent.add(end);
                    return closestToPresent;
                }
                throw new TimeOutOfWindowException("There is no time within the provided time window");
            }
            return NcssRequestUtils.wantedDates(gap, CalendarDateRange.of((CalendarDate)now, (CalendarDate)now), time_window);
        }
        if (params.getTime_window() != null && params.getTime() != null) {
            DateRange dr = new DateRange(new DateType(params.getTime(), null, null), null, new TimeDuration(params.getTime_window()), null);
            time_window = CalendarDateRange.of((CalendarDate)dr.getStart().getCalendarDate(), (CalendarDate)dr.getEnd().getCalendarDate()).getDurationInSecs() * 1000L;
        }
        CalendarDateRange dateRange = GridDatasetResponder.getRequestedDateRange(params);
        return NcssRequestUtils.wantedDates(gap, dateRange, time_window);
    }
}

