/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.dsg;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import thredds.server.ncss.controller.NcssController;
import thredds.server.ncss.exception.FeaturesNotFoundException;
import thredds.server.ncss.exception.NcssException;
import thredds.server.ncss.format.SupportedFormat;
import thredds.server.ncss.params.NcssParamsBean;
import thredds.server.ncss.util.NcssRequestUtils;
import thredds.server.ncss.view.dsg.AbstractWriter;
import thredds.server.ncss.view.gridaspoint.NetCDFPointDataWriter;
import thredds.util.ContentType;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.ft.point.writer.WriterCFStationCollection;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;
import ucar.nc2.util.xml.Parse;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.util.Format;

public class StationWriter
extends AbstractWriter {
    private static Logger log = LoggerFactory.getLogger(StationWriter.class);
    private static final boolean debug = false;
    private static final boolean debugDetail = false;
    private final StationTimeSeriesFeatureCollection sfc;
    private Writer writer;

    public static StationWriter stationWriterFactory(FeatureDatasetPoint fd, StationTimeSeriesFeatureCollection sfc, NcssParamsBean qb, DiskCache2 diskCache, OutputStream out, SupportedFormat format) throws IOException, ParseException, NcssException {
        StationWriter sw = new StationWriter(fd, sfc, qb, diskCache);
        sw.writer = sw.getWriterForFormat(out, format);
        return sw;
    }

    private StationWriter(FeatureDatasetPoint fd, StationTimeSeriesFeatureCollection sfc, NcssParamsBean qb, DiskCache2 diskCache) throws IOException, NcssException {
        super(fd, qb, diskCache);
        this.sfc = sfc;
    }

    private Writer getWriterForFormat(OutputStream out, SupportedFormat format) throws IOException, ParseException, NcssException {
        Writer w;
        switch (format) {
            case XML_STREAM: 
            case XML_FILE: {
                w = new WriterXML(new PrintWriter(out), format.isStream());
                break;
            }
            case CSV_STREAM: 
            case CSV_FILE: {
                w = new WriterCSV(new PrintWriter(out), format.isStream());
                break;
            }
            case NETCDF3: {
                w = new WriterNetcdf(NetcdfFileWriter.Version.netcdf3, out);
                break;
            }
            case NETCDF4: {
                w = new WriterNetcdf(NetcdfFileWriter.Version.netcdf4, out);
                break;
            }
            default: {
                log.error("Unknown result type = " + format.getFormatName());
                return null;
            }
        }
        return w;
    }

    public HttpHeaders getHttpHeaders(FeatureDataset fd, SupportedFormat format, String datasetPath) {
        return this.writer.getHttpHeaders(datasetPath);
    }

    public void write() throws ParseException, IOException, NcssException {
        Limit counter = new Limit();
        PointFeatureCollection pfc = null;
        List<Station> stns = this.writer.getStationsInSubset();
        if (stns.isEmpty()) {
            throw new FeaturesNotFoundException("Features not found");
        }
        ArrayList<String> stations = new ArrayList<String>();
        for (Station st : stns) {
            stations.add(st.getName());
        }
        pfc = this.sfc.flatten(stations, this.wantRange, null);
        Action act = this.writer.getAction();
        this.writer.header();
        if (this.qb.getTime() != null) {
            this.scanForClosestTime(pfc, new DateType(this.qb.getTime(), null, null), null, act, counter);
        } else {
            this.scan(pfc, this.wantRange, null, act, counter);
        }
        this.writer.trailer();
    }

    private Station findClosestStation(LatLonPoint pt) throws IOException {
        double lat = pt.getLatitude();
        double lon = pt.getLongitude();
        double cos = Math.cos(Math.toRadians(lat));
        List stations = this.sfc.getStations();
        Station min_station = (Station)stations.get(0);
        double min_dist = Double.MAX_VALUE;
        for (Station s : stations) {
            double dx;
            double lat1 = s.getLatitude();
            double lon1 = LatLonPointImpl.lonNormal((double)s.getLongitude(), (double)lon);
            double dy = Math.toRadians(lat - lat1);
            double dist = dy * dy + (dx = cos * Math.toRadians(lon - lon1)) * dx;
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            min_station = s;
        }
        return min_station;
    }

    private void scan(PointFeatureCollection collection, CalendarDateRange range, Predicate p, Action a, Limit limit) throws IOException {
        collection.resetIteration();
        while (collection.hasNext()) {
            CalendarDate obsDate;
            PointFeature pf = collection.next();
            if (range != null && !range.includes(obsDate = pf.getObservationTimeAsCalendarDate())) continue;
            ++limit.count;
            StructureData sdata = pf.getData();
            if (p == null || p.match(sdata)) {
                a.act(pf, sdata);
                ++limit.matches;
            }
            if (limit.matches <= limit.limit) continue;
            collection.finish();
            break;
        }
        collection.finish();
    }

    private void scanForClosestTime(PointFeatureCollection collection, DateType time, Predicate p, Action a, Limit limit) throws IOException {
        HashMap<String, StationDataTracker> map = new HashMap<String, StationDataTracker>();
        long wantTime = time.getCalendarDate().getMillis();
        collection.resetIteration();
        while (collection.hasNext()) {
            StructureData sdata;
            PointFeature pf = collection.next();
            if (p != null && !p.match(sdata = pf.getData())) continue;
            long obsTime = pf.getObservationTimeAsCalendarDate().getMillis();
            long diff = Math.abs(obsTime - wantTime);
            Station s = ((StationPointFeature)pf).getStation();
            StationDataTracker track = (StationDataTracker)map.get(s.getName());
            if (track == null) {
                map.put(s.getName(), new StationDataTracker(pf, diff));
                continue;
            }
            if (diff >= track.timeDiff) continue;
            track.sobs = pf;
            track.timeDiff = diff;
        }
        for (String name : map.keySet()) {
            StationDataTracker track = (StationDataTracker)map.get(name);
            a.act(track.sobs, track.sobs.getData());
            ++limit.matches;
            ++limit.count;
            if (limit.count <= limit.limit) continue;
            break;
        }
    }

    class WriterCSV
    extends Writer {
        private boolean isStream;

        WriterCSV(PrintWriter writer, boolean isStream) {
            super(writer);
            this.isStream = isStream;
        }

        @Override
        void header() {
            this.writer.print("time,station,latitude[unit=\"degrees_north\"],longitude[unit=\"degrees_east\"]");
            for (VariableSimpleIF var : StationWriter.this.wantVars) {
                this.writer.print(",");
                this.writer.print(var.getShortName());
                if (var.getUnitsString() == null) continue;
                this.writer.print("[unit=\"" + var.getUnitsString() + "\"]");
            }
            this.writer.println();
        }

        @Override
        void trailer() {
            this.writer.flush();
        }

        @Override
        HttpHeaders getHttpHeaders(String pathInfo) {
            HttpHeaders httpHeaders = new HttpHeaders();
            if (!this.isStream) {
                httpHeaders.set("Content-Location", pathInfo);
                httpHeaders.set("Content-Disposition", "attachment; filename=\"" + NcssRequestUtils.nameFromPathInfo(pathInfo) + ".csv\"");
                httpHeaders.add("Content-Type", ContentType.csv.getContentHeader());
            } else {
                httpHeaders.add("Content-Type", ContentType.text.getContentHeader());
            }
            return httpHeaders;
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    Station s = StationWriter.this.sfc.getStation(pf);
                    WriterCSV.this.writer.print(CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(s.getName());
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(Format.dfrac((double)s.getLatitude(), (int)3));
                    WriterCSV.this.writer.print(',');
                    WriterCSV.this.writer.print(Format.dfrac((double)s.getLongitude(), (int)3));
                    for (VariableSimpleIF var : StationWriter.this.wantVars) {
                        WriterCSV.this.writer.print(',');
                        Array sdataArray = sdata.getArray(var.getShortName());
                        WriterCSV.this.writer.print(sdataArray.toString());
                    }
                    WriterCSV.this.writer.println();
                    ++WriterCSV.this.count;
                }
            };
        }
    }

    class WriterXML
    extends Writer {
        private XMLStreamWriter staxWriter;
        private boolean isStream;

        WriterXML(PrintWriter writer, boolean isStream) {
            super(writer);
            this.isStream = isStream;
            XMLOutputFactory f = XMLOutputFactory.newInstance();
            try {
                this.staxWriter = f.createXMLStreamWriter(writer);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        void header() {
            try {
                this.staxWriter.writeStartDocument("UTF-8", "1.0");
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeStartElement("stationFeatureCollection");
                this.staxWriter.writeCharacters("\n ");
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        void trailer() {
            try {
                this.staxWriter.writeEndElement();
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeEndDocument();
                this.staxWriter.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e.getMessage());
            }
            this.writer.flush();
        }

        @Override
        HttpHeaders getHttpHeaders(String pathInfo) {
            HttpHeaders httpHeaders = new HttpHeaders();
            if (!this.isStream) {
                httpHeaders.set("Content-Location", pathInfo);
                httpHeaders.set("Content-Disposition", "attachment; filename=\"" + NcssRequestUtils.nameFromPathInfo(pathInfo) + ".xml\"");
            }
            httpHeaders.set("Content-Type", ContentType.xml.getContentHeader());
            return httpHeaders;
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    Station s = StationWriter.this.sfc.getStation(pf);
                    try {
                        WriterXML.this.staxWriter.writeStartElement("pointFeature");
                        WriterXML.this.staxWriter.writeAttribute("date", CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                        WriterXML.this.staxWriter.writeCharacters("\n  ");
                        WriterXML.this.staxWriter.writeStartElement("station");
                        WriterXML.this.staxWriter.writeAttribute("name", s.getName());
                        WriterXML.this.staxWriter.writeAttribute("latitude", Format.dfrac((double)s.getLatitude(), (int)3));
                        WriterXML.this.staxWriter.writeAttribute("longitude", Format.dfrac((double)s.getLongitude(), (int)3));
                        if (!Double.isNaN(s.getAltitude())) {
                            WriterXML.this.staxWriter.writeAttribute("altitude", Format.dfrac((double)s.getAltitude(), (int)0));
                        }
                        if (s.getDescription() != null) {
                            WriterXML.this.staxWriter.writeCharacters(s.getDescription());
                        }
                        WriterXML.this.staxWriter.writeEndElement();
                        WriterXML.this.staxWriter.writeCharacters("\n ");
                        for (VariableSimpleIF var : StationWriter.this.wantVars) {
                            WriterXML.this.staxWriter.writeCharacters(" ");
                            WriterXML.this.staxWriter.writeStartElement("data");
                            WriterXML.this.staxWriter.writeAttribute("name", var.getShortName());
                            if (var.getUnitsString() != null) {
                                WriterXML.this.staxWriter.writeAttribute("units", var.getUnitsString());
                            }
                            Array sdataArray = sdata.getArray(var.getShortName());
                            String ss = sdataArray.toString();
                            Class elemType = sdataArray.getElementType();
                            if (elemType == String.class || elemType == Character.TYPE || elemType == StructureData.class) {
                                ss = Parse.cleanCharacterData((String)ss);
                            }
                            WriterXML.this.staxWriter.writeCharacters(ss);
                            WriterXML.this.staxWriter.writeEndElement();
                            WriterXML.this.staxWriter.writeCharacters("\n ");
                        }
                        WriterXML.this.staxWriter.writeEndElement();
                        WriterXML.this.staxWriter.writeCharacters("\n");
                        ++WriterXML.this.count;
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                }
            };
        }
    }

    class WriterRaw
    extends Writer {
        WriterRaw(PrintWriter writer) {
            super(writer);
        }

        @Override
        void header() {
        }

        @Override
        void trailer() {
            this.writer.flush();
        }

        @Override
        public HttpHeaders getHttpHeaders(String pathInfo) {
            return new HttpHeaders();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    WriterRaw.this.writer.print(CalendarDateFormatter.toDateTimeString((CalendarDate)pf.getObservationTimeAsCalendarDate()));
                    WriterRaw.this.writer.print("= ");
                    String report = sdata.getScalarString("report");
                    WriterRaw.this.writer.println(report);
                    ++WriterRaw.this.count;
                }
            };
        }
    }

    class WriterNcstream
    extends Writer {
        OutputStream out;

        WriterNcstream(OutputStream os) throws IOException {
            super(null);
            this.out = os;
        }

        @Override
        void header() throws IOException {
        }

        @Override
        void trailer() throws IOException {
            PointStream.writeMagic((OutputStream)this.out, (PointStream.MessageType)PointStream.MessageType.End);
            this.out.flush();
        }

        @Override
        HttpHeaders getHttpHeaders(String pathInfo) {
            return new HttpHeaders();
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    try {
                        byte[] b;
                        if (WriterNcstream.this.count == 0) {
                            PointStreamProto.PointFeatureCollection proto = PointStream.encodePointFeatureCollection((String)StationWriter.this.fd.getLocation(), (PointFeature)pf);
                            b = proto.toByteArray();
                            PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.PointFeatureCollection);
                            NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                            WriterNcstream.this.out.write(b);
                        }
                        PointStreamProto.PointFeature pfp = PointStream.encodePointFeature((PointFeature)pf);
                        b = pfp.toByteArray();
                        PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.PointFeature);
                        NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                        WriterNcstream.this.out.write(b);
                        ++WriterNcstream.this.count;
                    }
                    catch (Throwable t) {
                        String mess = t.getMessage();
                        if (mess == null) {
                            mess = t.getClass().getName();
                        }
                        NcStreamProto.Error err = NcStream.encodeErrorMessage((String)t.getMessage());
                        byte[] b = err.toByteArray();
                        PointStream.writeMagic((OutputStream)WriterNcstream.this.out, (PointStream.MessageType)PointStream.MessageType.Error);
                        NcStream.writeVInt((OutputStream)WriterNcstream.this.out, (int)b.length);
                        WriterNcstream.this.out.write(b);
                        throw new IOException(t);
                    }
                }
            };
        }
    }

    private class WriterNetcdf
    extends Writer {
        File netcdfResult;
        WriterCFStationCollection cfWriter;
        boolean headerWritten;
        private NetcdfFileWriter.Version version;
        private OutputStream out;

        WriterNetcdf(NetcdfFileWriter.Version version, OutputStream out) throws IOException {
            this(version);
            this.out = out;
        }

        WriterNetcdf(NetcdfFileWriter.Version version) throws IOException {
            super(null);
            this.headerWritten = false;
            this.version = version;
            this.netcdfResult = StationWriter.this.diskCache.createUniqueFile("cdmSW", ".nc");
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("title", "Extracted data from TDS using CDM remote subsetting"));
            this.cfWriter = new WriterCFStationCollection(version, this.netcdfResult.getAbsolutePath(), atts);
        }

        @Override
        void header() {
        }

        @Override
        void trailer() throws IOException {
            if (!this.headerWritten) {
                throw new IllegalStateException("no data was written");
            }
            this.cfWriter.finish();
            try {
                IO.copyFileB((File)this.netcdfResult, (OutputStream)this.out, (int)60000);
            }
            catch (IOException ioe) {
                log.error("Error copying result to the output stream", (Throwable)ioe);
            }
        }

        @Override
        HttpHeaders getHttpHeaders(String pathInfo) {
            HttpHeaders httpHeaders = new HttpHeaders();
            String fileName = NetCDFPointDataWriter.getFileNameForResponse(this.version, pathInfo);
            String url = NcssRequestUtils.getTdsContext().getContextPath() + NcssController.getServletCachePath() + "/" + fileName;
            if (this.version == NetcdfFileWriter.Version.netcdf3) {
                httpHeaders.set("Content-Type", ContentType.netcdf.getContentHeader());
            }
            if (this.version == NetcdfFileWriter.Version.netcdf4) {
                httpHeaders.set("Content-Type", ContentType.netcdf4.getContentHeader());
            }
            httpHeaders.set("Content-Location", url);
            httpHeaders.set("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            return httpHeaders;
        }

        @Override
        Action getAction() {
            return new Action(){

                @Override
                public void act(PointFeature pf, StructureData sdata) throws IOException {
                    if (!WriterNetcdf.this.headerWritten) {
                        try {
                            WriterNetcdf.this.cfWriter.writeHeader(WriterNetcdf.this.wantStations, StationWriter.this.wantVars, pf.getTimeUnit(), null);
                            WriterNetcdf.this.headerWritten = true;
                        }
                        catch (IOException e) {
                            log.error("WriterNetcdf.header", (Throwable)e);
                        }
                    }
                    if (WriterNetcdf.this.version == NetcdfFileWriter.Version.netcdf3) {
                        WriterNetcdf.this.cfWriter.writeRecord(StationWriter.this.sfc.getStation(pf), pf, sdata);
                    }
                    if (WriterNetcdf.this.version == NetcdfFileWriter.Version.netcdf4) {
                        WriterNetcdf.this.cfWriter.writeStructure(StationWriter.this.sfc.getStation(pf), pf, sdata);
                    }
                    ++WriterNetcdf.this.count;
                }
            };
        }
    }

    private abstract class Writer {
        protected List<Station> wantStations = new ArrayList<Station>();
        PrintWriter writer;
        int count = 0;

        abstract void header() throws IOException;

        abstract Action getAction();

        abstract void trailer() throws IOException;

        abstract HttpHeaders getHttpHeaders(String var1);

        Writer(PrintWriter writer) {
            this.writer = writer;
        }

        protected List<Station> getStationsInSubset() throws IOException {
            if (StationWriter.this.qb.hasStations()) {
                List<String> stnNames = StationWriter.this.qb.getStns();
                this.wantStations = stnNames.get(0).equals("all") ? StationWriter.this.sfc.getStations() : StationWriter.this.sfc.getStations(stnNames);
            } else if (StationWriter.this.qb.hasLatLonBB()) {
                if (StationWriter.this.qb.getSouth() == null || StationWriter.this.qb.getNorth() == null || StationWriter.this.qb.getEast() == null || StationWriter.this.qb.getWest() == null) {
                    this.wantStations = StationWriter.this.sfc.getStations();
                } else {
                    LatLonRect llrect = StationWriter.this.qb.getBB();
                    this.wantStations = StationWriter.this.sfc.getStations(llrect);
                }
            } else if (StationWriter.this.qb.hasLatLonPoint()) {
                Station closestStation = StationWriter.this.findClosestStation((LatLonPoint)new LatLonPointImpl(StationWriter.this.qb.getLatitude().doubleValue(), StationWriter.this.qb.getLongitude().doubleValue()));
                ArrayList<String> stnList = new ArrayList<String>();
                stnList.add(closestStation.getName());
                this.wantStations = StationWriter.this.sfc.getStations(stnList);
            } else {
                this.wantStations = StationWriter.this.sfc.getStations();
            }
            return this.wantStations;
        }
    }

    private class Limit {
        int count;
        int limit = Integer.MAX_VALUE;
        int matches;

        private Limit() {
        }
    }

    private static interface Action {
        public void act(PointFeature var1, StructureData var2) throws IOException;
    }

    private static interface Predicate {
        public boolean match(StructureData var1);
    }

    private class StationDataTracker {
        PointFeature sobs;
        long timeDiff = Long.MAX_VALUE;

        StationDataTracker(PointFeature sobs, long timeDiff) {
            this.sobs = sobs;
            this.timeDiff = timeDiff;
        }
    }
}

