/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncss.view.gridaspoint.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.ncss.dataservice.StructureDataFactory;
import thredds.server.ncss.util.NcssRequestUtils;
import thredds.server.ncss.view.gridaspoint.netcdf.CFPointWriterWrapper;
import thredds.server.ncss.view.gridaspoint.netcdf.WriterCFStationCollection;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.ft.point.writer.CFPointWriterUtils;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

public final class CFStationCollectionWriterWrapper
implements CFPointWriterWrapper {
    private static Logger log = LoggerFactory.getLogger(CFStationCollectionWriterWrapper.class);
    private WriterCFStationCollection writerCFStationCollection;
    private GridAsPointDataset gap;
    private CalendarDate timeOrigin;

    public static CFStationCollectionWriterWrapper factory(NetcdfFileWriter.Version version, String filePath, List<Attribute> atts) throws IOException {
        return new CFStationCollectionWriterWrapper(version, filePath, atts);
    }

    private CFStationCollectionWriterWrapper() {
    }

    private CFStationCollectionWriterWrapper(NetcdfFileWriter.Version version, String filePath, List<Attribute> atts) throws IOException {
        this.writerCFStationCollection = new WriterCFStationCollection(version, filePath, atts);
    }

    @Override
    public boolean header(Map<String, List<String>> groupedVars, GridDataset gridDataset, List<CalendarDate> wDates, List<Attribute> timeDimAtts, LatLonPoint point, Double vertCoord) {
        boolean headerDone = false;
        Attribute unitsAtt = CFPointWriterUtils.findCDMAtt(timeDimAtts, (String)"units");
        try {
            DateUnit dateUnit = new DateUnit(unitsAtt.getStringValue());
            this.timeOrigin = dateUnit.makeCalendarDate(0.0);
        }
        catch (Exception e) {
            log.error("Error creating time units for: " + unitsAtt.getStringValue());
            return headerDone;
        }
        String stnName = "GridPoint";
        String desc = "Grid Point at lat/lon=" + point.getLatitude() + "," + point.getLongitude();
        StationImpl s = new StationImpl(stnName, desc, "", point.getLatitude(), point.getLongitude(), Double.NaN);
        ArrayList<Station> stnList = new ArrayList<Station>();
        stnList.add((Station)s);
        NetcdfDataset ncfile = (NetcdfDataset)gridDataset.getNetcdfFile();
        List<String> vars = new ArrayList<List<String>>(groupedVars.values()).get(0);
        this.gap = NcssRequestUtils.buildGridAsPointDataset(gridDataset, vars);
        List<VariableSimpleIF> wantedVars = NcssRequestUtils.wantedVars2VariableSimple(vars, gridDataset, ncfile);
        try {
            this.writerCFStationCollection.writeHeader(stnList, wantedVars, gridDataset, timeDimAtts, "");
            headerDone = true;
        }
        catch (IOException ioe) {
            log.error("Error writing header", (Throwable)ioe);
        }
        return headerDone;
    }

    @Override
    public boolean write(Map<String, List<String>> groupedVars, GridDataset gridDataset, CalendarDate date, LatLonPoint point, Double targetLevel) {
        boolean allDone = false;
        List<String> vars = new ArrayList<List<String>>(groupedVars.values()).get(0);
        StructureData sdata = StructureDataFactory.getFactory().createSingleStructureData(gridDataset, point, vars, true);
        GridDatatype timeGrid = NcssRequestUtils.getTimeGrid(groupedVars, gridDataset);
        if (timeGrid == null) {
            throw new IllegalArgumentException("Variables do not have time dimension");
        }
        Double timeCoordValue = NcssRequestUtils.getTimeCoordValue(timeGrid, date, this.timeOrigin);
        sdata.findMember("time").getDataArray().setDouble(0, timeCoordValue.doubleValue());
        CoordinateAxis1D ensAxis = gridDataset.findGridDatatype(vars.get(0)).getCoordinateSystem().getEnsembleAxis();
        double[] ensCoords = new double[]{-1.0};
        if (ensAxis != null) {
            ensCoords = ensAxis.getCoordValues();
        }
        try {
            int ensIdx = 0;
            for (double ensCoord : ensCoords) {
                if (ensCoord >= 0.0) {
                    this.writerCFStationCollection.writeEnsCoord(ensIdx, ensCoord);
                    ++ensIdx;
                }
                for (String varName : vars) {
                    GridDatatype grid = gridDataset.findGridDatatype(varName);
                    if (this.gap.hasTime(grid, date)) {
                        GridAsPointDataset.Point p = this.gap.readData(grid, date, ensCoord, -1.0, point.getLatitude(), point.getLongitude());
                        sdata.findMember(varName).getDataArray().setDouble(0, p.dataValue);
                        continue;
                    }
                    sdata.findMember(varName).getDataArray().setDouble(0, this.gap.getMissingValue(grid));
                }
                if (ensCoord < 0.0) {
                    this.writerCFStationCollection.writeRecord((String)sdata.findMember("station").getDataArray().getObject(0), timeCoordValue, date, sdata);
                } else {
                    this.writerCFStationCollection.writeRecord((String)sdata.findMember("station").getDataArray().getObject(0), timeCoordValue, date, ensCoord, sdata);
                }
                allDone = true;
            }
        }
        catch (IOException ioe) {
            log.error("Error writing data", (Throwable)ioe);
        }
        return allDone;
    }

    @Override
    public boolean trailer() {
        boolean finished = false;
        try {
            this.writerCFStationCollection.finish();
            finished = true;
        }
        catch (IOException ioe) {
            log.error("Error finishing  WriterCFStationCollection" + ioe);
        }
        return finished;
    }
}

