/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import opendap.servers.SDFloat64;
import thredds.server.opendap.HasNetcdfVariable;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;

public class NcSDFloat64
extends SDFloat64
implements HasNetcdfVariable {
    private Variable ncVar;

    NcSDFloat64(Variable v) {
        super(Variable.getDAPName((Variable)v));
        this.ncVar = v;
    }

    @Override
    public Variable getVariable() {
        return this.ncVar;
    }

    public boolean read(String datasetName, Object specialO) throws IOException {
        this.setData(this.ncVar.read());
        return false;
    }

    @Override
    public void setData(Array data) {
        this.setValue(data.getDouble(data.getIndex()));
        this.setRead(true);
    }

    @Override
    public void serialize(DataOutputStream sink, StructureData sdata, StructureMembers.Member m) throws IOException {
        this.setValue(sdata.getScalarDouble(m));
        this.externalize(sink);
    }
}

