/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.query.Station;
import thredds.server.AbstractController;
import thredds.server.config.TdsContext;
import thredds.server.ncss.QueryParams;
import thredds.server.radarServer.RadarDatasetCollection;
import thredds.server.radarServer.RadarDatasetRepository;
import thredds.server.radarServer.RadarServerUtil;
import thredds.server.radarServer.RadarStationCollection;
import thredds.servlet.HtmlWriter;
import thredds.util.TdsPathUtils;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.Format;

@Controller
@RequestMapping(value={"/radarServer"})
@DependsOn(value={"DataRootHandler"})
public class RadarController
extends AbstractController {
    private static Logger log = LoggerFactory.getLogger(RadarController.class);
    private static final String CREATE_VIEW = "forward:badquery.htm";
    private static final String MODEL_KEY = "message";
    private static final String MSG_CODE = "message.bad.query";
    private static final String CREATE_STATION_VIEW = "forward:createstation.htm";
    private static final String STATION_MSG_CODE = "message.create.station";
    private static final String CREATE_CATALOG_VIEW = "forward:createdataset.htm";
    private static final String CATALOG_MSG_CODE = "message.create.dataset";
    private static DateType epicDateType;
    private static SimpleDateFormat dateFormat;
    @Autowired
    private RadarDatasetRepository radarDatasetRepository;
    @Autowired
    private TdsContext tdsContext;
    private boolean releaseDataset = false;
    private boolean enabled = false;

    @Override
    protected String getControllerPath() {
        return "/radarServer/";
    }

    @Override
    protected String[] getEndings() {
        return new String[]{"/stations.xml", "/catalog.xml", "/catalog.html"};
    }

    @PostConstruct
    void init() {
        this.enabled = this.radarDatasetRepository.init(this.tdsContext);
    }

    @RequestMapping(value={"**/stations.xml"}, method={RequestMethod.GET})
    protected ModelAndView handleStationXmlRequest(HttpServletRequest request, HttpServletResponse res) throws IOException {
        RadarDatasetRepository.RadarType radarType;
        int pos;
        if (!this.enabled) {
            res.sendError(404, "Radar server not enabled");
            return null;
        }
        String path = TdsPathUtils.extractPath(request, this.getControllerPath());
        if (path == null) {
            path = "";
        }
        String type = (pos = path.indexOf("/")) > 0 ? path.substring(0, pos) : "";
        try {
            radarType = RadarDatasetRepository.RadarType.valueOf(type);
        }
        catch (Exception e) {
            res.sendError(400, "Bad radar type=" + type);
            return null;
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.stationsXML(radarType, path, model);
        if (model.size() == 0) {
            ModelAndView mav = new ModelAndView(CREATE_STATION_VIEW);
            mav.addObject(MODEL_KEY, (Object)STATION_MSG_CODE);
            return mav;
        }
        return new ModelAndView("stationXml", model);
    }

    private void stationsXML(RadarDatasetRepository.RadarType radarType, String path, Map<String, Object> model) {
        String[] stations = this.stationsDS(radarType, this.radarDatasetRepository.dataRoots.get(path));
        if (path.contains("level3") && stations[0].length() == 4) {
            for (int i = 0; i < stations.length; ++i) {
                stations[i] = stations[i].substring(1);
            }
        }
        this.makeStationDocument(stations, radarType, model);
    }

    private String[] stationsDS(RadarDatasetRepository.RadarType radarType, String path) {
        Object stations = null;
        if (path != null) {
            File dir = new File(path);
            stations = dir.list();
            if (path.contains("level3")) {
                dir = null;
                if (radarType.equals((Object)RadarDatasetRepository.RadarType.nexrad)) {
                    for (String var : stations) {
                        if (!var.equals("N0R")) continue;
                        dir = new File(path + "/N0R");
                        break;
                    }
                } else if (radarType.equals((Object)RadarDatasetRepository.RadarType.terminal)) {
                    for (String var : stations) {
                        if (!var.equals("TR0")) continue;
                        dir = new File(path + "/TR0");
                        break;
                    }
                }
                stations = dir != null ? dir.list() : null;
            }
        }
        if (stations != null) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (String station : stations) {
                if (station.startsWith(".")) continue;
                tmp.add(station);
            }
            if (((String[])stations).length != tmp.size()) {
                stations = new String[tmp.size()];
                stations = tmp.toArray((T[])stations);
            }
        }
        if (stations == null || (stations).length == 0) {
            if (stations == null) {
                stations = new String[1];
            }
            stations = radarType.equals((Object)RadarDatasetRepository.RadarType.nexrad) ? this.radarDatasetRepository.nexradMap.keySet().toArray((T[])stations) : this.radarDatasetRepository.terminalMap.keySet().toArray((T[])stations);
        }
        return stations;
    }

    private void makeStationDocument(String[] stations, RadarDatasetRepository.RadarType radarType, Map<String, Object> model) {
        ArrayList<StationEntry> entries = new ArrayList<StationEntry>();
        for (String s : stations) {
            Station stn = this.getStation(s, radarType);
            StationEntry se = new StationEntry();
            if (stn == null) {
                se.setId(s);
                se.setState("XXX");
                se.setCountry("XX");
                se.setName("Unknown");
                se.setLongitude("0.0");
                se.setLatitude("0.0");
                se.setElevation("0.0");
                continue;
            }
            se.setId(s);
            if (stn.getState() != null) {
                se.setState(stn.getState());
            }
            if (stn.getCountry() != null) {
                se.setCountry(stn.getCountry());
            }
            if (stn.getName() != null) {
                se.setName(stn.getName());
            }
            se.setLongitude(Format.d((double)stn.getLocation().getLongitude(), (int)6));
            se.setLatitude(Format.d((double)stn.getLocation().getLatitude(), (int)6));
            if (!Double.isNaN(stn.getLocation().getElevation())) {
                se.setElevation(Format.d((double)stn.getLocation().getElevation(), (int)6));
            }
            entries.add(se);
        }
        model.put("stations", entries);
    }

    public Station getStation(String station, RadarDatasetRepository.RadarType radarType) {
        Station stn = null;
        if (station.length() == 3 && radarType.equals((Object)RadarDatasetRepository.RadarType.terminal)) {
            stn = this.radarDatasetRepository.terminalMap.get("T" + station);
        } else if (station.length() == 3) {
            for (Station stn3 : this.radarDatasetRepository.nexradList) {
                if (!stn3.getValue().endsWith(station)) continue;
                stn = stn3;
                break;
            }
        } else {
            stn = radarType.equals((Object)RadarDatasetRepository.RadarType.terminal) ? this.radarDatasetRepository.terminalMap.get(station) : this.radarDatasetRepository.nexradMap.get(station);
        }
        return stn;
    }

    @RequestMapping(value={"**/*.xml", "**/*.html", "*.xml", "*.html"}, method={RequestMethod.GET})
    protected ModelAndView handleCatalogRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.enabled) {
            response.sendError(403, "Service not supported");
            return null;
        }
        String path = TdsPathUtils.extractPath(request, this.getControllerPath());
        if (path == null) {
            path = "";
        }
        if (path.equals("catalog.xml") || path.equals("dataset.xml")) {
            InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
            String catAsString = factory.writeXML(this.radarDatasetRepository.defaultCat);
            PrintWriter pw = response.getWriter();
            pw.println(catAsString);
            pw.flush();
            return null;
        }
        if (path.equals("catalog.html") || path.equals("dataset.html")) {
            try {
                HtmlWriter.getInstance().writeCatalog(request, response, this.radarDatasetRepository.defaultCat, true);
            }
            catch (Exception e) {
                log.error("Radar HtmlWriter failed ", (Throwable)e);
                response.sendError(500, "radarServer HtmlWriter error " + path);
            }
            return null;
        }
        InvCatalogImpl catalog = null;
        if (path.contains("level2/catalog.") || path.contains("level3/catalog.") || path.contains("level2/dataset.") || path.contains("level3/dataset.")) {
            catalog = this.level2level3catalog(this.radarDatasetRepository.defaultCat, path);
            if (catalog == null) {
                response.sendError(400, this.getAbsolutePath(request));
                return null;
            }
        } else if (path.endsWith("dataset.xml") || path.endsWith("catalog.xml")) {
            Map<String, Object> model = this.datasetInfoXml(this.radarDatasetRepository.defaultCat, path);
            if (model == null) {
                response.sendError(400, this.getAbsolutePath(request));
                return null;
            }
            return new ModelAndView("datasetXml", model);
        }
        if (catalog == null) {
            ModelAndView mav = new ModelAndView(CREATE_CATALOG_VIEW);
            mav.addObject(MODEL_KEY, (Object)CATALOG_MSG_CODE);
            return mav;
        }
        if (path.endsWith(".html")) {
            HtmlWriter.getInstance().writeCatalog(request, response, catalog, true);
            return null;
        }
        return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)catalog);
    }

    private InvCatalogImpl level2level3catalog(InvCatalogImpl catalog, String pathInfo) throws IOException {
        String dsPath;
        InvCatalogImpl tCat = null;
        if (pathInfo.indexOf("/dataset") > 0) {
            dsPath = pathInfo.substring(0, pathInfo.indexOf("/dataset"));
        } else if (pathInfo.indexOf("/catalog") > 0) {
            dsPath = pathInfo.substring(0, pathInfo.indexOf("/catalog"));
        } else {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)false);
        factory.writeXML(catalog, (OutputStream)os, true);
        tCat = factory.readXML((InputStream)new ByteArrayInputStream(os.toByteArray()), null);
        Iterator parents = tCat.getDatasets().iterator();
        while (parents.hasNext()) {
            ArrayList<InvDatasetImpl> delete = new ArrayList<InvDatasetImpl>();
            InvDatasetImpl top = (InvDatasetImpl)parents.next();
            for (InvDatasetImpl ds : top.getDatasets()) {
                InvDatasetScan ids;
                if (!(ds instanceof InvDatasetScan) || (ids = (InvDatasetScan)ds).getPath() == null) continue;
                if (ids.getPath().contains(dsPath)) {
                    ids.setXlinkHref(ids.getPath() + "/dataset.xml");
                    continue;
                }
                delete.add(ds);
            }
            for (InvDatasetImpl idi : delete) {
                top.removeDataset(idi);
            }
        }
        return tCat;
    }

    private Map<String, Object> datasetInfoXml(InvCatalogImpl cat, String pathInfo) throws IOException {
        String dsPath;
        HashMap<String, Object> model = new HashMap<String, Object>();
        InvDatasetScan ds = null;
        boolean found = false;
        if (pathInfo.indexOf("/dataset") > 0) {
            dsPath = pathInfo.substring(0, pathInfo.indexOf("/dataset"));
        } else if (pathInfo.indexOf("/catalog") > 0) {
            dsPath = pathInfo.substring(0, pathInfo.indexOf("/catalog"));
        } else {
            return null;
        }
        Iterator parents = cat.getDatasets().iterator();
        InvDatasetImpl top = (InvDatasetImpl)parents.next();
        for (Object o : top.getDatasets()) {
            InvDatasetImpl idsi = (InvDatasetImpl)o;
            if (!(idsi instanceof InvDatasetScan) || (ds = (InvDatasetScan)idsi).getPath() == null || !ds.getPath().contains(dsPath)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        model.put("ID", ds.getID());
        model.put("urlPath", ds.getPath());
        model.put("dataFormat", ds.getDataFormatType());
        model.put("documentation", ds.getSummary());
        CalendarDateRange dr = ds.getCalendarDateCoverage();
        model.put("tstart", dr.getStart().toString());
        model.put("tend", dr.getEnd().toString());
        ThreddsMetadata.GeospatialCoverage gc = ds.getGeospatialCoverage();
        LatLonRect bb = new LatLonRect();
        gc.setBoundingBox(bb);
        model.put("north", gc.getLatNorth());
        model.put("south", gc.getLatSouth());
        model.put("east", gc.getLonEast());
        model.put("west", gc.getLonWest());
        List vars = ds.getVariables();
        if (vars.size() > 0) {
            ThreddsMetadata.Variables cvs = (ThreddsMetadata.Variables)ds.getVariables().get(0);
            ArrayList<RsVar> variables = new ArrayList<RsVar>();
            for (ThreddsMetadata.Variable v : cvs.getVariableList()) {
                RsVar rsv = new RsVar();
                rsv.setName(v.getName());
                rsv.setVname(v.getVocabularyName());
                rsv.setUnits(v.getUnits());
                variables.add(rsv);
            }
            model.put("variables", variables);
        }
        return model;
    }

    @RequestMapping(value={"/nexrad/level2/{dataset}", "/nexrad/level3/{dataset}", "/terminal/level3/{dataset}"}, method={RequestMethod.GET})
    protected ModelAndView handleQuery(@RequestParam Map<String, String> allRequestParams, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.enabled) {
            response.sendError(404, "No radar server");
            return null;
        }
        if (request.getQueryString() == null) {
            response.sendError(400, "No query string");
            return null;
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.radarQuery(request, response, model);
        if (model.size() == 0) {
            ModelAndView mav = new ModelAndView(CREATE_VIEW);
            mav.addObject(MODEL_KEY, (Object)MSG_CODE);
            return mav;
        }
        return new ModelAndView("queryXml", model);
    }

    private void radarQuery(HttpServletRequest req, HttpServletResponse res, Map<String, Object> model) throws IOException {
        RadarDatasetRepository.RadarType radarType = RadarDatasetRepository.RadarType.nexrad;
        String pathInfo = TdsPathUtils.extractPath(req, this.getControllerPath());
        if (pathInfo == null) {
            pathInfo = "";
        }
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        String rt = pathInfo.substring(0, pathInfo.indexOf(47, 1));
        try {
            radarType = RadarDatasetRepository.RadarType.valueOf(rt);
        }
        catch (Exception e) {
            res.sendError(400, "bad radarType=" + rt);
            return;
        }
        Boolean level2 = pathInfo.contains("level2");
        QueryParams qp = new QueryParams();
        if (!qp.parseQuery(req, res, new String[]{"application/xml", "text/html", "text/plain", "application/x-netcdf"})) {
            return;
        }
        if (!this.checkQueryParms(radarType, qp, level2).booleanValue()) {
            res.sendError(400, "bad query=" + qp.errs.toString());
            return;
        }
        qp.acceptType = qp.acceptType.replaceFirst(".*/", "");
        if (!this.createHeader(radarType, qp, pathInfo, model).booleanValue()) {
            res.sendError(400, "bad query=" + qp.errs.toString());
            return;
        }
        boolean dataFound = false;
        ArrayList<DatasetEntry> entries = new ArrayList<DatasetEntry>();
        if (qp.vars == null) {
            dataFound = this.processQuery(pathInfo, qp, null, entries);
            if (this.releaseDataset) {
                this.radarDatasetRepository.removeRadarDatasetCollection(pathInfo, null);
            }
        } else {
            int count = 0;
            for (String var : qp.vars) {
                dataFound = this.processQuery(pathInfo, qp, var, entries);
                if (dataFound) {
                    ++count;
                }
                if (!this.releaseDataset) continue;
                this.radarDatasetRepository.removeRadarDatasetCollection(pathInfo, var);
            }
            if (count > 0) {
                dataFound = true;
            }
        }
        model.put("datasets", entries);
        if (dataFound) {
            model.put("documentation", Integer.toString(entries.size()) + " datasets found for query");
        } else if (qp.errs.length() > 0) {
            model.put("documentation", qp.errs.toString());
        } else {
            model.put("documentation", "No data available for station(s) and time range");
        }
    }

    private Boolean checkQueryParms(RadarDatasetRepository.RadarType radarType, QueryParams qp, Boolean level2) {
        if (qp.hasBB) {
            qp.stns = radarType.equals((Object)RadarDatasetRepository.RadarType.nexrad) ? RadarServerUtil.getStationNames(qp.getBB(), this.radarDatasetRepository.nexradList) : RadarServerUtil.getStationNames(qp.getBB(), this.radarDatasetRepository.terminalList);
            if (qp.stns.size() == 0) {
                qp.errs.append("Bounding Box contains no stations ");
                return false;
            }
            if (!level2.booleanValue()) {
                qp.stns = RadarServerUtil.convert4to3stations(qp.stns);
            }
        }
        if (qp.hasStns) {
            if (this.radarDatasetRepository.isStationListEmpty(qp.stns, radarType)) {
                qp.errs.append("No valid stations specified, need 1 ");
                return false;
            }
            if (level2.booleanValue()) {
                for (String stn : qp.stns) {
                    if (stn.length() != 3) continue;
                    qp.errs.append("Need 4 character station names ");
                    return false;
                }
            } else if (!level2.booleanValue()) {
                qp.stns = RadarServerUtil.convert4to3stations(qp.stns);
            }
        }
        if (qp.hasLatlonPoint) {
            qp.stns = new ArrayList<String>();
            if (radarType.equals((Object)RadarDatasetRepository.RadarType.nexrad)) {
                qp.stns.add(RadarServerUtil.findClosestStation(qp.lat, qp.lon, this.radarDatasetRepository.nexradList));
            } else {
                qp.stns.add(RadarServerUtil.findClosestStation(qp.lat, qp.lon, this.radarDatasetRepository.terminalList));
            }
            if (!level2.booleanValue()) {
                qp.stns = RadarServerUtil.convert4to3stations(qp.stns);
            }
        } else if (qp.fatal) {
            qp.errs.append("No valid stations specified 2 ");
            return false;
        }
        if (qp.stns == null || qp.stns.size() == 0) {
            qp.errs.append("No valid stations specified, need 1 ");
            return false;
        }
        boolean useAllStations = qp.stns.get(0).toUpperCase().equals("ALL");
        if (useAllStations) {
            qp.stns = radarType.equals((Object)RadarDatasetRepository.RadarType.nexrad) ? RadarServerUtil.getStationNames(this.radarDatasetRepository.nexradList) : RadarServerUtil.getStationNames(this.radarDatasetRepository.terminalList);
            if (!level2.booleanValue()) {
                qp.stns = RadarServerUtil.convert4to3stations(qp.stns);
            }
        }
        if (qp.hasTimePoint) {
            if (qp.time.isPresent()) {
                try {
                    qp.time_end = new DateType("present", null, null);
                    qp.time_start = epicDateType;
                }
                catch (ParseException e) {
                    qp.errs.append("Illegal param= 'time' must be valid ISO Duration");
                    return false;
                }
            } else {
                qp.time_end = qp.time;
                qp.time_start = qp.time;
            }
        } else if (qp.hasDateRange) {
            DateRange dr = qp.getCalendarDateRange().toDateRange();
            qp.time_start = dr.getStart();
            qp.time_end = dr.getEnd();
        } else {
            qp.time_latest = 1;
            try {
                qp.time = new DateType("present", null, null);
                qp.time_end = new DateType("present", null, null);
                qp.time_start = epicDateType;
            }
            catch (ParseException e) {
                qp.errs.append("Illegal param= 'time' must be valid ISO Duration ");
                return false;
            }
        }
        if (level2.booleanValue()) {
            qp.vars = null;
        } else {
            if (qp.vars == null) {
                qp.errs.append("No vars selected ");
                return false;
            }
            if (qp.vars.get(0).contains("/")) {
                ArrayList<String> tmp = new ArrayList<String>();
                for (String var : qp.vars) {
                    tmp.add(var.replaceFirst("/.*", ""));
                }
                qp.vars = tmp;
            }
        }
        return true;
    }

    private Boolean createHeader(RadarDatasetRepository.RadarType radarType, QueryParams qp, String pathInfo, Map<String, Object> model) {
        Boolean level2 = pathInfo.contains("level2");
        int level = level2 != false ? 2 : 3;
        StringBuffer str = new StringBuffer();
        str.append("Radar Level").append(level).append(" datasets in near real time");
        model.put("name", str.toString());
        str.setLength(0);
        str.append("/thredds/dodsC/").append(pathInfo).append("/");
        model.put("base", str.toString());
        str.setLength(0);
        str.append("RadarLevel").append(level).append(" datasets for available stations and times");
        model.put("dname", str.toString());
        str.setLength(0);
        str.append("accept=").append(qp.acceptType).append("&");
        if (!level2.booleanValue() && qp.vars != null) {
            str.append("var=");
            for (int i = 0; i < qp.vars.size(); ++i) {
                str.append(qp.vars.get(i));
                if (i >= qp.vars.size() - 1) continue;
                str.append(",");
            }
            str.append("&");
        }
        if (qp.stns.get(0).toUpperCase().equals("ALL")) {
            str.append("stn=ALL&");
        } else if (qp.hasStns) {
            for (String station : qp.stns) {
                str.append("stn=").append(station).append("&");
            }
        } else if (qp.hasBB) {
            str.append("south=").append(qp.south).append("&north=").append(qp.north).append("&");
            str.append("west=").append(qp.west).append("&east=").append(qp.east).append("&");
        }
        if (qp.time_latest == 1) {
            str.append("time=present");
        } else if (qp.hasDateRange) {
            if (qp.time_start.getDate() == null || qp.time_start.isBlank() || qp.time_end.getDate() == null || qp.time_end.isBlank()) {
                str.append("time_start=").append(qp.time_start.toString());
                str.append("&time_end=").append(qp.time_end.toString());
                qp.errs.append("need ISO time format ");
                return false;
            }
            str.append("time_start=").append(qp.time_start.toDateTimeStringISO());
            str.append("&time_end=").append(qp.time_end.toDateTimeStringISO());
        } else if (qp.time.isPresent()) {
            str.append("time=present");
        } else if (qp.hasTimePoint) {
            if (qp.time.getDate() == null || qp.time.isBlank()) {
                str.append("time=").append(qp.time.toString());
                qp.errs.append("need ISO time format ");
                return false;
            }
            str.append("time=").append(qp.time.toDateTimeStringISO());
        }
        model.put("ID", str.toString());
        if (level2.booleanValue()) {
            model.put("type", "NEXRAD2");
        } else if (radarType.equals((Object)RadarDatasetRepository.RadarType.nexrad)) {
            model.put("type", "NIDS");
        } else {
            model.put("type", "TDWR");
        }
        if (this.radarDatasetRepository.isStationListEmpty(qp.stns, radarType)) {
            qp.errs.append("No station(s) meet query criteria ");
            return false;
        }
        return true;
    }

    private Boolean processQuery(String dataset, QueryParams qp, String var, List<DatasetEntry> entries) {
        RadarDatasetCollection rdc;
        Boolean getAllTimes = true;
        String yyyymmddStart = null;
        String yyyymmddEnd = null;
        String dateStart = null;
        String dateEnd = null;
        if (!qp.time_start.equals((Object)epicDateType)) {
            getAllTimes = false;
            yyyymmddStart = qp.time_start.toDateString();
            yyyymmddStart = yyyymmddStart.replace("-", "");
            yyyymmddEnd = qp.time_end.toDateString();
            yyyymmddEnd = yyyymmddEnd.replace("-", "");
            dateStart = yyyymmddStart + "_" + RadarServerUtil.hhmm(qp.time_start.toDateTimeString());
            dateEnd = yyyymmddEnd + "_" + RadarServerUtil.hhmm(qp.time_end.toDateTimeString());
        }
        if ((rdc = this.radarDatasetRepository.getRadarDatasetCollection(dataset, var)) == null) {
            qp.errs.append("Invalid dataset =").append(dataset);
            qp.errs.append(" or var =").append(var);
            return false;
        }
        StringBuffer time = new StringBuffer();
        StringBuffer product = new StringBuffer();
        StringBuffer url = new StringBuffer();
        boolean isLevel2 = dataset.contains("level2");
        String type = isLevel2 ? "Level2" : "Level3";
        String suffix = isLevel2 ? ".ar2v" : ".nids";
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        Date now = cal.getTime();
        String currentDay = dateFormat.format(now);
        block0: for (String stn : qp.stns) {
            RadarStationCollection rsc = rdc.queryStation(stn, currentDay);
            if (rsc == null) continue;
            for (String day : rsc.getDays()) {
                DatasetEntry de;
                ArrayList<String> tal;
                if (!getAllTimes.booleanValue() && !RadarServerUtil.isValidDay(day, yyyymmddStart, yyyymmddEnd)) continue;
                if (rdc.isCaseStudy()) {
                    tal = rsc.getHourMinute("all");
                    for (String prod : tal) {
                        if (!getAllTimes.booleanValue() && !RadarServerUtil.isValidDate(prod, dateStart, dateEnd)) continue;
                        de = new DatasetEntry();
                        int idx = prod.indexOf(47);
                        if (idx > 0) {
                            de.setName(prod.substring(idx + 1));
                        } else {
                            de.setName(prod);
                        }
                        de.setID(Integer.toString(prod.hashCode()));
                        url.setLength(0);
                        url.append(stn).append("/");
                        if (var != null) {
                            url.append(var).append("/");
                        }
                        url.append(prod);
                        de.setUrlPath(url.toString());
                        de.setDate(RadarServerUtil.getObTimeISO(prod));
                        entries.add(de);
                    }
                    continue;
                }
                tal = rsc.getHourMinute(day);
                if (tal == null) continue;
                for (String hm : tal) {
                    time.setLength(0);
                    time.append(day).append("_").append(hm);
                    if (!getAllTimes.booleanValue() && !RadarServerUtil.isValidDate(time.toString(), dateStart, dateEnd)) continue;
                    de = new DatasetEntry();
                    product.setLength(0);
                    product.append(type).append("_").append(rsc.getStnName()).append("_");
                    if (!isLevel2) {
                        product.append(var).append("_");
                    }
                    product.append(day).append("_").append(hm).append(suffix);
                    de.setName(product.toString());
                    de.setID(Integer.toString(product.toString().hashCode()));
                    url.setLength(0);
                    if (!isLevel2) {
                        url.append(var).append("/");
                    }
                    url.append(rsc.getStnName()).append("/").append(day).append("/").append(product.toString());
                    de.setUrlPath(url.toString());
                    de.setDate(RadarServerUtil.getObTimeISO(product.toString()));
                    entries.add(de);
                    if (!qp.hasTimePoint) continue;
                    break;
                }
                if (!qp.hasTimePoint) continue;
                continue block0;
            }
        }
        return true;
    }

    static {
        try {
            epicDateType = new DateType("1970-01-01T00:00:00", null, null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public class DatasetEntry {
        private String name;
        private String ID;
        private String urlPath;
        private String date;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getID() {
            return this.ID;
        }

        public void setID(String ID) {
            this.ID = ID;
        }

        public String getUrlPath() {
            return this.urlPath;
        }

        public void setUrlPath(String urlPath) {
            this.urlPath = urlPath;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }
    }

    public class RsVar {
        private String name;
        private String vname;
        private String units;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVname() {
            return this.vname;
        }

        public void setVname(String vname) {
            this.vname = vname;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }
    }

    public class StationEntry {
        private String id;
        private String state;
        private String country;
        private String name;
        private String longitude;
        private String latitude;
        private String elevation;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLongitude() {
            return this.longitude;
        }

        public void setLongitude(String longitude) {
            this.longitude = longitude;
        }

        public String getLatitude() {
            return this.latitude;
        }

        public void setLatitude(String latitude) {
            this.latitude = latitude;
        }

        public String getElevation() {
            return this.elevation;
        }

        public void setElevation(String elevation) {
            this.elevation = elevation;
        }
    }
}

