/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.query.Location;
import thredds.catalog.query.SelectStation;
import thredds.catalog.query.Selector;
import thredds.catalog.query.Station;
import thredds.server.config.TdsContext;
import thredds.server.radarServer.RadarDatasetCollection;
import thredds.servlet.DataRootHandler;

@Component
@DependsOn(value={"tdsContext"})
public class RadarDatasetRepository {
    private static Logger startupLog = LoggerFactory.getLogger((String)"serverStartup");
    private static final String mainCatalog = "radar/radarCollections.xml";
    private static final String nexradStations = "radar/RadarNexradStations.xml";
    private static final String terminalStations = "radar/RadarTerminalStations.xml";
    InvCatalogImpl defaultCat = null;
    HashMap<String, RadarDatasetCollection> datasetMap = new HashMap();
    HashMap<String, String> dataRoots = new HashMap();
    List<Station> nexradList = new ArrayList<Station>();
    List<Station> terminalList = new ArrayList<Station>();
    HashMap<String, Station> nexradMap;
    HashMap<String, Station> terminalMap;
    private TdsContext tdsContext;

    public boolean init(TdsContext tdsContext) {
        boolean ok = true;
        if (this.defaultCat != null) {
            return true;
        }
        this.tdsContext = tdsContext;
        File catalogFile = tdsContext.getConfigFileSource().getFile(mainCatalog);
        if (catalogFile == null || !catalogFile.exists()) {
            return false;
        }
        this.defaultCat = this.readCatalog(catalogFile);
        if (this.defaultCat == null) {
            ok = false;
        }
        DataRootHandler drh = DataRootHandler.getInstance();
        for (InvDataset top : this.defaultCat.getDatasets()) {
            for (InvDataset dataset : top.getDatasets()) {
                InvDatasetScan ds = (InvDatasetScan)dataset;
                if (ds.getPath() != null) {
                    String path = ds.getPath();
                    String location = drh.findDataRootLocation(path);
                    this.dataRoots.put(ds.getPath(), location);
                    startupLog.info("path =" + ds.getPath() + " location =" + ds.getScanLocation());
                }
                ds.setXlinkHref(ds.getPath() + "/dataset.xml");
            }
        }
        if (this.nexradList.size() == 0) {
            File nexradFile = tdsContext.getConfigFileSource().getFile(nexradStations);
            this.nexradList = this.readStations(nexradFile);
            if (this.nexradList == null) {
                startupLog.error("Station initialization problem using " + nexradFile);
                ok = false;
            }
            File terminalFile = tdsContext.getConfigFileSource().getFile(terminalStations);
            this.terminalList = this.readStations(terminalFile);
            if (this.terminalList == null) {
                startupLog.error("Station initialization problem using " + terminalFile);
                ok = false;
            }
            this.nexradMap = this.getStationMap(this.nexradList);
            this.terminalMap = this.getStationMap(this.terminalList);
        }
        startupLog.info("DatasetRepository initialization done - ok={}", (Object)ok);
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RadarDatasetCollection getRadarDatasetCollection(String key, String var) {
        String dmkey = key;
        if (var != null) {
            dmkey = key + var;
        }
        RadarDatasetCollection rdc = this.datasetMap.get(dmkey);
        boolean reread = false;
        if (rdc != null) {
            reread = rdc.previousDayNowAvailable();
        }
        if (rdc == null || reread) {
            Object sync;
            Object object = sync = new Object();
            synchronized (object) {
                if (reread) {
                    this.datasetMap.remove(dmkey);
                    rdc = null;
                } else {
                    rdc = this.datasetMap.get(dmkey);
                }
                if (rdc != null) {
                    return rdc;
                }
                rdc = new RadarDatasetCollection(this.dataRoots.get(key), var);
                if (rdc == null || rdc.yyyymmdd.size() == 0 || rdc.hhmm.size() == 0) {
                    return null;
                }
                this.datasetMap.put(dmkey, rdc);
            }
        }
        return rdc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRadarDatasetCollection(String key, String var) {
        Object sync;
        Object object = sync = new Object();
        synchronized (object) {
            if (var != null) {
                this.datasetMap.remove(key + var);
            } else {
                this.datasetMap.remove(key);
            }
        }
    }

    public InvCatalogImpl readCatalog(File catalogFile) {
        InvCatalogImpl result;
        InvCatalogFactory factory = DataRootHandler.getInstance().getCatalogFactory(false);
        URI catURI = catalogFile.toURI();
        startupLog.info("radarServer readCatalog(): full path= {}", (Object)catalogFile.toString());
        try {
            result = factory.readXML(catURI);
        }
        catch (Throwable t) {
            startupLog.error("radarServer readCatalog(): Exception on catalog={} error={}", (Object)catalogFile, (Object)t);
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Station> readStations(File stnLocation) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        SelectStation parent = new SelectStation();
        ArrayList<Station> stationList = new ArrayList<Station>();
        InputStream is = null;
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            is = new FileInputStream(stnLocation);
            Document doc = parser.parse(is);
            NodeList stns = doc.getElementsByTagName("station");
            for (int i = 0; i < stns.getLength(); ++i) {
                NamedNodeMap attr = stns.item(i).getAttributes();
                String name = "";
                String value = "";
                String state = "";
                String country = "";
                for (int j = 0; j < attr.getLength(); ++j) {
                    if (attr.item(j).getNodeName().equals("value")) {
                        value = attr.item(j).getNodeValue();
                        continue;
                    }
                    if (attr.item(j).getNodeName().equals("name")) {
                        name = attr.item(j).getNodeValue();
                        continue;
                    }
                    if (attr.item(j).getNodeName().equals("state")) {
                        state = attr.item(j).getNodeValue();
                        continue;
                    }
                    if (!attr.item(j).getNodeName().equals("country")) continue;
                    country = attr.item(j).getNodeValue();
                }
                NodeList child = stns.item(i).getChildNodes();
                Location location = null;
                for (int j = 0; j < child.getLength(); ++j) {
                    if (!child.item(j).getNodeName().equals("location3D")) continue;
                    NamedNodeMap ca = child.item(j).getAttributes();
                    String latitude = "";
                    String longitude = "";
                    String elevation = "";
                    for (int k = 0; k < ca.getLength(); ++k) {
                        if (ca.item(k).getNodeName().equals("latitude")) {
                            latitude = ca.item(k).getNodeValue();
                            continue;
                        }
                        if (ca.item(k).getNodeName().equals("longitude")) {
                            longitude = ca.item(k).getNodeValue();
                            continue;
                        }
                        if (!ca.item(k).getNodeName().equals("elevation")) continue;
                        elevation = ca.item(k).getNodeValue();
                    }
                    location = new Location(latitude, longitude, elevation, null, null, null);
                }
                Station station = new Station((Selector)parent, name, value, state, country, null);
                station.setLocation(location);
                stationList.add(station);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            stationList = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            stationList = null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            stationList = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    startupLog.error("radarServer getStations(): error closing" + stnLocation);
                }
            }
        }
        return stationList;
    }

    public HashMap<String, Station> getStationMap(List<Station> list) {
        HashMap<String, Station> stationMap = new HashMap<String, Station>();
        for (Station station : list) {
            stationMap.put(station.getValue(), station);
        }
        return stationMap;
    }

    public boolean isStationListEmpty(List<String> stations, RadarType radarType) {
        if (stations.get(0).toUpperCase().equals("ALL")) {
            return false;
        }
        for (String s : stations) {
            if (!this.isStation(s, radarType)) continue;
            return false;
        }
        return true;
    }

    public boolean isStation(String station, RadarType radarType) {
        if (station.toUpperCase().equals("ALL")) {
            return true;
        }
        Station stn = null;
        if (station.length() == 3 && radarType.equals((Object)RadarType.terminal)) {
            stn = this.terminalMap.get("T" + station);
        } else if (station.length() == 3) {
            for (Station stn3 : this.nexradList) {
                if (!stn3.getValue().endsWith(station)) continue;
                stn = stn3;
                break;
            }
        } else {
            stn = radarType.equals((Object)RadarType.terminal) ? this.terminalMap.get(station) : this.nexradMap.get(station);
        }
        return stn != null;
    }

    public Station getStation(String station, RadarType radarType) {
        Station stn = null;
        if (station.length() == 3 && radarType.equals((Object)RadarType.terminal)) {
            stn = this.terminalMap.get("T" + station);
        } else if (station.length() == 3) {
            for (Station stn3 : this.nexradList) {
                if (!stn3.getValue().endsWith(station)) continue;
                stn = stn3;
                break;
            }
        } else {
            stn = radarType.equals((Object)RadarType.terminal) ? this.terminalMap.get(station) : this.nexradMap.get(station);
        }
        return stn;
    }

    public static enum RadarType {
        nexrad,
        terminal;

    }
}

