/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.wms;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import thredds.server.dataset.TdsRequestedDataset;
import thredds.server.wms.ThreddsDataset;
import thredds.server.wms.ThreddsLayer;
import thredds.server.wms.ThreddsMetadataController;
import thredds.server.wms.ThreddsServerConfig;
import thredds.server.wms.config.WmsDetailedConfig;
import ucar.nc2.dt.GridDataset;
import uk.ac.rdg.resc.ncwms.controller.AbstractWmsController;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.exceptions.LayerNotDefinedException;
import uk.ac.rdg.resc.ncwms.exceptions.OperationNotSupportedException;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;
import uk.ac.rdg.resc.ncwms.usagelog.UsageLogEntry;
import uk.ac.rdg.resc.ncwms.wms.Layer;

public final class ThreddsWmsController
extends AbstractWmsController {
    private static final Logger log = LoggerFactory.getLogger(ThreddsWmsController.class);
    private final Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    private WmsDetailedConfig wmsConfig;

    public void init() throws Exception {
        super.init();
        ThreddsServerConfig tdsWmsServerConfig = (ThreddsServerConfig)this.serverConfig;
        this.logServerStartup.info("WMS:allow= " + tdsWmsServerConfig.isAllow());
        if (tdsWmsServerConfig.isAllow()) {
            this.logServerStartup.info("WMS:allowRemote= " + tdsWmsServerConfig.isAllowRemote());
            File wmsConfigFile = tdsWmsServerConfig.getTdsContext().getConfigFileSource().getFile("wmsConfig.xml");
            if (wmsConfigFile == null || !wmsConfigFile.exists() || !wmsConfigFile.isFile()) {
                tdsWmsServerConfig.setAllow(false);
                this.logServerStartup.error("init(): Disabling WMS: Could not find wmsConfig.xml. [Default version available at ${TOMCAT_HOME}/webapps/thredds/WEB-INF/altContent/startup/wmsConfig.xml.");
                return;
            }
            this.wmsConfig = WmsDetailedConfig.fromFile(wmsConfigFile);
            this.logServerStartup.info("init(): Loaded WMS configuration from wmsConfig.xml");
        }
    }

    protected ModelAndView dispatchWmsRequest(String request, RequestParams params, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, UsageLogEntry usageLogEntry) throws Exception {
        ThreddsServerConfig tdsWmsServerConfig = (ThreddsServerConfig)this.serverConfig;
        if (!tdsWmsServerConfig.isAllow()) {
            log.debug("dispatchWmsRequest(): WMS service not supported.");
            httpServletResponse.sendError(403, "WMS service not supported.");
            return null;
        }
        try (GridDataset gd = null;){
            ModelAndView modelAndView;
            TdsRequestedDataset reqDataset = new TdsRequestedDataset(httpServletRequest);
            if (reqDataset.isRemote() && !tdsWmsServerConfig.isAllowRemote()) {
                log.debug("dispatchWmsRequest(): WMS service not supported for remote datasets.");
                throw new WmsException("WMS service not supported for remote (non-server-resident) datasets.", "LayerNotDefined");
            }
            try {
                gd = reqDataset.openAsGridDataset(httpServletRequest, httpServletResponse);
            }
            catch (FileNotFoundException e) {
                log.debug("dispatchWmsRequest(): File not found [{}]:{}.", (Object)reqDataset.getPath(), (Object)e.getMessage());
                throw new LayerNotDefinedException(reqDataset.getPath());
            }
            catch (Exception e) {
                log.error("dispatchWmsRequest()on [" + reqDataset.getPath() + "]:", (Throwable)e);
                httpServletResponse.sendError(500);
                ModelAndView modelAndView2 = null;
                if (gd != null) {
                    gd.close();
                }
                return modelAndView2;
            }
            if (gd == null) {
                ModelAndView e = null;
                return e;
            }
            ThreddsDataset ds = ThreddsDataset.getThreddsDatasetForRequest(request, gd, reqDataset, this.wmsConfig, params);
            ThreddsLayerFactory layerFactory = new ThreddsLayerFactory(ds);
            if (request.equals("GetCapabilities")) {
                List<ThreddsDataset> datasets = Arrays.asList(ds);
                modelAndView = this.getCapabilities(datasets, null, params, httpServletRequest, usageLogEntry);
            } else if (request.equals("GetMap")) {
                modelAndView = this.getMap(params, layerFactory, httpServletResponse, usageLogEntry);
            } else if (request.equals("GetFeatureInfo")) {
                modelAndView = this.getFeatureInfo(params, layerFactory, httpServletRequest, httpServletResponse, usageLogEntry);
            } else if (request.equals("GetMetadata")) {
                ThreddsMetadataController tms = new ThreddsMetadataController(layerFactory, tdsWmsServerConfig, ds);
                modelAndView = tms.handleRequest(httpServletRequest, httpServletResponse, usageLogEntry);
            } else if (request.equals("GetLegendGraphic")) {
                modelAndView = this.getLegendGraphic(params, layerFactory, httpServletResponse);
            } else if (request.equals("GetTransect")) {
                modelAndView = this.getTransect(params, layerFactory, httpServletResponse, usageLogEntry);
            } else if (request.equals("GetVerticalProfile")) {
                modelAndView = this.getVerticalProfile(params, layerFactory, httpServletResponse, usageLogEntry);
            } else if (request.equals("GetVerticalSection")) {
                modelAndView = this.getVerticalSection(params, layerFactory, httpServletResponse, usageLogEntry);
            } else {
                throw new OperationNotSupportedException(request);
            }
            ModelAndView modelAndView3 = modelAndView;
            return modelAndView3;
        }
    }

    private static final class ThreddsLayerFactory
    implements AbstractWmsController.LayerFactory {
        private ThreddsDataset ds;

        public ThreddsLayerFactory(ThreddsDataset ds) {
            this.ds = ds;
        }

        public Layer getLayer(String layerName) throws LayerNotDefinedException {
            ThreddsLayer layer = this.ds.getLayerById(layerName);
            if (layer == null) {
                throw new LayerNotDefinedException(layerName);
            }
            return layer;
        }
    }
}

