/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.ServletUtil;

public abstract class AbstractServlet
extends HttpServlet {
    protected Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
    protected Logger log;
    protected String contentPath;

    protected abstract String getPath();

    protected abstract void makeDebugActions();

    public void init() throws ServletException {
        this.logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization start -  ");
        this.contentPath = ServletUtil.getContentPath() + this.getPath();
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.makeDebugActions();
    }

    protected void initContent() throws ServletException {
        String initialContentPath = ServletUtil.getInitialContentPath() + this.getPath();
        File initialContentFile = new File(initialContentPath);
        if (initialContentFile.exists()) {
            try {
                if (ServletUtil.copyDir(initialContentPath, this.contentPath)) {
                    this.logServerStartup.info("copyDir " + initialContentPath + " to " + this.contentPath);
                }
            }
            catch (IOException ioe) {
                this.logServerStartup.error("failed to copyDir " + initialContentPath + " to " + this.contentPath, (Throwable)ioe);
            }
        }
    }
}

