/*
 * Decompiled with CFR 0.152.
 */
package thredds.servlet.restrict;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.servlet.restrict.TomcatAuthorizer;

public class CAMSAuthorizer
extends TomcatAuthorizer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean debugResourceControl = false;

    @Override
    public boolean authorize(HttpServletRequest req, HttpServletResponse res, String role) throws IOException {
        if (this.hasCAMSrole(req, role)) {
            return true;
        }
        return super.authorize(req, res, role);
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession();
        if (session != null) {
            String origURI = (String)session.getAttribute("origRequest");
            String role = (String)session.getAttribute("role");
            if (req.isUserInRole(role)) {
                Enumeration rolesEnum;
                ArrayList rolesArray = new ArrayList();
                Enumeration e = rolesEnum = req.getHeaders("CAMS-HTTP-ROLE");
                while (rolesEnum.hasMoreElements()) {
                    rolesArray.add(e.nextElement());
                }
                session.setAttribute("camsRoles", rolesArray);
                if (origURI != null) {
                    if (this.debugResourceControl) {
                        System.out.println("redirect to origRequest = " + origURI);
                    }
                    res.setStatus(307);
                    String frag = origURI.indexOf("?") > 0 ? "&auth" : "?auth";
                    res.addHeader("Location", origURI + frag);
                    return;
                }
                res.setStatus(200);
                return;
            }
        }
        res.sendError(401, "Not authorized to access this dataset.");
    }

    private boolean hasCAMSrole(HttpServletRequest req, String role) {
        HttpSession session = req.getSession();
        if (session != null) {
            List roles = (List)session.getAttribute("camsRoles");
            return roles != null && roles.contains(role);
        }
        return false;
    }
}

