/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.tracker;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import thredds.server.catalog.tracker.DatasetTracker;

public class CatalogWatcher
implements Closeable {
    private final WatchService watcher;
    private final DatasetTracker tracker;
    private final boolean enable;
    private final Map<WatchKey, Path> keys;
    private boolean recursive = true;
    private boolean trace = true;

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public CatalogWatcher(DatasetTracker tracker, boolean enable) throws IOException {
        this.tracker = tracker;
        this.enable = enable;
        this.watcher = FileSystems.getDefault().newWatchService();
        this.keys = new HashMap<WatchKey, Path>();
        this.trace = true;
    }

    public void register(Path dir) throws IOException {
        if (!this.enable) {
            return;
        }
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        if (this.trace) {
            Path prev = this.keys.get(key);
            if (prev == null) {
                System.out.format("CatalogWatcher register: %s%n", dir);
            } else if (!dir.equals(prev)) {
                System.out.format("update: %s -> %s%n", prev, dir);
            }
        }
        this.keys.put(key, dir);
    }

    public void registerAll(Path start) throws IOException {
        if (!this.enable) {
            return;
        }
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                CatalogWatcher.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void processEvents() {
        if (!this.enable) {
            return;
        }
        while (true) {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                return;
            }
            Path dir = this.keys.get(key);
            if (dir == null) {
                System.err.println("WatchKey not recognized!!");
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent ev = CatalogWatcher.cast(event);
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                System.out.format("%s: %s%n", event.kind().name(), child);
                if (!this.recursive || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                try {
                    if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                    this.registerAll(child);
                }
                catch (IOException iOException) {}
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
            if (this.keys.isEmpty()) break;
        }
    }

    @Override
    public void close() throws IOException {
        this.watcher.close();
    }
}

