/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import java.lang.invoke.MethodHandles;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.MFile;
import thredds.inventory.MFiles;
import thredds.server.catalog.CatalogScan;
import thredds.server.catalog.DatasetScan;
import thredds.server.catalog.FeatureCollectionRef;

@Immutable
public class DataRoot {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String path;
    private final String dirLocation;
    private final String name;
    private final DatasetScan datasetScan;
    private final FeatureCollectionRef featCollection;
    private final CatalogScan catScan;
    private final Type type;
    private final String restrict;

    public DataRoot(FeatureCollectionRef featCollection) {
        this.path = featCollection.getPath();
        this.dirLocation = featCollection.getTopDirectoryLocation();
        this.datasetScan = null;
        this.catScan = null;
        this.featCollection = featCollection;
        this.type = Type.featureCollection;
        this.name = featCollection.getCollectionName();
        this.restrict = featCollection.getRestrictAccess();
        logger.debug(" DataRoot %s==%s%n", (Object)this.path, (Object)this.dirLocation);
    }

    public DataRoot(DatasetScan scan) {
        this.path = scan.getPath();
        this.dirLocation = scan.getScanLocation();
        this.datasetScan = scan;
        this.catScan = null;
        this.featCollection = null;
        this.type = Type.datasetScan;
        this.name = scan.getName();
        this.restrict = scan.getRestrictAccess();
        logger.debug(" DataRoot %s==%s%n", (Object)this.path, (Object)this.dirLocation);
    }

    public DataRoot(CatalogScan catScan) {
        this.path = catScan.getPath();
        this.dirLocation = catScan.getLocation();
        this.datasetScan = null;
        this.catScan = catScan;
        this.featCollection = null;
        this.type = Type.catalogScan;
        this.name = catScan.getName();
        this.restrict = null;
        logger.debug(" DataRoot %s==%s%n", (Object)this.path, (Object)this.dirLocation);
    }

    public DataRoot(String path, String dirLocation, String restrict) {
        this.path = path;
        this.dirLocation = dirLocation;
        this.datasetScan = null;
        this.catScan = null;
        this.featCollection = null;
        this.type = Type.datasetRoot;
        this.name = null;
        this.restrict = restrict;
        logger.debug(" DataRoot %s==%s%n", (Object)path, (Object)dirLocation);
    }

    public String getPath() {
        return this.path;
    }

    public String getDirLocation() {
        return this.dirLocation;
    }

    public Type getType() {
        return this.type;
    }

    public DatasetScan getDatasetScan() {
        return this.datasetScan;
    }

    public CatalogScan getCatalogScan() {
        return this.catScan;
    }

    public FeatureCollectionRef getFeatureCollection() {
        return this.featCollection;
    }

    public String getName() {
        return this.name;
    }

    public String getRestrict() {
        return this.restrict;
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataRoot root = (DataRoot)o;
        return this.path.equals(root.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String getFileLocationFromRequestPath(String reqPath) {
        if (this.datasetScan != null) {
            return DataRoot.getFileLocationFromRequestPath(reqPath, this.datasetScan.getPath(), this.datasetScan.getScanLocation(), false);
        }
        if (this.catScan != null) {
            return DataRoot.getFileLocationFromRequestPath(reqPath, this.catScan.getPath(), this.catScan.getLocation(), false);
        }
        if (this.featCollection != null) {
            return DataRoot.getFileLocationFromRequestPath(reqPath, this.featCollection.getPath(), this.featCollection.getTopDirectoryLocation(), true);
        }
        return DataRoot.getFileLocationFromRequestPath(reqPath, this.getPath(), this.getDirLocation(), false);
    }

    static String getFileLocationFromRequestPath(String reqPath, String rootPath, String rootLocation, boolean isFeatureCollection) {
        if (reqPath == null) {
            return null;
        }
        if (reqPath.length() == 0) {
            return null;
        }
        if (reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if (!reqPath.startsWith(rootPath)) {
            return null;
        }
        String relativeLocation = DataRoot.getRelativeLocation(reqPath, rootPath, isFeatureCollection);
        MFile rootMFile = MFiles.create((String)rootLocation);
        MFile mFile = rootMFile.getChild(relativeLocation);
        return mFile == null ? null : mFile.getPath();
    }

    private static String getRelativeLocation(String reqPath, String rootPath, boolean isFeatureCollection) {
        String locationRelative = reqPath.substring(rootPath.length());
        if (isFeatureCollection && locationRelative.startsWith("/files")) {
            locationRelative = locationRelative.substring(7);
        }
        if (locationRelative.startsWith("/")) {
            locationRelative = locationRelative.substring(1);
        }
        return locationRelative;
    }

    public static enum Type {
        datasetRoot,
        datasetScan,
        catalogScan,
        featureCollection;

    }
}

