/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

public enum ContentType {
    binary("application/octet-stream", null),
    csv("text/plain", "UTF-8"),
    html("text/html", "UTF-8"),
    jnlp("application/x-java-jnlp-file", null),
    json("application/json", "UTF-8"),
    ncstream("application/octet-stream", null),
    netcdf("application/x-netcdf", null),
    ogc_exception("application/vnd.ogc.se_xml", "UTF-8"),
    png("image/png", null),
    text("text/plain", "UTF-8"),
    xml("application/xml", "UTF-8"),
    xmlwms("text/xml", "iso-8859-1");

    public static final String HEADER = "Content-Type";
    private final String name;
    private final String charset;

    public static ContentType findContentTypeFromFilename(String filename) {
        if (filename.endsWith(".csv")) {
            return csv;
        }
        if (filename.endsWith(".html")) {
            return html;
        }
        if (filename.endsWith(".json")) {
            return json;
        }
        if (filename.endsWith(".xml")) {
            return xml;
        }
        if (filename.endsWith(".txt") || filename.endsWith(".log") || filename.endsWith(".out")) {
            return text;
        }
        if (filename.endsWith(".nc") || filename.endsWith(".nc4")) {
            return netcdf;
        }
        if (filename.indexOf(".log.") > 0) {
            return text;
        }
        return null;
    }

    private ContentType(String name, String charset) {
        this.name = name;
        this.charset = charset;
    }

    public String toString() {
        return this.name;
    }

    public String getContentHeader() {
        return this.charset == null ? this.name : this.name + ";charset=" + this.charset;
    }
}

