/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalApiSigner {
    public static final String LOCAL_API_SIGNATURE_HEADER_V1 = "X-TDS-Local-Api-Signature-V1";
    private static final HexFormat HEX_FORMAT = HexFormat.of();
    private static final String SIGNING_ALGO = "HmacSHA256";
    private static final int DEFAULT_VALID_WINDOW_SIZE = 5;
    private static final Logger logger = LoggerFactory.getLogger(LocalApiSigner.class);
    private final Mac mac;
    private final int validWindowSize;

    public LocalApiSigner(String key) {
        this(key, 5);
    }

    LocalApiSigner(String key, int windowSize) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), SIGNING_ALGO);
        this.validWindowSize = windowSize;
        try {
            this.mac = Mac.getInstance(SIGNING_ALGO);
            this.mac.init(secretKeySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String getPartialStringToSignGet(String url) {
        URI uri = URI.create(url);
        String stringToSign = uri.getPath();
        if (uri.getQuery() != null) {
            String orderedQuery = Arrays.stream(uri.getQuery().split("&")).sorted().collect(Collectors.joining("&"));
            stringToSign = String.format("%s?%s", stringToSign, orderedQuery);
        }
        return stringToSign;
    }

    private String getHexSig(String stringToSign) {
        return HEX_FORMAT.formatHex(this.mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8)));
    }

    public String generateSignatureGet(String url) {
        String stringToSign = SigningWindowInSeconds.get(this.validWindowSize).current() + this.getPartialStringToSignGet(url);
        return this.getHexSig(stringToSign);
    }

    public boolean verifySignatureGet(String url, String expectedSignature) {
        String partialStringToSign = this.getPartialStringToSignGet(url);
        String stringToSignCurrent = SigningWindowInSeconds.get(this.validWindowSize).current() + partialStringToSign;
        String stringToSignPrevious = SigningWindowInSeconds.get(this.validWindowSize).previous() + partialStringToSign;
        logger.debug("expected signature: {}", (Object)expectedSignature);
        logger.debug("actual signature (current window): {}", (Object)this.getHexSig(stringToSignCurrent));
        logger.debug("actual signature (previous window): {}", (Object)this.getHexSig(stringToSignPrevious));
        return this.getHexSig(stringToSignCurrent).equals(expectedSignature) || this.getHexSig(stringToSignPrevious).equals(expectedSignature);
    }

    private static class SigningWindowInSeconds {
        private static final ZoneOffset ZONE_OFFSET = ZoneOffset.UTC;
        private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'hh:mm:ssv").withZone(ZONE_OFFSET);
        private final ZonedDateTime current;
        private final ZonedDateTime previous;

        private SigningWindowInSeconds(int windowSize) {
            ZonedDateTime now = Instant.now().truncatedTo(ChronoUnit.SECONDS).atZone(ZONE_OFFSET);
            int currentSeconds = now.getSecond();
            int windowIncrements = Math.floorDiv(currentSeconds, windowSize);
            ZonedDateTime base = now.minusSeconds(currentSeconds);
            this.current = base.plusSeconds((long)windowIncrements * (long)windowSize);
            this.previous = this.current.minusSeconds((long)windowIncrements * (long)windowSize);
            logger.debug("current time {}", (Object)DATE_TIME_FORMATTER.format(now));
            logger.debug("current window {}", (Object)DATE_TIME_FORMATTER.format(this.current));
            logger.debug("previous window {}", (Object)DATE_TIME_FORMATTER.format(this.previous));
        }

        static SigningWindowInSeconds get(int windowSize) {
            return new SigningWindowInSeconds(windowSize);
        }

        String current() {
            return DATE_TIME_FORMATTER.format(this.current);
        }

        String previous() {
            return DATE_TIME_FORMATTER.format(this.previous);
        }
    }
}

