/*
 * Decompiled with CFR 0.152.
 */
package thredds.tdm;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import thredds.client.catalog.Catalog;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionConfigBuilder;
import thredds.inventory.CollectionSpecParser;
import thredds.util.AliasHandler;

public class CatalogConfigReader {
    private static final Logger log = LoggerFactory.getLogger(CatalogConfigReader.class);
    private static final boolean debug = false;
    private final List<FeatureCollectionConfig> fcList = new ArrayList<FeatureCollectionConfig>();
    Formatter errlog = new Formatter();
    private AliasHandler aliasHandler;

    public List<FeatureCollectionConfig> getFcList() {
        return this.fcList;
    }

    public CatalogConfigReader(Resource catR, AliasHandler aliasHandler) throws IOException {
        this.aliasHandler = aliasHandler;
        this.readCatalog(catR);
    }

    private boolean readCatalog(Resource catR) throws IOException {
        Document doc;
        File catFile = catR.getFile();
        String fcName = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            doc = builder.build(catFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        Element root = doc.getRootElement();
        try {
            ArrayList<Element> fcElems = new ArrayList<Element>();
            this.findFeatureCollections(root, fcName, fcElems);
            for (Element fcElem : fcElems) {
                String name = "";
                try {
                    CollectionSpecParser specp;
                    Path rootPath;
                    FeatureCollectionConfigBuilder configBuilder = new FeatureCollectionConfigBuilder(this.errlog);
                    FeatureCollectionConfig config = configBuilder.readConfig(fcElem);
                    if (configBuilder.fatalError) continue;
                    name = config.collectionName;
                    if (config.spec != null) {
                        config.spec = this.aliasHandler.replaceAlias(config.spec);
                    }
                    if (!Files.exists(rootPath = Paths.get((specp = config.getCollectionSpecParser(this.errlog)).getRootDir(), new String[0]), new LinkOption[0])) {
                        System.out.printf("Root path %s does not exist fc='%s' from catalog=%s %n", rootPath.getFileName(), config.collectionName, catFile.getPath());
                        log.error("Root path {} does not exist fc='{}' from catalog={}", new Object[]{rootPath.getFileName(), config.collectionName, catFile.getPath()});
                        continue;
                    }
                    this.fcList.add(config);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    log.error("Error reading collection " + name + " skipping collection ", e);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("Error reading catalog " + catFile.getPath() + " skipping ", e);
        }
        try {
            ArrayList<Element> catrefElems = new ArrayList<Element>();
            this.findCatalogRefs(root, catrefElems);
            for (Element catrefElem : catrefElems) {
                String href = catrefElem.getAttributeValue("href", Catalog.xlinkNS);
                File refCat = new File(catFile.getParent(), href);
                FileSystemResource catRnested = new FileSystemResource(refCat);
                if (!catRnested.exists()) {
                    log.error("Relative catalog {} does not exist", (Object)refCat);
                    continue;
                }
                this.readCatalog((Resource)catRnested);
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            log.error("Error follow catrefs in " + catFile.getPath() + " skipping ", (Throwable)e);
        }
        return true;
    }

    private void findFeatureCollections(Element parent, String name, List<Element> fcElems) {
        List elist = parent.getChildren("featureCollection", Catalog.defNS);
        if (name == null) {
            fcElems.addAll(elist);
        } else {
            for (Element elem : elist) {
                if (!name.equals(elem.getAttributeValue("name"))) continue;
                fcElems.add(elem);
            }
        }
        for (Element child : parent.getChildren("dataset", Catalog.defNS)) {
            this.findFeatureCollections(child, name, fcElems);
        }
    }

    private void findCatalogRefs(Element parent, List<Element> catrefElems) {
        List elist = parent.getChildren("catalogRef", Catalog.defNS);
        catrefElems.addAll(elist);
        for (Element child : parent.getChildren("dataset", Catalog.defNS)) {
            this.findCatalogRefs(child, catrefElems);
        }
    }
}

