/*
 * Decompiled with CFR 0.152.
 */
package thredds.tdm;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import thredds.featurecollection.CollectionUpdater;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionUpdateEvent;
import thredds.inventory.CollectionUpdateType;
import thredds.tdm.CatalogConfigReader;
import thredds.util.ThreddsConfigReader;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.AliasTranslator;
import ucar.nc2.util.DiskCache2;

public class Tdm {
    private static Logger tdmLogger = LoggerFactory.getLogger(Tdm.class);
    private static Logger detailLogger = LoggerFactory.getLogger((String)"tdmDetail");
    private static final boolean debug = false;
    private static final boolean debugOpenFiles = false;
    private static final boolean debugTasks = true;
    private EventBus eventBus;
    private CollectionUpdater collectionUpdater;
    private Path contentDir;
    private Path contentThreddsDir;
    private Path contentTdmDir;
    private Path threddsConfig;
    private String user;
    private String pass;
    private boolean sendTriggers;
    private String[] serverNames;
    private List<Server> servers;
    private ExecutorService executor;
    private Resource catalog;
    private boolean showOnly = false;
    private boolean forceOnStartup = false;
    List<Resource> catalogRoots = new ArrayList<Resource>();
    Map<String, Listener> fcMap = new HashMap<String, Listener>();
    private AtomicInteger indexTaskCount = new AtomicInteger();

    public void setContentDir(String contentDir) throws IOException {
        System.out.printf("contentDir=%s%n", contentDir);
        this.contentDir = Paths.get(contentDir, new String[0]);
        this.contentThreddsDir = Paths.get(contentDir, "thredds");
        this.threddsConfig = Paths.get(contentDir, "thredds", "threddsConfig.xml");
        this.contentTdmDir = Paths.get(contentDir, "tdm");
        this.catalog = new FileSystemResource(this.contentThreddsDir.toString() + "/catalog.xml");
        System.out.printf("catalog=%s%n", this.catalog.getFile().getPath());
    }

    public void setShowOnly(boolean showOnly) {
        this.showOnly = showOnly;
    }

    public void setNThreads(int n) {
        this.executor = Executors.newFixedThreadPool(n);
        tdmLogger.info(" TDM nthreads= {}", (Object)n);
    }

    public void setForceOnStartup(boolean forceOnStartup) {
        this.forceOnStartup = forceOnStartup;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    void setUpdater(CollectionUpdater collectionUpdater, EventBus eventBus) {
        this.collectionUpdater = collectionUpdater;
        this.eventBus = eventBus;
    }

    public void setCatalog(String catName) {
        this.catalog = new FileSystemResource(catName);
    }

    public void setServerNames(String[] serverNames) {
        this.serverNames = serverNames;
    }

    public void initServers() throws HTTPException {
        if (this.serverNames == null) {
            this.servers = new ArrayList<Server>();
            return;
        }
        this.servers = new ArrayList<Server>(this.serverNames.length);
        for (String name : this.serverNames) {
            HTTPSession session = HTTPFactory.newSession((String)name);
            if (this.user != null && this.pass != null) {
                UsernamePasswordCredentials bp = new UsernamePasswordCredentials(this.user, this.pass);
                BasicCredentialsProvider bcp = new BasicCredentialsProvider();
                bcp.setCredentials(AuthScope.ANY, (Credentials)bp);
                session.setCredentialsProvider((CredentialsProvider)bcp);
            }
            session.setUserAgent("TDM");
            this.servers.add(new Server(name, session));
        }
    }

    boolean init() throws HTTPException {
        this.initServers();
        System.setProperty("tds.log.dir", this.contentTdmDir.toString());
        if (!Files.exists(this.threddsConfig, new LinkOption[0])) {
            tdmLogger.error("config file {} does not exist, set -Dtds.content.root.path=<dir>", (Object)this.threddsConfig);
            System.out.printf("threddsConfig does not exist=%s%n", this.threddsConfig);
            return false;
        }
        ThreddsConfigReader reader = new ThreddsConfigReader(this.threddsConfig.toString(), tdmLogger);
        for (String location : reader.getRootList("catalogRoot")) {
            FileSystemResource r = new FileSystemResource(this.contentThreddsDir.toString() + "/" + location);
            this.catalogRoots.add((Resource)r);
        }
        String gribIndexDir = reader.get("GribIndex.dir", new File(this.contentThreddsDir.toString(), "cache/grib/").getPath());
        Boolean gribIndexAlwaysUse = reader.getBoolean("GribIndex.alwaysUse", false);
        Boolean gribIndexNeverUse = reader.getBoolean("GribIndex.neverUse", false);
        String gribIndexPolicy = reader.get("GribIndex.policy", null);
        DiskCache2 gribCache = gribIndexNeverUse != false ? DiskCache2.getNoop() : new DiskCache2(gribIndexDir, false, -1, -1);
        gribCache.setPolicy(gribIndexPolicy);
        gribCache.setAlwaysUseCache(gribIndexAlwaysUse.booleanValue());
        gribCache.setNeverUseCache(gribIndexNeverUse.booleanValue());
        GribIndexCache.setDiskCache2((DiskCache2)gribCache);
        tdmLogger.info("TDM initialized {}", (Object)gribCache);
        return true;
    }

    void start() throws IOException {
        System.out.printf("Tdm startup at %s%n", new Date());
        this.collectionUpdater.setTdm(true);
        this.eventBus.register((Object)this);
        ArrayList<FeatureCollectionConfig> fcList = new ArrayList<FeatureCollectionConfig>();
        CatalogConfigReader reader = new CatalogConfigReader(this.contentThreddsDir, this.catalog);
        fcList.addAll(reader.getFcList());
        for (Resource resource : this.catalogRoots) {
            CatalogConfigReader r = new CatalogConfigReader(this.contentThreddsDir, resource);
            fcList.addAll(r.getFcList());
        }
        if (this.showOnly) {
            ArrayList<String> result = new ArrayList<String>();
            for (FeatureCollectionConfig config : fcList) {
                result.add(config.collectionName);
            }
            Collections.sort(result);
            System.out.printf("%nFeature Collection names:%n", new Object[0]);
            for (String name : result) {
                System.out.printf(" %s%n", name);
            }
            System.out.printf("%nTriggers:%n", new Object[0]);
            for (String name : result) {
                System.out.printf(" %s%n", this.makeTriggerUrl(name));
            }
            this.executor.shutdown();
            this.collectionUpdater.shutdown();
            return;
        }
        for (FeatureCollectionConfig featureCollectionConfig : fcList) {
            if (featureCollectionConfig.type != FeatureCollectionType.GRIB1 && featureCollectionConfig.type != FeatureCollectionType.GRIB2) continue;
            System.out.printf("FeatureCollection %s scheduled %n", featureCollectionConfig.collectionName);
            if (this.forceOnStartup) {
                featureCollectionConfig.tdmConfig.startupType = CollectionUpdateType.always;
            }
            detailLogger.info("FeatureCollection config=" + featureCollectionConfig);
            this.fcMap.put(featureCollectionConfig.getCollectionName(), new Listener(featureCollectionConfig));
            this.collectionUpdater.scheduleTasks(featureCollectionConfig, null);
        }
    }

    @Subscribe
    public void processEvent(CollectionUpdateEvent event) {
        Listener fc = this.fcMap.get(event.getCollectionName());
        if (fc == null) {
            tdmLogger.error("Unknown collection name from event bus " + event);
            return;
        }
        fc.processEvent(event.getType());
    }

    private String makeTriggerUrl(String name) {
        return "thredds/admin/collection/trigger?trigger=never&collection=" + name;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        try (FileSystemXmlApplicationContext springContext = new FileSystemXmlApplicationContext("classpath:resources/application-config.xml");){
            CommandLine cmdLine;
            String progName;
            Tdm app;
            block25: {
                app = (Tdm)springContext.getBean("TDM");
                Map aliases = (Map)springContext.getBean("dataRootLocationAliasExpanders");
                for (Map.Entry entry : aliases.entrySet()) {
                    AliasTranslator.addAlias((String)((String)entry.getKey()), (String)((String)entry.getValue()));
                }
                EventBus eventBus = (EventBus)springContext.getBean("fcTriggerEventBus");
                CollectionUpdater collectionUpdater = (CollectionUpdater)springContext.getBean("collectionUpdater");
                collectionUpdater.setEventBus(eventBus);
                app.setUpdater(collectionUpdater, eventBus);
                String contentDir = System.getProperty("tds.content.root.path");
                if (contentDir == null) {
                    contentDir = "../content";
                }
                app.setContentDir(contentDir);
                HTTPSession.setGlobalUserAgent((String)"TDM v5.0");
                progName = Tdm.class.getName();
                cmdLine = new CommandLine(progName, args);
                if (!cmdLine.help) break block25;
                cmdLine.printUsage();
                return;
            }
            try {
                if (cmdLine.catalog != null) {
                    app.setCatalog(cmdLine.catalog);
                }
                if (cmdLine.cred != null) {
                    String[] split = cmdLine.cred.split(":");
                    app.user = split[0];
                    app.pass = split[1];
                    app.sendTriggers = true;
                }
                if (cmdLine.forceOnStartup) {
                    app.setForceOnStartup(true);
                }
                if (cmdLine.nthreads != 0) {
                    app.setNThreads(cmdLine.nthreads);
                }
                if (cmdLine.showOnly) {
                    app.setShowOnly(true);
                }
                if (cmdLine.tds != null) {
                    if (cmdLine.tds.equalsIgnoreCase("none")) {
                        app.setServerNames(null);
                        app.sendTriggers = false;
                    } else {
                        String[] tdss = cmdLine.tds.split(",");
                        app.setServerNames(tdss);
                        app.sendTriggers = true;
                    }
                }
            }
            catch (ParameterException e) {
                System.err.println(e.getMessage());
                System.err.printf("Try \"%s --help\" for more information.%n", progName);
            }
            if (!app.showOnly && app.pass == null && app.sendTriggers) {
                String passw;
                String ok;
                Scanner scanner = new Scanner(System.in, "UTF-8");
                do {
                    System.out.printf("%nEnter password for tds trigger: ", new Object[0]);
                    passw = scanner.nextLine();
                    System.out.printf("%nPassword = '%s' OK (Y/N)?", passw);
                } while (!(ok = scanner.nextLine()).equalsIgnoreCase("Y"));
                if (passw != null) {
                    app.pass = passw;
                    app.user = "tdm";
                } else {
                    app.sendTriggers = false;
                }
            }
            if (app.init()) {
                app.start();
            } else {
                System.out.printf("%nEXIT DUE TO ERRORS", new Object[0]);
            }
        }
    }

    private static class Server {
        String name;
        HTTPSession session;

        private Server(String name, HTTPSession session) {
            this.name = name;
            this.session = session;
            System.out.printf("Server added %s%n", name);
            tdmLogger.info("TDS server added " + name);
        }
    }

    private class Listener {
        FeatureCollectionConfig config;
        AtomicBoolean inUse = new AtomicBoolean(false);

        private Listener(FeatureCollectionConfig config) {
            this.config = config;
        }

        public void processEvent(CollectionUpdateType event) {
            if (!this.inUse.compareAndSet(false, true)) {
                detailLogger.debug("Tdm event type '{}' already in use on {}", (Object)event, (Object)this.config.getCollectionName());
                return;
            }
            detailLogger.debug("Tdm event type '{}' scheduled for {}", (Object)event, (Object)this.config.getCollectionName());
            Tdm.this.executor.execute(new IndexTask(this.config, this, event));
        }
    }

    private static class CommandLine {
        @Parameter(names={"-catalog"}, description="name a specific catalog (relative to content dir)", required=false)
        public String catalog;
        @Parameter(names={"-cred"}, description="tds credentials (user:password)", required=false)
        public String cred;
        @Parameter(names={"-forceOnStartup"}, description="force read all collections on startup (override config)", required=false)
        public boolean forceOnStartup;
        @Parameter(names={"-nthreads"}, description="number of threads", required=false)
        public int nthreads = 1;
        @Parameter(names={"-showOnly"}, description="show collections and exit", required=false)
        public boolean showOnly;
        @Parameter(names={"-tds"}, description="list of tds programs to send triggers to", required=false)
        public String tds;
        @Parameter(names={"-h", "--help"}, description="Display this help and exit", help=true)
        public boolean help = false;
        private final JCommander jc = new JCommander((Object)this);

        public CommandLine(String progName, String[] args) throws ParameterException {
            this.jc.parse(args);
            this.jc.setProgramName(progName);
        }

        public void printUsage() {
            this.jc.usage();
            System.out.printf("example: /opt/jdk/bin/java -Xmx3g -Dtds.content.root.path=/my/content -jar tdm-5.0.jar -tds http://thredds-dev.unidata.ucar.edu/ -cred tdm:trigger %n", new Object[0]);
        }
    }

    private class IndexTask
    implements Runnable {
        String name;
        FeatureCollectionConfig config;
        CollectionUpdateType updateType;
        Listener liz;

        private IndexTask(FeatureCollectionConfig config, Listener liz, CollectionUpdateType updateType) {
            this.name = config.collectionName;
            this.config = config;
            this.liz = liz;
            this.updateType = updateType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                int taskNo = Tdm.this.indexTaskCount.getAndIncrement();
                tdmLogger.debug("{} start {}", (Object)taskNo, (Object)this.config.collectionName);
                boolean changed = GribCdmIndex.updateGribCollection((FeatureCollectionConfig)this.config, (CollectionUpdateType)this.updateType, null);
                long took = System.currentTimeMillis() - start;
                tdmLogger.debug("{} done {}: changed {} took {} ms", new Object[]{taskNo, this.config.collectionName, changed, took});
                System.out.printf("%s: %s changed %s took %d msecs%n", CalendarDate.present(), this.config.collectionName, changed, took);
                System.out.printf("executor=%s%n", Tdm.this.executor);
                if (changed && this.config.tdmConfig.triggerOk && Tdm.this.sendTriggers) {
                    String path = Tdm.this.makeTriggerUrl(this.name);
                    this.sendTriggers(path);
                }
            }
            catch (Throwable e) {
                tdmLogger.error("Tdm.IndexTask " + this.name, e);
                e.printStackTrace();
            }
            finally {
                if (!this.liz.inUse.getAndSet(false)) {
                    tdmLogger.warn("Listener InUse should have been set");
                }
            }
        }

        private void sendTriggers(String path) {
            for (Server server : Tdm.this.servers) {
                String url = server.name + path;
                try {
                    HTTPMethod m = HTTPFactory.Get((HTTPSession)server.session, (String)url);
                    try {
                        detailLogger.debug("send trigger to {}", (Object)url);
                        int status = m.execute();
                        if (status != 200) {
                            tdmLogger.warn("FAIL send trigger to {} status = {}", (Object)url, (Object)status);
                            detailLogger.warn("FAIL send trigger to {} status = {}", (Object)url, (Object)status);
                            continue;
                        }
                        int taskNo = Tdm.this.indexTaskCount.get();
                        tdmLogger.info("{} trigger sent {} status = {}", new Object[]{taskNo, url, status});
                        detailLogger.debug("return from {} status = {}", (Object)url, (Object)status);
                    }
                    finally {
                        if (m == null) continue;
                        m.close();
                    }
                }
                catch (HTTPException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ConnectException) {
                        detailLogger.warn("server {} not running", (Object)server.name);
                        continue;
                    }
                    tdmLogger.error("FAIL send trigger to " + url + " failed", cause);
                    detailLogger.error("FAIL send trigger to " + url + " failed", cause);
                }
            }
        }
    }
}

