/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.server.catalog.DatasetRootConfig;
import ucar.unidata.util.StringUtil2;

@Immutable
public class ConfigCatalog
extends Catalog {
    private static Map<String, String> alias = new HashMap<String, String>();

    public static void addAlias(String aliasKey, String actual) {
        alias.put(aliasKey, StringUtil2.substitute(actual, "\\", "/"));
    }

    public static String translateAlias(String scanDir) {
        for (Map.Entry<String, String> entry : alias.entrySet()) {
            if (!scanDir.contains(entry.getKey())) continue;
            return StringUtil2.substitute(scanDir, entry.getKey(), entry.getValue());
        }
        return scanDir;
    }

    public ConfigCatalog(URI baseURI, String name, Map<String, Object> flds, List<DatasetBuilder> datasets) {
        super(baseURI, name, flds, datasets);
    }

    public List<DatasetRootConfig> getDatasetRoots() {
        return this.getLocalFieldAsList("DatasetRoots");
    }

    private List getLocalFieldAsList(String fldName) {
        Object value = this.flds.get(fldName);
        if (value != null) {
            if (value instanceof List) {
                return (List)value;
            }
            ArrayList result = new ArrayList(1);
            result.add(value);
            return result;
        }
        return new ArrayList(0);
    }
}

