/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.writer.DataFactory;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class ThreddsMetadataExtractor {
    private static Logger logger = LoggerFactory.getLogger(ThreddsMetadataExtractor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreddsMetadata extract(Dataset threddsDataset) throws IOException {
        ThreddsMetadata metadata = new ThreddsMetadata();
        Map<String, Object> flds = metadata.getFlds();
        DataFactory.Result result = null;
        try {
            result = new DataFactory().openFeatureDataset(threddsDataset, null);
            if (result.fatalError) {
                logger.warn(" openFeatureDataset failed, errs=%s%n", (Object)result.errLog);
                ThreddsMetadata threddsMetadata = null;
                return threddsMetadata;
            }
            if (result.featureType.isGridFeatureType()) {
                ThreddsMetadata.VariableGroup vars;
                GridDataset gridDataset = (GridDataset)((Object)result.featureDataset);
                flds.put("GeospatialCoverage", this.extractGeospatial(gridDataset));
                DateRange tc = this.extractDateRange(gridDataset);
                if (tc != null) {
                    flds.put("TimeCoverage", tc);
                }
                if ((vars = this.extractVariables(threddsDataset.getDataFormatName(), gridDataset)) != null) {
                    flds.put("VariableGroups", vars);
                }
            } else if (result.featureType.isPointFeatureType()) {
                ThreddsMetadata.VariableGroup vars;
                DateRange tc;
                PointDatasetImpl pobsDataset = (PointDatasetImpl)result.featureDataset;
                LatLonRect llbb = pobsDataset.getBoundingBox();
                if (null != llbb) {
                    flds.put("GeospatialCoverage", new ThreddsMetadata.GeospatialCoverage(llbb, null));
                }
                if ((tc = this.extractDateRange(pobsDataset)) != null) {
                    flds.put("TimeCoverage", tc);
                }
                if ((vars = this.extractVariables(pobsDataset)) != null) {
                    flds.put("VariableGroups", vars);
                }
            }
        }
        finally {
            try {
                if (result != null && result.featureDataset != null) {
                    result.featureDataset.close();
                }
            }
            catch (IOException ioe) {
                logger.error("Closing dataset " + result.featureDataset, ioe);
            }
        }
        return metadata;
    }

    private ThreddsMetadata.GeospatialCoverage extractGeospatial(GridDataset gridDataset) {
        LatLonRect llbb = null;
        CoordinateAxis1D vaxis = null;
        for (GridDataset.Gridset gridset : gridDataset.getGridsets()) {
            GridCoordSystem gsys = gridset.getGeoCoordSystem();
            if (llbb == null) {
                llbb = gsys.getLatLonBoundingBox();
            }
            CoordinateAxis1D vaxis2 = gsys.getVerticalAxis();
            if (vaxis == null) {
                vaxis = vaxis2;
                continue;
            }
            if (vaxis2 == null || vaxis2.getSize() <= vaxis.getSize()) continue;
            vaxis = vaxis2;
        }
        return new ThreddsMetadata.GeospatialCoverage(llbb, vaxis);
    }

    private ThreddsMetadata.VariableGroup extractVariables(String fileFormat, GridDataset gridDataset) {
        ArrayList<ThreddsMetadata.Variable> vars = new ArrayList<ThreddsMetadata.Variable>();
        String vocab = fileFormat;
        DataFormatType fileType = DataFormatType.getType(fileFormat);
        if (fileType != null && (fileType == DataFormatType.GRIB1 || fileType == DataFormatType.GRIB2)) {
            for (GridDatatype grid : gridDataset.getGrids()) {
                String name = grid.getShortName();
                String desc = grid.getDescription();
                String units = grid.getUnitsString();
                String vname = null;
                String id = null;
                Attribute att = grid.findAttributeIgnoreCase("Grib_Variable_Id");
                if (att != null) {
                    id = att.getStringValue();
                    vname = att.getStringValue();
                }
                vars.add(new ThreddsMetadata.Variable(name, desc, vname, units, id));
            }
        } else {
            vocab = "CF-1.0";
            for (GridDatatype grid : gridDataset.getGrids()) {
                String name = grid.getShortName();
                String desc = grid.getDescription();
                String units = grid.getUnitsString();
                String vname = null;
                String id = null;
                Attribute att = grid.findAttributeIgnoreCase("standard_name");
                if (att != null) {
                    vname = att.getStringValue();
                }
                vars.add(new ThreddsMetadata.Variable(name, desc, vname, units, id));
            }
        }
        Collections.sort(vars);
        return new ThreddsMetadata.VariableGroup(vocab, null, null, vars);
    }

    private ThreddsMetadata.VariableGroup extractVariables(FeatureDatasetPoint fd) {
        ArrayList<ThreddsMetadata.Variable> vars = new ArrayList<ThreddsMetadata.Variable>();
        List<VariableSimpleIF> dataVars = fd.getDataVariables();
        if (dataVars == null) {
            return null;
        }
        for (VariableSimpleIF v : dataVars) {
            String name = v.getShortName();
            String desc = v.getDescription();
            String units = v.getUnitsString();
            String vname = null;
            String id = null;
            Attribute att = v.findAttributeIgnoreCase("standard_name");
            if (att != null) {
                vname = att.getStringValue();
            }
            vars.add(new ThreddsMetadata.Variable(name, desc, vname, units, id));
        }
        Collections.sort(vars);
        return new ThreddsMetadata.VariableGroup("CF-1.0", null, null, vars);
    }

    private DateRange extractDateRange(GridDataset gridDataset) {
        DateRange maxDateRange = null;
        for (GridDataset.Gridset gridset : gridDataset.getGridsets()) {
            DateRange dateRange;
            GridCoordSystem gsys = gridset.getGeoCoordSystem();
            CoordinateAxis1DTime time1D = gsys.getTimeAxis1D();
            if (time1D != null) {
                dateRange = time1D.getDateRange();
            } else {
                CoordinateAxis time = gsys.getTimeAxis();
                if (time == null) continue;
                try {
                    DateUnit du = new DateUnit(time.getUnitsString());
                    Date minDate = du.makeDate(time.getMinValue());
                    Date maxDate = du.makeDate(time.getMaxValue());
                    dateRange = new DateRange(minDate, maxDate);
                }
                catch (Exception e) {
                    logger.warn("Illegal Date Unit " + time.getUnitsString());
                    continue;
                }
            }
            if (maxDateRange == null) {
                maxDateRange = dateRange;
                continue;
            }
            maxDateRange.extend(dateRange);
        }
        return maxDateRange;
    }

    private DateRange extractDateRange(FeatureDatasetPoint fd) {
        return fd.getDateRange();
    }

    private CalendarDateRange extractCalendarDateRange(FeatureDatasetPoint fd) {
        return fd.getCalendarDateRange();
    }

    public static CalendarDateRange extractCalendarDateRange(GridDataset gridDataset) {
        CalendarDateRange maxDateRange = null;
        for (GridDataset.Gridset gridset : gridDataset.getGridsets()) {
            CalendarDateRange dateRange;
            GridCoordSystem gsys = gridset.getGeoCoordSystem();
            CoordinateAxis1DTime time1D = gsys.getTimeAxis1D();
            if (time1D != null) {
                dateRange = time1D.getCalendarDateRange();
            } else {
                CoordinateAxis time = gsys.getTimeAxis();
                if (time == null) continue;
                try {
                    DateUnit du = new DateUnit(time.getUnitsString());
                    Date minDate = du.makeDate(time.getMinValue());
                    Date maxDate = du.makeDate(time.getMaxValue());
                    dateRange = CalendarDateRange.of(minDate, maxDate);
                }
                catch (Exception e) {
                    logger.warn("Illegal Date Unit " + time.getUnitsString());
                    continue;
                }
            }
            if (maxDateRange == null) {
                maxDateRange = dateRange;
                continue;
            }
            maxDateRange.extend(dateRange);
        }
        return maxDateRange;
    }
}

