/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.cover.impl;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.ft.cover.CoverageCS;
import ucar.nc2.ft.cover.impl.CoverageCSFactory;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.vertical.VerticalTransform;

public class CoverageCSImpl
implements CoverageCS {
    protected NetcdfDataset ds;
    protected CoordinateSystem cs;
    protected CoverageCSFactory fac;
    protected ProjectionImpl projection;
    protected ProjectionRect mapArea;

    protected CoverageCSImpl(NetcdfDataset ds, CoordinateSystem cs, CoverageCSFactory fac) {
        this.ds = ds;
        this.cs = cs;
        this.fac = fac;
        ProjectionImpl projOrig = cs.getProjection();
        if (projOrig != null) {
            this.projection = projOrig.constructCopy();
            this.projection.setDefaultMapArea(this.getBoundingBox());
        }
    }

    @Override
    public String getName() {
        return this.cs.getName();
    }

    @Override
    public List<Dimension> getDomain() {
        return this.cs.getDomain();
    }

    @Override
    public List<CoordinateAxis> getCoordinateAxes() {
        return this.fac.standardAxes;
    }

    @Override
    public List<CoordinateAxis> getOtherCoordinateAxes() {
        return this.fac.otherAxes;
    }

    @Override
    public boolean isProductSet() {
        return this.cs.isProductSet();
    }

    @Override
    public List<CoordinateTransform> getCoordinateTransforms() {
        return this.cs.getCoordinateTransforms();
    }

    @Override
    public CoordinateAxis getXHorizAxis() {
        return this.cs.isLatLon() ? this.cs.getLonAxis() : this.cs.getXaxis();
    }

    @Override
    public CoordinateAxis getYHorizAxis() {
        return this.cs.isLatLon() ? this.cs.getLatAxis() : this.cs.getYaxis();
    }

    @Override
    public boolean isLatLon() {
        return this.cs.isLatLon();
    }

    @Override
    public LatLonRect getLatLonBoundingBox() {
        return null;
    }

    @Override
    public ProjectionRect getBoundingBox() {
        if (this.mapArea == null) {
            this.makeBoundingBox();
        }
        return this.mapArea;
    }

    private void makeBoundingBox() {
        if (!(this.getXHorizAxis() instanceof CoordinateAxis1D) || !(this.getYHorizAxis() instanceof CoordinateAxis1D)) {
            CoordinateAxis xaxis = this.getXHorizAxis();
            CoordinateAxis yaxis = this.getYHorizAxis();
            this.mapArea = new ProjectionRect(xaxis.getMinValue(), yaxis.getMinValue(), xaxis.getMaxValue(), yaxis.getMaxValue());
        } else {
            CoordinateAxis1D xaxis1 = (CoordinateAxis1D)this.getXHorizAxis();
            CoordinateAxis1D yaxis1 = (CoordinateAxis1D)this.getYHorizAxis();
            this.mapArea = new ProjectionRect(xaxis1.getCoordEdge(0), yaxis1.getCoordEdge(0), xaxis1.getCoordEdge((int)xaxis1.getSize()), yaxis1.getCoordEdge((int)yaxis1.getSize()));
        }
    }

    @Override
    public ProjectionImpl getProjection() {
        return this.projection;
    }

    @Override
    public CoordinateAxis getVerticalAxis() {
        return this.fac.vertAxis;
    }

    @Override
    public boolean isZPositive() {
        CoordinateAxis vertZaxis = this.getVerticalAxis();
        if (vertZaxis == null) {
            return false;
        }
        if (vertZaxis.getPositive() != null) {
            return vertZaxis.getPositive().equalsIgnoreCase("up");
        }
        if (vertZaxis.getAxisType() == AxisType.Height) {
            return true;
        }
        return vertZaxis.getAxisType() != AxisType.Pressure;
    }

    @Override
    public VerticalCT getVerticalCT() {
        return null;
    }

    @Override
    public VerticalTransform getVerticalTransform() {
        return null;
    }

    @Override
    public boolean hasTimeAxis() {
        return this.getTimeAxis() != null;
    }

    @Override
    public CoordinateAxis getTimeAxis() {
        return this.fac.timeAxis;
    }

    @Override
    public CalendarDateRange getCalendarDateRange() {
        if (!this.hasTimeAxis()) {
            return null;
        }
        CoordinateAxis timeAxis = this.getTimeAxis();
        if (timeAxis instanceof CoordinateAxis1DTime) {
            return ((CoordinateAxis1DTime)timeAxis).getCalendarDateRange();
        }
        return null;
    }

    public String toString() {
        return this.fac.toString();
    }

    @Override
    public void show(Formatter f, boolean showCoords) {
        f.format("Coordinate System (%s)%n%n", this.getName());
    }

    @Override
    public CoverageCS.Subset makeSubsetFromLatLonRect(LatLonRect llbb) throws InvalidRangeException {
        return null;
    }

    @Override
    public CoverageCS.Subset getSubset() {
        return new SubsetImpl();
    }

    static class SubsetImpl
    implements CoverageCS.Subset {
        int level = -1;
        int time = -1;

        SubsetImpl() {
        }

        @Override
        public void setLevel(int idx) {
            this.level = idx;
        }

        @Override
        public void setTime(int idx) {
            this.time = idx;
        }

        Array readData(VariableEnhanced ve) throws IOException, InvalidRangeException {
            int n = ve.getRank();
            int[] origin = new int[n];
            int[] shape = new int[n];
            System.arraycopy(ve.getShape(), 0, shape, 0, n);
            if (this.level >= 0) {
                // empty if block
            }
            Array result = ve.read(origin, shape);
            return result.reduce();
        }
    }
}

