/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import thredds.catalog.ThreddsMetadata;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MFile;
import ucar.coord.CoordinateRuntime;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

@ThreadSafe
public class InvDatasetFcGrib
extends InvDatasetFeatureCollection {
    private static final String COLLECTION = "collection";
    private static final String BEST_DATASET = GribCollectionImmutable.Type.Best.toString();
    private static final String TWOD_DATASET = GribCollectionImmutable.Type.TwoD.toString();
    private static final String TP_DATASET = GribCollectionImmutable.Type.TP.toString();

    public InvDatasetFcGrib(InvDatasetImpl parent, FeatureCollectionConfig config) {
        super(parent, config);
        Formatter errlog = new Formatter();
        CollectionSpecParser sp = config.getCollectionSpecParser(errlog);
        this.topDirectory = sp.getRootDir();
        String errs = errlog.toString();
        if (errs.length() > 0) {
            this.logger.warn("{}: CollectionManager parse error = {} ", (Object)this.name, (Object)errs);
        }
        this.tmi.setDataType(FeatureType.GRID);
        this.state = new StateGrib(null);
        this.finish();
    }

    @Override
    public FeatureDataset getFeatureDataset() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _showStatus(Formatter f, boolean summaryOnly, String type) throws IOException {
        StateGrib localState;
        Object object = this.lock;
        synchronized (object) {
            localState = (StateGrib)this.state;
        }
        if (localState.gribCollection != null) {
            if (summaryOnly) {
                localState.gribCollection.showStatusSummary(f, type);
            } else {
                localState.gribCollection.showStatus(f);
            }
        }
    }

    @Override
    protected void updateCollection(InvDatasetFeatureCollection.State state, CollectionUpdateType force) {
        try {
            StateGrib localState = (StateGrib)state;
            GribCollectionImmutable previous = localState.gribCollection;
            GribCollectionImmutable previousLatest = localState.latest;
            localState.latest = null;
            localState.gribCollection = GribCdmIndex.openGribCollection(this.config, force, this.logger);
            if (localState.gribCollection == null) {
                this.logger.error("InvDatasetFcGrib.updateCollection failed " + this.config);
            }
            this.logger.debug("{}: GribCollection object was recreated", (Object)this.getName());
            if (previous != null) {
                previous.close();
            }
            if (previousLatest != null) {
                previousLatest.close();
            }
        }
        catch (IOException ioe) {
            this.logger.error("GribFc updateCollection", ioe);
        }
    }

    private String makeCollectionShortName(String collectionName) {
        String topCollectionName = this.config.collectionName;
        if (collectionName.equals(topCollectionName)) {
            return topCollectionName;
        }
        if (collectionName.startsWith(topCollectionName)) {
            return this.getName() + collectionName.substring(topCollectionName.length());
        }
        return collectionName;
    }

    private InvDatasetImpl makeDatasetFromCollection(boolean isTop, InvCatalogImpl parentCatalog, String parentCollectionName, GribCollectionImmutable fromGc) throws IOException {
        if (fromGc == null) {
            throw new FileNotFoundException("Grib Collection '" + this.getCollectionName() + "' does not exist or is empty");
        }
        String dsName = isTop ? this.getName() : this.makeCollectionShortName(fromGc.getName());
        InvDatasetImpl result = new InvDatasetImpl(this);
        result.setName(dsName);
        result.setParent(null);
        InvDatasetImpl parent = (InvDatasetImpl)this.getParent();
        if (parent != null) {
            result.transferMetadata(parent, true);
        }
        String tpath = this.getPath() + "/" + COLLECTION;
        ThreddsMetadata tmi = result.getLocalMetadataInheritable();
        tmi.addVariableMapLink(this.makeMetadataLink(tpath, "?metadata=variableMap"));
        tmi.setServiceName("VirtualServices");
        tmi.setDataFormatType(fromGc.isGrib1 ? DataFormatType.GRIB1 : DataFormatType.GRIB2);
        tmi.addProperties(fromGc.getGlobalAttributes());
        String pathStart = parentCollectionName == null ? this.getPath() : this.getPath() + "/" + parentCollectionName;
        for (GribCollectionImmutable.Dataset ds : fromGc.getDatasets()) {
            boolean onlyOneFile;
            boolean isSingleGroup = ds.getGroupsSize() == 1;
            Iterable<GribCollectionImmutable.GroupGC> groups = ds.getGroups();
            if (ds.getType() == GribCollectionImmutable.Type.TwoD) {
                if (!this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.TwoD)) continue;
                InvDatasetImpl twoD = new InvDatasetImpl(this, this.getDatasetNameTwoD(result.getName()));
                String path = pathStart + "/" + TWOD_DATASET;
                twoD.setUrlPath(path);
                twoD.tm.addDocumentation("summary", "Two time dimensions: reference and forecast; full access to all GRIB records");
                result.addDataset(twoD);
                this.makeDatasetsFromGroups(twoD, groups, isSingleGroup);
                continue;
            }
            if (ds.getType() == GribCollectionImmutable.Type.Best) {
                if (!this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Best)) continue;
                InvDatasetImpl best = new InvDatasetImpl(this, this.getDatasetNameBest(result.getName()));
                String path = pathStart + "/" + BEST_DATASET;
                best.setUrlPath(path);
                best.tm.addDocumentation("summary", "Single time dimension: for each forecast time, use GRIB record with smallest offset from reference time");
                result.addDataset(best);
                this.makeDatasetsFromGroups(best, groups, isSingleGroup);
                continue;
            }
            if (ds.getType() == GribCollectionImmutable.Type.TP) {
                InvDatasetImpl tp = new InvDatasetImpl(this, this.getDatasetNameTP(result.getName()));
                String path = pathStart + "/" + TP_DATASET;
                tp.setUrlPath(path);
                tp.tm.addDocumentation("summary", "Multiple reference, single time Grib Partition");
                result.addDataset(tp);
                this.makeDatasetsFromGroups(tp, groups, isSingleGroup);
                continue;
            }
            boolean isFilePartition = this.config.ptype == FeatureCollectionConfig.PartitionType.file;
            boolean bl = onlyOneFile = isFilePartition && fromGc.getFiles().size() == 1;
            if (onlyOneFile) {
                parentCatalog.addService(this.orgService);
                tmi.setServiceName(this.orgService.getName());
            }
            result.setUrlPath(pathStart);
            if (ds.getType() == GribCollectionImmutable.Type.SRC) {
                CoordinateRuntime runCoord = fromGc.getMasterRuntime();
                assert (runCoord.getSize() == 1);
                CalendarDate runtime = runCoord.getFirstDate();
                result.tm.addDocumentation("summary", "Single reference time Grib Collection");
                result.tmi.addDocumentation("Reference Time", runtime.toString());
            } else if (ds.getType() == GribCollectionImmutable.Type.MRSTC) {
                result.tm.addDocumentation("summary", "Multiple reference time Grib Collection");
            }
            this.makeDatasetsFromGroups(result, groups, isSingleGroup);
            if (onlyOneFile || !this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Files)) continue;
            this.addFileDatasets(parentCatalog, result, fromGc);
        }
        if (fromGc instanceof PartitionCollectionImmutable) {
            if (this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Latest) && parentCollectionName == null) {
                InvDatasetImpl ds = new InvDatasetImpl(this, this.getDatasetNameLatest(result.getName()));
                ds.setUrlPath("latest.xml");
                ds.setServiceName("latest");
                ds.finish();
                result.addDataset(ds);
            }
            PartitionCollectionImmutable pc = (PartitionCollectionImmutable)fromGc;
            for (PartitionCollectionImmutable.Partition partition : pc.getPartitionsSorted()) {
                InvDatasetImpl partDs = this.makeDatasetFromPartition(this, parentCollectionName, partition, pc.isPartitionOfPartitions());
                result.addDataset(partDs);
            }
        }
        result.finish();
        return result;
    }

    private void makeDatasetsFromGroups(InvDatasetImpl parent, Iterable<GribCollectionImmutable.GroupGC> groups, boolean isSingleGroup) {
        for (GribCollectionImmutable.GroupGC group : groups) {
            InvDatasetImpl ds = isSingleGroup ? parent : new InvDatasetImpl(this, group.getDescription());
            String groupId = isSingleGroup ? null : group.getId();
            String dpath = isSingleGroup ? parent.getUrlPath() : parent.getUrlPath() + "/" + groupId;
            ds.setID(dpath);
            ds.setUrlPath(dpath);
            if (!isSingleGroup) {
                parent.addDataset(ds);
            }
            ds.tmi.setGeospatialCoverage(this.extractGeospatial(group));
            ds.tmi.setTimeCoverage(group.makeCalendarDateRange());
            ds.tmi.addVariableMapLink(this.makeMetadataLink(dpath, "?metadata=variableMap"));
        }
        if (!isSingleGroup) {
            parent.setUrlPath(null);
        }
    }

    private InvDatasetImpl makeDatasetFromPartition(InvDatasetImpl parent, String parentCollectionName, PartitionCollectionImmutable.Partition partition, boolean isPofP) throws IOException {
        String dsName = this.makeCollectionShortName(partition.getName());
        String startPath = parentCollectionName == null ? this.getPath() : this.getPath() + "/" + parentCollectionName;
        String dpath = startPath + "/" + partition.getName();
        InvCatalogRef result = new InvCatalogRef(parent, dsName, InvDatasetFcGrib.buildCatalogServiceHref(dpath));
        result.setID(dpath);
        result.setUrlPath(dpath);
        result.setServiceName("VirtualServices");
        return result;
    }

    protected void addFileDatasets(InvCatalogImpl parentCatalog, InvDatasetImpl parent, GribCollectionImmutable fromGc) throws IOException {
        ArrayList<MFile> mfiles = new ArrayList<MFile>(fromGc.getFiles());
        Collections.sort(mfiles);
        InvDatasetImpl filesParent = new InvDatasetImpl(this, "Raw Files");
        filesParent.tmi.setServiceName(Download_Services);
        parent.addDataset(filesParent);
        if (parentCatalog != null) {
            parentCatalog.addService(this.makeDownloadService());
        }
        for (MFile mfile : mfiles) {
            InvDatasetImpl ds = new InvDatasetImpl(this, mfile.getName());
            String lpath = parent.getUrlPath() + "/" + "files" + "/" + mfile.getName();
            ds.setUrlPath(lpath);
            ds.setID(lpath);
            ds.tm.setDataSize(mfile.getLength());
            ds.finish();
            filesParent.addDataset(ds);
        }
    }

    @Override
    protected InvCatalogImpl makeCatalogTop(URI catURI, InvDatasetFeatureCollection.State localState) throws IOException, URISyntaxException {
        InvCatalogImpl parentCatalog = (InvCatalogImpl)this.getParentCatalog();
        InvCatalogImpl mainCatalog = new InvCatalogImpl(this.getName(), parentCatalog.getVersion(), catURI);
        if (this.config.gribConfig.hasDatasetType(FeatureCollectionConfig.GribDatasetType.Latest)) {
            mainCatalog.addService(InvService.latest);
        }
        mainCatalog.addDataset(((StateGrib)localState).top);
        mainCatalog.addService(this.virtualService);
        mainCatalog.finish();
        return mainCatalog;
    }

    @Override
    public InvCatalogImpl makeCatalog(String match, String reqPath, URI catURI) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        if (localState == null) {
            return null;
        }
        try {
            if (match == null || match.length() == 0) {
                return this.makeCatalogTop(catURI, localState);
            }
            if (localState.gribCollection instanceof PartitionCollectionImmutable) {
                String[] paths = match.split("/");
                PartitionCollectionImmutable pc = (PartitionCollectionImmutable)localState.gribCollection;
                return this.makeCatalogFromPartition(pc, paths, 0, catURI);
            }
        }
        catch (Exception e) {
            this.logger.error("Error making catalog for " + this.configPath, e);
        }
        return null;
    }

    private InvCatalogImpl makeCatalogFromPartition(PartitionCollectionImmutable pc, String[] paths, int idx, URI catURI) throws IOException {
        if (paths.length < idx + 1) {
            return null;
        }
        PartitionCollectionImmutable.Partition pcp = pc.getPartitionByName(paths[idx]);
        if (pcp == null) {
            return null;
        }
        try (GribCollectionImmutable gc = pcp.getGribCollection();){
            PartitionCollectionImmutable pcNested;
            PartitionCollectionImmutable.Partition pcpNested;
            if (paths.length > idx + 1 && gc instanceof PartitionCollectionImmutable && (pcpNested = (pcNested = (PartitionCollectionImmutable)gc).getPartitionByName(paths[idx + 1])) != null) {
                InvCatalogImpl invCatalogImpl = this.makeCatalogFromPartition(pcNested, paths, idx + 1, catURI);
                return invCatalogImpl;
            }
            int i = 0;
            StringBuilder parentName = new StringBuilder();
            for (String s2 : paths) {
                if (i++ > 0) {
                    parentName.append("/");
                }
                parentName.append(s2);
            }
            InvCatalogImpl invCatalogImpl = this.makeCatalogFromCollection(gc, parentName.toString(), catURI);
            return invCatalogImpl;
        }
    }

    private InvCatalogImpl makeCatalogFromCollection(GribCollectionImmutable fromGc, String parentCollectionName, URI catURI) throws IOException {
        InvCatalogImpl result = new InvCatalogImpl(this.makeCollectionShortName(fromGc.getName()), this.getParentCatalog().getVersion(), catURI);
        result.addService(this.virtualService);
        InvDatasetImpl ds = this.makeDatasetFromCollection(false, result, parentCollectionName, fromGc);
        result.addDataset(ds);
        result.finish();
        return result;
    }

    @Override
    protected void makeDatasetTop(InvDatasetFeatureCollection.State state) throws IOException {
        StateGrib localState = (StateGrib)state;
        localState.top = this.makeDatasetFromCollection(true, null, null, localState.gribCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvCatalogImpl makeLatest(String matchPath, String reqPath, URI catURI) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        if (!(localState.gribCollection instanceof PartitionCollectionImmutable)) {
            return null;
        }
        PartitionCollectionImmutable pc = (PartitionCollectionImmutable)localState.gribCollection;
        if (localState.latest == null) {
            ArrayList<String> paths = new ArrayList<String>();
            GribCollectionImmutable latest = pc.getLatestGribCollection(paths);
            if (latest == null) {
                return null;
            }
            latest.close();
            Formatter f = new Formatter();
            int count = 0;
            for (String p : paths) {
                if (count++ > 0) {
                    f.format("/", new Object[0]);
                }
                f.format("%s", p);
            }
            Object object = this.lock;
            synchronized (object) {
                localState.latest = latest;
                localState.latestPath = f.toString();
            }
        }
        return this.makeCatalogFromCollection(localState.latest, localState.latestPath, catURI);
    }

    private ThreddsMetadata.GeospatialCoverage extractGeospatial(Iterable<GribCollectionImmutable.GroupGC> groups) {
        ThreddsMetadata.GeospatialCoverage gcAll = null;
        for (GribCollectionImmutable.GroupGC group : groups) {
            ThreddsMetadata.GeospatialCoverage gc = this.extractGeospatial(group);
            if (gcAll == null) {
                gcAll = gc;
                continue;
            }
            gcAll.extend(gc);
        }
        return gcAll;
    }

    private ThreddsMetadata.GeospatialCoverage extractGeospatial(GribCollectionImmutable.GroupGC group) {
        GdsHorizCoordSys gdsCoordSys = group.getGdsHorizCoordSys();
        LatLonRect llbb = GridCoordSys.getLatLonBoundingBox(gdsCoordSys.proj, gdsCoordSys.getStartX(), gdsCoordSys.getStartY(), gdsCoordSys.getEndX(), gdsCoordSys.getEndY());
        ThreddsMetadata.GeospatialCoverage gc = new ThreddsMetadata.GeospatialCoverage();
        if (llbb != null) {
            gc.setBoundingBox(llbb);
        }
        if (gdsCoordSys.isLatLon()) {
            gc.setLonResolution(gdsCoordSys.dx);
            gc.setLatResolution(gdsCoordSys.dy);
        }
        return gc;
    }

    private CalendarDateRange extractCalendarDateRange(Iterable<GribCollectionImmutable.GroupGC> groups) {
        CalendarDateRange gcAll = null;
        for (GribCollectionImmutable.GroupGC group : groups) {
            CalendarDateRange gc = group.makeCalendarDateRange();
            if (gcAll == null) {
                gcAll = gc;
                continue;
            }
            gcAll.extend(gc);
        }
        return gcAll;
    }

    protected String getDatasetNameLatest(String dsName) {
        if (this.config.gribConfig != null && this.config.gribConfig.latestNamer != null) {
            return this.config.gribConfig.latestNamer;
        }
        return "Latest Collection for " + dsName;
    }

    protected String getDatasetNameBest(String dsName) {
        if (this.config.gribConfig != null && this.config.gribConfig.bestNamer != null) {
            return this.config.gribConfig.bestNamer;
        }
        return "Best " + dsName + " Time Series";
    }

    protected String getDatasetNameTP(String dsName) {
        return "Full Collection Dataset";
    }

    protected String getDatasetNameTwoD(String dsName) {
        return "Full Collection (Reference / Forecast Time) Dataset";
    }

    @Override
    public File getFile(String remaining) {
        try {
            StateGrib localState = (StateGrib)this.checkState();
            int pos = remaining.lastIndexOf("/");
            final String filename = pos >= 0 && remaining.length() > 1 ? remaining.substring(pos + 1) : remaining;
            MFile result = (MFile)this.findDataset(remaining, localState.gribCollection, new DatasetCreator(){

                @Override
                public Object obtain(GribCollectionImmutable gc, GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group) throws IOException {
                    return gc.findMFileByName(filename);
                }
            });
            if (result == null) {
                return null;
            }
            return new File(result.getPath());
        }
        catch (IOException iow) {
            return null;
        }
    }

    @Override
    public GridDataset getGridDataset(String matchPath) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        return (GridDataset)this.findDataset(matchPath, localState.gribCollection, new DatasetCreator(){

            @Override
            public Object obtain(GribCollectionImmutable gc, GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group) throws IOException {
                return gc.getGridDataset(ds, group, null, InvDatasetFcGrib.this.config, null, InvDatasetFcGrib.this.logger);
            }
        });
    }

    @Override
    public NetcdfDataset getNetcdfDataset(String matchPath) throws IOException {
        StateGrib localState = (StateGrib)this.checkState();
        return (NetcdfDataset)this.findDataset(matchPath, localState.gribCollection, new DatasetCreator(){

            @Override
            public Object obtain(GribCollectionImmutable gc, GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group) throws IOException {
                return gc.getNetcdfDataset(ds, group, null, InvDatasetFcGrib.this.config, null, InvDatasetFcGrib.this.logger);
            }
        });
    }

    private Object findDataset(String matchPath, GribCollectionImmutable topCollection, DatasetCreator visit) throws IOException {
        String[] paths = matchPath.split("/");
        List<Object> pathList = paths.length < 1 ? new ArrayList() : Arrays.asList(paths);
        DatasetAndGroup dg = this.findDatasetAndGroup(pathList, topCollection);
        if (dg != null) {
            return visit.obtain(topCollection, dg.ds, dg.group);
        }
        if (!(topCollection instanceof PartitionCollectionImmutable)) {
            return null;
        }
        PartitionCollectionImmutable pc = (PartitionCollectionImmutable)topCollection;
        return this.findDatasetPartition(visit, pc, pathList);
    }

    private DatasetAndGroup findDatasetAndGroup(List<String> paths, GribCollectionImmutable gc) {
        if (paths.size() < 1 || paths.get(0).length() == 0) {
            GribCollectionImmutable.Dataset ds = gc.getDataset(0);
            GribCollectionImmutable.GroupGC dg = ds.getGroup(0);
            return new DatasetAndGroup(ds, dg);
        }
        GribCollectionImmutable.Dataset ds = gc.getDatasetByTypeName(paths.get(0));
        if (ds != null) {
            boolean isSingleGroup;
            boolean bl = isSingleGroup = ds.getGroupsSize() == 1;
            if (paths.size() == 1) {
                if (!isSingleGroup) {
                    return null;
                }
                GribCollectionImmutable.GroupGC g2 = ds.getGroup(0);
                return new DatasetAndGroup(ds, g2);
            }
            if (paths.size() == 2) {
                String groupName = paths.get(1);
                GribCollectionImmutable.GroupGC g3 = ds.findGroupById(groupName);
                if (g3 != null) {
                    return new DatasetAndGroup(ds, g3);
                }
                return null;
            }
        }
        if (paths.size() == 1) {
            String groupName = paths.get(0);
            ds = gc.getDataset(0);
            GribCollectionImmutable.GroupGC g4 = ds.findGroupById(groupName);
            if (g4 != null) {
                return new DatasetAndGroup(ds, g4);
            }
        }
        return null;
    }

    private Object findDatasetPartition(DatasetCreator visit, PartitionCollectionImmutable outerPartition, List<String> pathList) throws IOException {
        int n = pathList.size();
        if (pathList.size() < 1) {
            return null;
        }
        PartitionCollectionImmutable.Partition pcp = outerPartition.getPartitionByName(pathList.get(0));
        if (pcp == null) {
            DatasetAndGroup dg = this.findDatasetAndGroup(pathList, outerPartition);
            if (dg != null) {
                return visit.obtain(outerPartition, dg.ds, dg.group);
            }
            return null;
        }
        try (GribCollectionImmutable gc = pcp.getGribCollection();){
            if (gc instanceof PartitionCollectionImmutable) {
                PartitionCollectionImmutable pcNested = (PartitionCollectionImmutable)gc;
                Object object = this.findDatasetPartition(visit, pcNested, pathList.subList(1, n));
                return object;
            }
            DatasetAndGroup dg = this.findDatasetAndGroup(pathList.subList(1, n), gc);
            if (dg != null) {
                Object object = visit.obtain(gc, dg.ds, dg.group);
                return object;
            }
            GribCollectionImmutable.Dataset ds = gc.getDataset(0);
            GribCollectionImmutable.GroupGC group = ds.getGroup(0);
            Object object = visit.obtain(gc, ds, group);
            return object;
        }
    }

    private static interface DatasetCreator {
        public Object obtain(GribCollectionImmutable var1, GribCollectionImmutable.Dataset var2, GribCollectionImmutable.GroupGC var3) throws IOException;
    }

    private static class DatasetAndGroup {
        GribCollectionImmutable.Dataset ds;
        GribCollectionImmutable.GroupGC group;

        private DatasetAndGroup(GribCollectionImmutable.Dataset ds, GribCollectionImmutable.GroupGC group) {
            this.ds = ds;
            this.group = group;
        }
    }

    protected class StateGrib
    extends InvDatasetFeatureCollection.State {
        GribCollectionImmutable gribCollection;
        GribCollectionImmutable latest;
        String latestPath;

        protected StateGrib(StateGrib from) {
            super(from);
            if (from != null) {
                this.gribCollection = from.gribCollection;
                this.latest = from.latest;
                this.latestPath = from.latestPath;
            }
        }

        @Override
        public InvDatasetFeatureCollection.State copy() {
            return new StateGrib(this);
        }
    }
}

