/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class UnidataTdsDataPathRemapper {
    private static HashMap<String, Remapper> map;

    private void initMap() {
        List<UrlRemapperBean> beans2 = this.readUrlRemapFile("resources/thredds/4p2to4p3Remap.xml");
        map = this.makeMapBeans(beans2);
    }

    public List<String> getMappedUrlPaths(String oldUrlPath) {
        return this.getMappedUrlPaths(oldUrlPath, null);
    }

    public List<String> getMappedUrlPaths(String oldUrlPath, String urlType) {
        Remapper mbean;
        ArrayList<String> result = new ArrayList<String>();
        if (map == null) {
            this.initMap();
        }
        if ((mbean = map.get(oldUrlPath)) != null && mbean.newUrl != null) {
            result.add(mbean.newUrl);
            return result;
        }
        if (urlType != null && mbean != null && mbean.newUrls.size() > 0) {
            for (UrlRemapperBean r : mbean.newUrls) {
                if (!r.getUrlType().equals(urlType)) continue;
                result.add(r.newUrlPath);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<UrlRemapperBean> readUrlRemapFile(String path) {
        ArrayList<UrlRemapperBean> beans2 = new ArrayList<UrlRemapperBean>(1000);
        ClassLoader cl = this.getClass().getClassLoader();
        try (InputStream is = cl.getResourceAsStream(path);){
            if (is == null) {
                System.out.println("Cant read file " + path);
                List<UrlRemapperBean> list = null;
                return list;
            }
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            List<Element> dsElems = root.getChildren("urlMap");
            for (Element dsElem : dsElems) {
                String dsType = dsElem.getAttributeValue("type");
                List<Element> params = dsElem.getChildren("urlPath");
                for (Element elem : params) {
                    String oldUrlPath = elem.getAttributeValue("oldUrlPath");
                    String newUrlPath = elem.getAttributeValue("newUrlPath");
                    beans2.add(new UrlRemapperBean(dsType, oldUrlPath, newUrlPath));
                }
            }
            ArrayList<UrlRemapperBean> arrayList = beans2;
            return arrayList;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashMap<String, Remapper> makeMapBeans(List<UrlRemapperBean> vbeans) {
        HashMap<String, Remapper> map = new HashMap<String, Remapper>(200);
        if (vbeans != null) {
            for (UrlRemapperBean vbean : vbeans) {
                Remapper mbean = map.get(vbean.getOldUrlPath());
                if (mbean == null) {
                    mbean = new Remapper(vbean.getOldUrlPath());
                    map.put(vbean.getOldUrlPath(), mbean);
                }
                mbean.add(vbean);
            }
            for (Remapper rmap : map.values()) {
                rmap.finish();
            }
        }
        return map;
    }

    private static class Remapper {
        String oldUrl;
        String newUrl;
        List<UrlRemapperBean> newUrls = new ArrayList<UrlRemapperBean>();
        HashMap<String, UrlRemapperBean> newUrlMap = new HashMap();

        public Remapper() {
        }

        public Remapper(String oldUrl) {
            this.oldUrl = oldUrl;
        }

        void add(UrlRemapperBean vbean) {
            this.newUrlMap.put(vbean.getNewUrlPath(), vbean);
            this.newUrls.add(vbean);
        }

        void finish() {
            if (this.newUrlMap.values().size() == 1) {
                this.newUrl = this.newUrls.get(0).getNewUrlPath();
            }
        }

        public int getCount() {
            return this.newUrls.size();
        }

        public String getOldUrl() {
            return this.oldUrl;
        }
    }

    public static class UrlRemapperBean
    implements Comparable<UrlRemapperBean> {
        String urlType;
        String oldUrlPath;
        String newUrlPath;

        public UrlRemapperBean() {
        }

        public UrlRemapperBean(String dsType, String oldUrlPath, String newUrlPath) {
            this.urlType = dsType;
            this.oldUrlPath = oldUrlPath;
            this.newUrlPath = newUrlPath;
        }

        public String getUrlType() {
            return this.urlType;
        }

        public String getOldUrlPath() {
            return this.oldUrlPath;
        }

        public String getNewUrlPath() {
            return this.newUrlPath;
        }

        @Override
        public int compareTo(UrlRemapperBean o) {
            return this.newUrlPath.compareTo(o.getNewUrlPath());
        }
    }
}

