/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataScalar;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.VariableSimpleImpl;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;

public class WriterCFProfileCollection
extends CFPointWriter {
    protected Structure profileStruct;
    private Map<String, Variable> featureVarMap = new HashMap<String, Variable>();
    private boolean headerDone = false;
    private int profileRecno = 0;
    private int obsRecno = 0;

    public WriterCFProfileCollection(String fileOut, List<Attribute> globalAtts, List<VariableSimpleIF> dataVars, List<Variable> extra, DateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, extra, timeUnit, altUnits, config);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.profile.name()));
    }

    public int writeProfile(ProfileFeature profile2) throws IOException {
        profile2.resetIteration();
        int count = 0;
        while (profile2.hasNext()) {
            PointFeature pf = profile2.next();
            if (!this.headerDone) {
                if (this.id_strlen == 0) {
                    this.id_strlen = profile2.getName().length() * 2;
                }
                this.writeHeader(profile2, pf);
                this.headerDone = true;
            }
            this.writeObsData(pf);
            ++count;
        }
        this.writeProfileData(profile2, count);
        return count;
    }

    private void writeHeader(ProfileFeature profile2, PointFeature obs) throws IOException {
        Formatter coordNames = new Formatter().format("%s %s %s", "profileTime", "latitude", "longitude");
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        if (this.useAlt) {
            coords.add(VariableSimpleImpl.makeScalar(this.altitudeCoordinateName, "obs altitude", this.altUnits, DataType.DOUBLE).add(new Attribute("standard_name", "altitude")).add(new Attribute("positive", CF1Convention.getZisPositive(this.altitudeCoordinateName, this.altUnits))));
            coordNames.format(" %s", this.altitudeCoordinateName);
        }
        super.writeHeader(coords, profile2.getFeatureData(), obs.getFeatureData(), coordNames.toString());
    }

    @Override
    protected void makeFeatureVariables(StructureData featureData, boolean isExtended) throws IOException {
        Dimension profileDim = this.writer.addDimension(null, "profile", this.nfeatures);
        ArrayList<VariableSimpleIF> profileVars = new ArrayList<VariableSimpleIF>();
        profileVars.add(VariableSimpleImpl.makeScalar("latitude", "profile latitude", "degrees_north", DataType.DOUBLE));
        profileVars.add(VariableSimpleImpl.makeScalar("longitude", "profile longitude", "degrees_east", DataType.DOUBLE));
        profileVars.add(VariableSimpleImpl.makeString("profileId", "profile identifier", null, this.id_strlen).add(new Attribute("cf_role", "profile_id")));
        profileVars.add(VariableSimpleImpl.makeScalar("nobs", "number of obs for this profile", null, DataType.INT).add(new Attribute("sample_dimension", "obs")));
        profileVars.add(VariableSimpleImpl.makeScalar("profileTime", "nominal time of profile", this.timeUnit.getUnitsString(), DataType.DOUBLE));
        for (StructureMembers.Member m3 : featureData.getMembers()) {
            VariableSimpleIF dv = this.getDataVar(m3.getName());
            if (dv == null) continue;
            profileVars.add(dv);
        }
        if (isExtended) {
            this.profileStruct = (Structure)this.writer.addVariable(null, "profile", DataType.STRUCTURE, "profile");
            this.addCoordinatesExtended(this.profileStruct, profileVars);
        } else {
            this.addCoordinatesClassic(profileDim, profileVars, this.featureVarMap);
        }
    }

    public void writeProfileData(ProfileFeature profile2, int nobs) throws IOException {
        this.trackBB(profile2.getLatLon(), CalendarDate.of(profile2.getTime()));
        StructureDataScalar profileCoords = new StructureDataScalar("Coords");
        profileCoords.addMember("latitude", null, null, DataType.DOUBLE, false, profile2.getLatLon().getLatitude());
        profileCoords.addMember("longitude", null, null, DataType.DOUBLE, false, profile2.getLatLon().getLongitude());
        if (profile2.getTime() != null) {
            profileCoords.addMember("profileTime", null, null, DataType.DOUBLE, false, this.timeUnit.makeValue(profile2.getTime()));
        }
        profileCoords.addMemberString("profileId", null, null, profile2.getName().trim(), this.id_strlen);
        profileCoords.addMember("nobs", null, null, DataType.INT, false, nobs);
        StructureData profileData = profile2.getFeatureData();
        StructureDataComposite sdall = new StructureDataComposite();
        sdall.add(profileCoords);
        sdall.add(profileData);
        this.profileRecno = super.writeStructureData(this.profileRecno, this.profileStruct, sdall, this.featureVarMap);
    }

    public void writeObsData(PointFeature pf) throws IOException {
        StructureDataScalar coords = new StructureDataScalar("Coords");
        if (this.useAlt) {
            coords.addMember(this.altitudeCoordinateName, null, null, DataType.DOUBLE, false, pf.getLocation().getAltitude());
        }
        StructureDataComposite sdall = new StructureDataComposite();
        sdall.add(coords);
        sdall.add(pf.getFeatureData());
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

