/*
 * Decompiled with CFR 0.152.
 */
package thredds.monitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import thredds.inventory.bdb.MetadataManager;
import thredds.monitor.FmrcCacheMonitor;

public class FmrcCacheMonitorImpl
implements FmrcCacheMonitor {
    @Override
    public List<String> getCachedCollections() {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : MetadataManager.getCollectionNames()) {
            result.add(name);
        }
        return result;
    }

    public String getCacheLocation() {
        return MetadataManager.getCacheLocation();
    }

    public void getCacheStatistics(Formatter f) {
        MetadataManager.showEnvStats((Formatter)f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFilesInCollection(String collectionName) {
        ArrayList<String> result = new ArrayList<String>();
        MetadataManager mm = null;
        try {
            mm = new MetadataManager(collectionName);
            for (MetadataManager.KeyValue data : mm.getContent()) {
                result.add(data.key);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (mm != null) {
                mm.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCachedFile(String collectionName, String name) {
        MetadataManager mm = null;
        try {
            mm = new MetadataManager(collectionName);
            String string = mm.get(name);
            return string;
        }
        catch (Throwable e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (mm != null) {
                mm.close();
            }
        }
    }

    public void deleteCollection(String collectionName) throws Exception {
        MetadataManager.deleteCollection((String)collectionName);
    }

    public void sync() {
        MetadataManager.sync();
    }
}

