/*
 * Decompiled with CFR 0.152.
 */
package thredds.server;

import java.io.FileNotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import thredds.servlet.ServletUtil;
import thredds.util.TdsPathUtils;

public abstract class AbstractController {
    protected abstract String getControllerPath();

    protected abstract String[] getEndings();

    public String getDatasetPath(HttpServletRequest req) {
        String path = TdsPathUtils.extractPath(req, this.getControllerPath());
        for (String ending : this.getEndings()) {
            if (!path.endsWith(ending)) continue;
            int len = path.length() - ending.length();
            path = path.substring(0, len);
            break;
        }
        return path;
    }

    public String getAbsolutePath(HttpServletRequest req) {
        return ServletUtil.getRequestServer(req) + req.getContextPath() + req.getServletPath();
    }

    @ExceptionHandler(value={FileNotFoundException.class})
    public ResponseEntity<String> handle(FileNotFoundException ncsse) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)("FileNotFoundException exception handled : " + ncsse.getMessage()), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    public ResponseEntity<String> handle(UnsupportedOperationException ex) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)("UnsupportedOperationException exception handled : " + ex.getMessage()), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<String> handle(Throwable ex) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.error("uncaught exception", ex);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)("Throwable exception handled : " + ex.getMessage()), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

