/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalogservice;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.util.DeepCopyUtils;
import thredds.server.catalogservice.CatalogServiceUtils;
import thredds.server.catalogservice.Command;
import thredds.server.catalogservice.RemoteCatalogRequest;
import thredds.server.config.HtmlConfig;
import thredds.server.config.TdsContext;
import thredds.servlet.HtmlWriter;
import thredds.servlet.ThreddsConfig;

@Component
@RequestMapping(value={"/remoteCatalogService", "/remoteCatalogValidation.html"})
public class RemoteCatalogServiceController {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TdsContext tdsContext;
    @Autowired
    private HtmlWriter htmlWriter;

    @RequestMapping(value={"**"})
    protected ModelAndView handleAll(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HtmlConfig htmlConfig = this.tdsContext.getHtmlConfig();
        try {
            InvCatalogImpl catalog;
            boolean allowRemote = ThreddsConfig.getBoolean("CatalogServices.allowRemote", false);
            if (!allowRemote) {
                response.sendError(403, "Catalog services not supported for remote catalogs.");
                return null;
            }
            if (request.getServletPath().equals("/remoteCatalogValidation.html")) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                htmlConfig.addHtmlConfigInfoToModel(model);
                return new ModelAndView("/thredds/server/catalogservice/validationForm", model);
            }
            BindingResult bindingResult = CatalogServiceUtils.bindAndValidateRemoteCatalogRequest(request);
            if (bindingResult.hasErrors()) {
                StringBuilder msg = new StringBuilder("Bad request");
                List oeList = bindingResult.getAllErrors();
                for (ObjectError e : oeList) {
                    msg.append(": ").append(e.getDefaultMessage() != null ? e.getDefaultMessage() : e.toString());
                }
                this.log.info("handleRequestInternal(): " + msg);
                response.sendError(400, msg.toString());
                return null;
            }
            RemoteCatalogRequest catalogServiceRequest = (RemoteCatalogRequest)bindingResult.getTarget();
            URI uri = catalogServiceRequest.getCatalogUri();
            InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory((boolean)true);
            try {
                catalog = fac.readXML(uri);
            }
            catch (Throwable t) {
                String msg = "Error reading catalog [" + uri + "]: " + t.getMessage();
                this.log.error("handleRequestInternal(): " + msg);
                response.sendError(400, msg);
                return null;
            }
            if (catalog == null) {
                String msg = "Failed to read catalog [" + uri + "].";
                this.log.error("handleRequestInternal(): " + msg);
                response.sendError(400, msg);
                return null;
            }
            StringBuilder validateMess = new StringBuilder();
            boolean verbose = catalogServiceRequest.isVerbose();
            catalog.check(validateMess, verbose);
            if (catalog.hasFatalError()) {
                response.setHeader("Validate", "FAIL");
                return CatalogServiceUtils.constructValidationErrorModelAndView(uri, validateMess.toString(), htmlConfig);
            }
            response.setHeader("Validate", "OK");
            if (catalogServiceRequest.getCommand().equals((Object)Command.SHOW)) {
                this.htmlWriter.writeCatalog(request, response, catalog, false);
                return null;
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.SUBSET)) {
                String datasetId = catalogServiceRequest.getDataset();
                InvDataset dataset = catalog.findDatasetByID(datasetId);
                if (dataset == null) {
                    String msg = "Did not find dataset [" + HtmlUtils.htmlEscape((String)datasetId) + "] in catalog [" + uri + "].";
                    this.log.info("handleRequestInternal(): " + msg);
                    response.sendError(400, msg);
                    return null;
                }
                if (catalogServiceRequest.isHtmlView()) {
                    this.htmlWriter.showDataset(uri.toString(), (InvDatasetImpl)dataset, request, response, false);
                    return null;
                }
                InvCatalog subsetCat = DeepCopyUtils.subsetCatalogOnDataset((InvCatalog)catalog, (InvDataset)dataset);
                return new ModelAndView("threddsInvCatXmlView", "catalog", (Object)subsetCat);
            }
            if (catalogServiceRequest.getCommand().equals((Object)Command.VALIDATE)) {
                return CatalogServiceUtils.constructValidationMessageModelAndView(uri, validateMess.toString(), htmlConfig);
            }
            String msg = "Unsupported request command [" + (Object)((Object)catalogServiceRequest.getCommand()) + "].";
            this.log.error("handleRequestInternal(): " + msg + " -- NOTE: Should have been caught on input validation.");
            response.sendError(400, msg);
            return null;
        }
        catch (IOException e) {
            this.log.error("handleRequestInternal(): Trouble writing to response.", (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            this.log.error("handleRequestInternal(): Problem handling request.", e);
            if (!response.isCommitted()) {
                response.sendError(500);
            }
            return null;
        }
    }
}

