/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.cdmremote.CollectionBean;
import thredds.servlet.DatasetHandler;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.TimeDuration;

public class CollectionManager {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private HashMap<String, CollectionBean> collectionDatasets = new HashMap();

    public void setCollections(List<CollectionBean> beans) {
        for (CollectionBean bean : beans) {
            this.collectionDatasets.put(bean.getPath(), bean);
        }
    }

    public FeatureDatasetPoint getFeatureCollectionDataset(String uri, String path) throws IOException {
        CollectionBean config = this.collectionDatasets.get(path);
        if (config == null) {
            return null;
        }
        Formatter errlog = new Formatter();
        FeatureDatasetPoint fd = (FeatureDatasetPoint)CompositeDatasetFactory.factory((String)uri, (FeatureType)FeatureType.getType((String)config.getFeatureType()), null, (Formatter)errlog);
        if (fd == null) {
            this.log.error("Error opening CompositeDataset path = " + path + "  errlog = ", (Object)errlog);
            return null;
        }
        DateRange dr = fd.getDateRange();
        if (dr != null && config.getResolution() != null) {
            try {
                dr.setResolution(new TimeDuration(config.getResolution()));
            }
            catch (ParseException e) {
                this.log.error("TimeDuration incorrect= " + config.getResolution(), (Throwable)e);
            }
        }
        return fd;
    }

    public FeatureDatasetPoint getFeatureDataset(HttpServletRequest req, HttpServletResponse res, String path) throws IOException {
        NetcdfDataset ncd = null;
        try {
            Formatter errlog;
            NetcdfFile ncfile = DatasetHandler.getNetcdfFile(req, res, path);
            if (ncfile == null) {
                res.setStatus(404);
                return null;
            }
            ncd = NetcdfDataset.wrap((NetcdfFile)ncfile, (Set)NetcdfDataset.getEnhanceAll());
            FeatureDatasetPoint fd = (FeatureDatasetPoint)FeatureDatasetFactoryManager.wrap((FeatureType)FeatureType.STATION, (NetcdfDataset)ncd, null, (Formatter)(errlog = new Formatter()));
            if (fd == null) {
                res.sendError(400, errlog.toString());
                if (ncd != null) {
                    ncd.close();
                }
                return null;
            }
            return fd;
        }
        catch (FileNotFoundException e) {
            res.sendError(404, e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            res.sendError(500, e.getMessage());
        }
        if (ncd != null) {
            ncd.close();
        }
        return null;
    }

    public void show(Formatter f) {
        for (CollectionBean bean : this.collectionDatasets.values()) {
            f.format(" %s == %s%n", bean.getPath(), bean.getSpec());
        }
    }
}

