/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.dataset;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.dataset.DatasetException;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import thredds.util.TdsPathUtils;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;

public class TdsRequestedDataset {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean isRemote = false;
    private String path;

    public TdsRequestedDataset(HttpServletRequest request) throws DatasetException {
        this.path = TdsPathUtils.extractPath(request, null);
        if (this.path == null) {
            this.path = ServletUtil.getParameterIgnoreCase(request, "dataset");
            boolean bl = this.isRemote = this.path != null;
        }
        if (this.path == null) {
            this.log.debug("Request does not specify a dataset.");
            throw new DatasetException("Request does not specify a dataset.");
        }
    }

    public ucar.nc2.dt.GridDataset openAsGridDataset(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.isRemote ? GridDataset.open((String)this.path) : DatasetHandler.openGridDataset(request, response, this.path);
    }

    public NetcdfFile openAsNetcdfFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.isRemote ? NetcdfDataset.openDataset((String)this.path) : DatasetHandler.getNetcdfFile(request, response, this.path);
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    public String getPath() {
        return this.path;
    }
}

