/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.radarServer;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import thredds.catalog.query.Station;
import thredds.server.radarServer.RadarDatasetRepository;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class RadarServerUtil {
    @Autowired
    private RadarDatasetRepository radarDatasetRepository;
    public static final Pattern p_yymmdd_hhmm = Pattern.compile("(\\d{2})(\\d{4}_\\d{4})");
    public static final Pattern p_yyyymmdd_hhmm = Pattern.compile("(\\d{8}_\\d{4})");
    public static final String epic = "1970-01-01T00:00:00";

    public static List<String> getStationNames(List<Station> stations) {
        ArrayList<String> result = new ArrayList<String>();
        for (Station s : stations) {
            result.add(s.getValue());
        }
        return result;
    }

    public static List<String> convert4to3stations(List<String> stations) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : stations) {
            if (s.length() == 4) {
                result.add(s.substring(1));
                continue;
            }
            result.add(s);
        }
        return result;
    }

    public static List<String> getStationNames(LatLonRect boundingBox, List<Station> stations) {
        LatLonPointImpl latlonPt = new LatLonPointImpl();
        ArrayList<String> result = new ArrayList<String>();
        for (Station s : stations) {
            latlonPt.set(s.getLocation().getLatitude(), s.getLocation().getLongitude());
            if (!boundingBox.contains((LatLonPoint)latlonPt)) continue;
            result.add(s.getValue());
        }
        return result;
    }

    public static String findClosestStation(double lat, double lon, List<Station> stations) {
        double cos = Math.cos(Math.toRadians(lat));
        Station min_station = stations.get(0);
        double min_dist = Double.MAX_VALUE;
        for (Station s : stations) {
            double dx;
            double lat1 = s.getLocation().getLatitude();
            double lon1 = LatLonPointImpl.lonNormal((double)s.getLocation().getLongitude(), (double)lon);
            double dy = Math.toRadians(lat - lat1);
            double dist = dy * dy + (dx = cos * Math.toRadians(lon - lon1)) * dx;
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            min_station = s;
        }
        return min_station.getValue();
    }

    public static String getObTimeISO(String product) {
        String date;
        StringBuffer dsb = new StringBuffer();
        Matcher m = p_yyyymmdd_hhmm.matcher(product);
        if (m.find(0)) {
            date = m.group(1);
        } else {
            Matcher mm = p_yymmdd_hhmm.matcher(product);
            if (mm.find(0)) {
                if (Integer.parseInt(mm.group(1)) > 69) {
                    dsb.append("19").append(mm.group(1)).append(mm.group(2));
                } else {
                    dsb.append("20").append(mm.group(1)).append(mm.group(2));
                }
                date = dsb.toString();
            } else {
                return epic;
            }
        }
        dsb.setLength(0);
        dsb.append(date.substring(0, 4)).append("-").append(date.substring(4, 6));
        dsb.append("-").append(date.substring(6, 8)).append("T").append(date.substring(9, 11));
        dsb.append(":").append(date.substring(11, 13)).append(":00");
        return dsb.toString();
    }

    public static String hhmm(String dateTime) {
        StringBuffer sb = new StringBuffer(dateTime.substring(11, 13));
        sb.append(dateTime.substring(14, 16));
        return sb.toString();
    }

    public static boolean isValidDay(String day, String yyyymmddStart, String yyyymmddEnd) {
        if (day.equals("all")) {
            return true;
        }
        return day.compareTo(yyyymmddStart) >= 0 && day.compareTo(yyyymmddEnd) <= 0;
    }

    public static boolean isValidDate(String dateReport, String dateStart, String dateEnd) {
        String date;
        Matcher m = p_yyyymmdd_hhmm.matcher(dateReport);
        if (m.find()) {
            date = m.group(1);
        } else {
            m = p_yymmdd_hhmm.matcher(dateReport);
            if (m.find()) {
                StringBuffer dsb = new StringBuffer();
                if (Integer.parseInt(m.group(1)) > 69) {
                    dsb.append("19").append(m.group(1)).append(m.group(2));
                } else {
                    dsb.append("20").append(m.group(1)).append(m.group(2));
                }
                date = dsb.toString();
            } else {
                return false;
            }
        }
        return date.compareTo(dateStart) >= 0 && date.compareTo(dateEnd) <= 0;
    }
}

