/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.views;

import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.AbstractView;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.util.ContentType;

public class InvCatalogXmlView
extends AbstractView {
    private static Logger log = LoggerFactory.getLogger(InvCatalogXmlView.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderMergedOutputModel(Map model, HttpServletRequest req, HttpServletResponse res) throws Exception {
        if (model == null || model.isEmpty()) {
            throw new IllegalArgumentException("Model must not be null or empty.");
        }
        if (!model.containsKey("catalog")) {
            throw new IllegalArgumentException("Model must contain \"catalog\" key.");
        }
        Object o = model.get("catalog");
        if (!(o instanceof InvCatalogImpl)) {
            throw new IllegalArgumentException("Model must contain an InvCatalogImpl object.");
        }
        InvCatalogImpl cat = (InvCatalogImpl)o;
        res.setContentType(ContentType.xml.getContentHeader());
        ServletOutputStream os = null;
        if (!req.getMethod().equals("HEAD")) {
            try {
                os = res.getOutputStream();
                InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)false);
                catFactory.writeXML(cat, (OutputStream)os);
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
    }
}

